<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadItem StructType
 * @subpackage Structs
 */
class DownloadItem extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The salesDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesDescription;
    /**
     * The quantityPricingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $quantityPricingSchedule;
    /**
     * The deferredRevenueAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferredRevenueAccount;
    /**
     * The onSpecial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $onSpecial;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isGcoCompliant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isGcoCompliant;
    /**
     * The offerSupport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $offerSupport;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The incomeAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incomeAccount;
    /**
     * The numOfAllowedDownloads
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numOfAllowedDownloads;
    /**
     * The daysBeforeExpiration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $daysBeforeExpiration;
    /**
     * The immediateDownload
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $immediateDownload;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The isFulfillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfillable;
    /**
     * The useMarginalRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useMarginalRates;
    /**
     * The overallQuantityPricingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overallQuantityPricingType;
    /**
     * The pricingGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $pricingGroup;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The itemRevenueCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemRevenueCategory;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The revenueRecognitionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueRecognitionRule;
    /**
     * The revRecForecastRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecForecastRule;
    /**
     * The revenueAllocationGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueAllocationGroup;
    /**
     * The createRevenuePlansOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createRevenuePlansOn;
    /**
     * The directRevenuePosting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $directRevenuePosting;
    /**
     * The storeDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDisplayName;
    /**
     * The storeDisplayThumbnail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayThumbnail;
    /**
     * The storeDisplayImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeDisplayImage;
    /**
     * The featuredDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $featuredDescription;
    /**
     * The storeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDescription;
    /**
     * The storeDetailedDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDetailedDescription;
    /**
     * The storeItemTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $storeItemTemplate;
    /**
     * The pageTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageTitle;
    /**
     * The metaTagHtml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $metaTagHtml;
    /**
     * The excludeFromSitemap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromSitemap;
    /**
     * The sitemapPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sitemapPriority;
    /**
     * The searchKeywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchKeywords;
    /**
     * The isDonationItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDonationItem;
    /**
     * The showDefaultDonationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showDefaultDonationAmount;
    /**
     * The maxDonationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maxDonationAmount;
    /**
     * The dontShowPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $dontShowPrice;
    /**
     * The noPriceMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noPriceMessage;
    /**
     * The outOfStockMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outOfStockMessage;
    /**
     * The outOfStockBehavior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outOfStockBehavior;
    /**
     * The relatedItemsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relatedItemsDescription;
    /**
     * The specialsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialsDescription;
    /**
     * The pricingMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingMatrix
     */
    public $pricingMatrix;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The siteCategoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SiteCategoryList
     */
    public $siteCategoryList;
    /**
     * The presentationItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PresentationItemList
     */
    public $presentationItemList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for DownloadItem
     * @uses DownloadItem::setCreatedDate()
     * @uses DownloadItem::setLastModifiedDate()
     * @uses DownloadItem::setCustomForm()
     * @uses DownloadItem::setSalesDescription()
     * @uses DownloadItem::setQuantityPricingSchedule()
     * @uses DownloadItem::setDeferredRevenueAccount()
     * @uses DownloadItem::setOnSpecial()
     * @uses DownloadItem::setItemId()
     * @uses DownloadItem::setUpcCode()
     * @uses DownloadItem::setDisplayName()
     * @uses DownloadItem::setParent()
     * @uses DownloadItem::setIsOnline()
     * @uses DownloadItem::setIsGcoCompliant()
     * @uses DownloadItem::setOfferSupport()
     * @uses DownloadItem::setIsInactive()
     * @uses DownloadItem::setAvailableToPartners()
     * @uses DownloadItem::setSubsidiaryList()
     * @uses DownloadItem::setDepartment()
     * @uses DownloadItem::setIncludeChildren()
     * @uses DownloadItem::setClass()
     * @uses DownloadItem::setLocation()
     * @uses DownloadItem::setIncomeAccount()
     * @uses DownloadItem::setNumOfAllowedDownloads()
     * @uses DownloadItem::setDaysBeforeExpiration()
     * @uses DownloadItem::setImmediateDownload()
     * @uses DownloadItem::setIsTaxable()
     * @uses DownloadItem::setIssueProduct()
     * @uses DownloadItem::setTaxSchedule()
     * @uses DownloadItem::setCostEstimateType()
     * @uses DownloadItem::setCostEstimate()
     * @uses DownloadItem::setBillingSchedule()
     * @uses DownloadItem::setIsFulfillable()
     * @uses DownloadItem::setUseMarginalRates()
     * @uses DownloadItem::setOverallQuantityPricingType()
     * @uses DownloadItem::setPricingGroup()
     * @uses DownloadItem::setRevRecSchedule()
     * @uses DownloadItem::setVsoePrice()
     * @uses DownloadItem::setVsoeSopGroup()
     * @uses DownloadItem::setVsoeDeferral()
     * @uses DownloadItem::setVsoePermitDiscount()
     * @uses DownloadItem::setVsoeDelivered()
     * @uses DownloadItem::setItemRevenueCategory()
     * @uses DownloadItem::setDeferRevRec()
     * @uses DownloadItem::setRevenueRecognitionRule()
     * @uses DownloadItem::setRevRecForecastRule()
     * @uses DownloadItem::setRevenueAllocationGroup()
     * @uses DownloadItem::setCreateRevenuePlansOn()
     * @uses DownloadItem::setDirectRevenuePosting()
     * @uses DownloadItem::setStoreDisplayName()
     * @uses DownloadItem::setStoreDisplayThumbnail()
     * @uses DownloadItem::setStoreDisplayImage()
     * @uses DownloadItem::setFeaturedDescription()
     * @uses DownloadItem::setStoreDescription()
     * @uses DownloadItem::setStoreDetailedDescription()
     * @uses DownloadItem::setStoreItemTemplate()
     * @uses DownloadItem::setPageTitle()
     * @uses DownloadItem::setMetaTagHtml()
     * @uses DownloadItem::setExcludeFromSitemap()
     * @uses DownloadItem::setSitemapPriority()
     * @uses DownloadItem::setSearchKeywords()
     * @uses DownloadItem::setIsDonationItem()
     * @uses DownloadItem::setShowDefaultDonationAmount()
     * @uses DownloadItem::setMaxDonationAmount()
     * @uses DownloadItem::setDontShowPrice()
     * @uses DownloadItem::setNoPriceMessage()
     * @uses DownloadItem::setOutOfStockMessage()
     * @uses DownloadItem::setOutOfStockBehavior()
     * @uses DownloadItem::setRelatedItemsDescription()
     * @uses DownloadItem::setSpecialsDescription()
     * @uses DownloadItem::setPricingMatrix()
     * @uses DownloadItem::setAccountingBookDetailList()
     * @uses DownloadItem::setSiteCategoryList()
     * @uses DownloadItem::setPresentationItemList()
     * @uses DownloadItem::setCustomFieldList()
     * @uses DownloadItem::setInternalId()
     * @uses DownloadItem::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param string $salesDescription
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @param bool $onSpecial
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param \StructType\RecordRef $parent
     * @param bool $isOnline
     * @param bool $isGcoCompliant
     * @param bool $offerSupport
     * @param bool $isInactive
     * @param bool $availableToPartners
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\RecordRef $department
     * @param bool $includeChildren
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $incomeAccount
     * @param int $numOfAllowedDownloads
     * @param int $daysBeforeExpiration
     * @param bool $immediateDownload
     * @param bool $isTaxable
     * @param \StructType\RecordRef $issueProduct
     * @param \StructType\RecordRef $taxSchedule
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param \StructType\RecordRef $billingSchedule
     * @param bool $isFulfillable
     * @param bool $useMarginalRates
     * @param string $overallQuantityPricingType
     * @param \StructType\RecordRef $pricingGroup
     * @param \StructType\RecordRef $revRecSchedule
     * @param float $vsoePrice
     * @param string $vsoeSopGroup
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $itemRevenueCategory
     * @param bool $deferRevRec
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @param \StructType\RecordRef $revRecForecastRule
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @param bool $directRevenuePosting
     * @param string $storeDisplayName
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @param \StructType\RecordRef $storeDisplayImage
     * @param string $featuredDescription
     * @param string $storeDescription
     * @param string $storeDetailedDescription
     * @param \StructType\RecordRef $storeItemTemplate
     * @param string $pageTitle
     * @param string $metaTagHtml
     * @param bool $excludeFromSitemap
     * @param string $sitemapPriority
     * @param string $searchKeywords
     * @param bool $isDonationItem
     * @param bool $showDefaultDonationAmount
     * @param float $maxDonationAmount
     * @param bool $dontShowPrice
     * @param string $noPriceMessage
     * @param string $outOfStockMessage
     * @param string $outOfStockBehavior
     * @param string $relatedItemsDescription
     * @param string $specialsDescription
     * @param \StructType\PricingMatrix $pricingMatrix
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\SiteCategoryList $siteCategoryList
     * @param \StructType\PresentationItemList $presentationItemList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $salesDescription = null, \StructType\RecordRef $quantityPricingSchedule = null, \StructType\RecordRef $deferredRevenueAccount = null, $onSpecial = null, $itemId = null, $upcCode = null, $displayName = null, \StructType\RecordRef $parent = null, $isOnline = null, $isGcoCompliant = null, $offerSupport = null, $isInactive = null, $availableToPartners = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\RecordRef $department = null, $includeChildren = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $incomeAccount = null, $numOfAllowedDownloads = null, $daysBeforeExpiration = null, $immediateDownload = null, $isTaxable = null, \StructType\RecordRef $issueProduct = null, \StructType\RecordRef $taxSchedule = null, $costEstimateType = null, $costEstimate = null, \StructType\RecordRef $billingSchedule = null, $isFulfillable = null, $useMarginalRates = null, $overallQuantityPricingType = null, \StructType\RecordRef $pricingGroup = null, \StructType\RecordRef $revRecSchedule = null, $vsoePrice = null, $vsoeSopGroup = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $itemRevenueCategory = null, $deferRevRec = null, \StructType\RecordRef $revenueRecognitionRule = null, \StructType\RecordRef $revRecForecastRule = null, \StructType\RecordRef $revenueAllocationGroup = null, \StructType\RecordRef $createRevenuePlansOn = null, $directRevenuePosting = null, $storeDisplayName = null, \StructType\RecordRef $storeDisplayThumbnail = null, \StructType\RecordRef $storeDisplayImage = null, $featuredDescription = null, $storeDescription = null, $storeDetailedDescription = null, \StructType\RecordRef $storeItemTemplate = null, $pageTitle = null, $metaTagHtml = null, $excludeFromSitemap = null, $sitemapPriority = null, $searchKeywords = null, $isDonationItem = null, $showDefaultDonationAmount = null, $maxDonationAmount = null, $dontShowPrice = null, $noPriceMessage = null, $outOfStockMessage = null, $outOfStockBehavior = null, $relatedItemsDescription = null, $specialsDescription = null, \StructType\PricingMatrix $pricingMatrix = null, \StructType\ItemAccountingBookDetailList $accountingBookDetailList = null, \StructType\SiteCategoryList $siteCategoryList = null, \StructType\PresentationItemList $presentationItemList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setSalesDescription($salesDescription)
            ->setQuantityPricingSchedule($quantityPricingSchedule)
            ->setDeferredRevenueAccount($deferredRevenueAccount)
            ->setOnSpecial($onSpecial)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setParent($parent)
            ->setIsOnline($isOnline)
            ->setIsGcoCompliant($isGcoCompliant)
            ->setOfferSupport($offerSupport)
            ->setIsInactive($isInactive)
            ->setAvailableToPartners($availableToPartners)
            ->setSubsidiaryList($subsidiaryList)
            ->setDepartment($department)
            ->setIncludeChildren($includeChildren)
            ->setClass($class)
            ->setLocation($location)
            ->setIncomeAccount($incomeAccount)
            ->setNumOfAllowedDownloads($numOfAllowedDownloads)
            ->setDaysBeforeExpiration($daysBeforeExpiration)
            ->setImmediateDownload($immediateDownload)
            ->setIsTaxable($isTaxable)
            ->setIssueProduct($issueProduct)
            ->setTaxSchedule($taxSchedule)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setBillingSchedule($billingSchedule)
            ->setIsFulfillable($isFulfillable)
            ->setUseMarginalRates($useMarginalRates)
            ->setOverallQuantityPricingType($overallQuantityPricingType)
            ->setPricingGroup($pricingGroup)
            ->setRevRecSchedule($revRecSchedule)
            ->setVsoePrice($vsoePrice)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setItemRevenueCategory($itemRevenueCategory)
            ->setDeferRevRec($deferRevRec)
            ->setRevenueRecognitionRule($revenueRecognitionRule)
            ->setRevRecForecastRule($revRecForecastRule)
            ->setRevenueAllocationGroup($revenueAllocationGroup)
            ->setCreateRevenuePlansOn($createRevenuePlansOn)
            ->setDirectRevenuePosting($directRevenuePosting)
            ->setStoreDisplayName($storeDisplayName)
            ->setStoreDisplayThumbnail($storeDisplayThumbnail)
            ->setStoreDisplayImage($storeDisplayImage)
            ->setFeaturedDescription($featuredDescription)
            ->setStoreDescription($storeDescription)
            ->setStoreDetailedDescription($storeDetailedDescription)
            ->setStoreItemTemplate($storeItemTemplate)
            ->setPageTitle($pageTitle)
            ->setMetaTagHtml($metaTagHtml)
            ->setExcludeFromSitemap($excludeFromSitemap)
            ->setSitemapPriority($sitemapPriority)
            ->setSearchKeywords($searchKeywords)
            ->setIsDonationItem($isDonationItem)
            ->setShowDefaultDonationAmount($showDefaultDonationAmount)
            ->setMaxDonationAmount($maxDonationAmount)
            ->setDontShowPrice($dontShowPrice)
            ->setNoPriceMessage($noPriceMessage)
            ->setOutOfStockMessage($outOfStockMessage)
            ->setOutOfStockBehavior($outOfStockBehavior)
            ->setRelatedItemsDescription($relatedItemsDescription)
            ->setSpecialsDescription($specialsDescription)
            ->setPricingMatrix($pricingMatrix)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setSiteCategoryList($siteCategoryList)
            ->setPresentationItemList($presentationItemList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\DownloadItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\DownloadItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\DownloadItem
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get salesDescription value
     * @return string|null
     */
    public function getSalesDescription()
    {
        return $this->salesDescription;
    }
    /**
     * Set salesDescription value
     * @param string $salesDescription
     * @return \StructType\DownloadItem
     */
    public function setSalesDescription($salesDescription = null)
    {
        // validation for constraint: string
        if (!is_null($salesDescription) && !is_string($salesDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDescription, true), gettype($salesDescription)), __LINE__);
        }
        $this->salesDescription = $salesDescription;
        return $this;
    }
    /**
     * Get quantityPricingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getQuantityPricingSchedule()
    {
        return $this->quantityPricingSchedule;
    }
    /**
     * Set quantityPricingSchedule value
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @return \StructType\DownloadItem
     */
    public function setQuantityPricingSchedule(\StructType\RecordRef $quantityPricingSchedule = null)
    {
        $this->quantityPricingSchedule = $quantityPricingSchedule;
        return $this;
    }
    /**
     * Get deferredRevenueAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferredRevenueAccount()
    {
        return $this->deferredRevenueAccount;
    }
    /**
     * Set deferredRevenueAccount value
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @return \StructType\DownloadItem
     */
    public function setDeferredRevenueAccount(\StructType\RecordRef $deferredRevenueAccount = null)
    {
        $this->deferredRevenueAccount = $deferredRevenueAccount;
        return $this;
    }
    /**
     * Get onSpecial value
     * @return bool|null
     */
    public function getOnSpecial()
    {
        return $this->onSpecial;
    }
    /**
     * Set onSpecial value
     * @param bool $onSpecial
     * @return \StructType\DownloadItem
     */
    public function setOnSpecial($onSpecial = null)
    {
        // validation for constraint: boolean
        if (!is_null($onSpecial) && !is_bool($onSpecial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onSpecial, true), gettype($onSpecial)), __LINE__);
        }
        $this->onSpecial = $onSpecial;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\DownloadItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\DownloadItem
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\DownloadItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\DownloadItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\DownloadItem
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isGcoCompliant value
     * @return bool|null
     */
    public function getIsGcoCompliant()
    {
        return $this->isGcoCompliant;
    }
    /**
     * Set isGcoCompliant value
     * @param bool $isGcoCompliant
     * @return \StructType\DownloadItem
     */
    public function setIsGcoCompliant($isGcoCompliant = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGcoCompliant) && !is_bool($isGcoCompliant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGcoCompliant, true), gettype($isGcoCompliant)), __LINE__);
        }
        $this->isGcoCompliant = $isGcoCompliant;
        return $this;
    }
    /**
     * Get offerSupport value
     * @return bool|null
     */
    public function getOfferSupport()
    {
        return $this->offerSupport;
    }
    /**
     * Set offerSupport value
     * @param bool $offerSupport
     * @return \StructType\DownloadItem
     */
    public function setOfferSupport($offerSupport = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerSupport) && !is_bool($offerSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerSupport, true), gettype($offerSupport)), __LINE__);
        }
        $this->offerSupport = $offerSupport;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\DownloadItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\DownloadItem
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\DownloadItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\DownloadItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\DownloadItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\DownloadItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\DownloadItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get incomeAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIncomeAccount()
    {
        return $this->incomeAccount;
    }
    /**
     * Set incomeAccount value
     * @param \StructType\RecordRef $incomeAccount
     * @return \StructType\DownloadItem
     */
    public function setIncomeAccount(\StructType\RecordRef $incomeAccount = null)
    {
        $this->incomeAccount = $incomeAccount;
        return $this;
    }
    /**
     * Get numOfAllowedDownloads value
     * @return int|null
     */
    public function getNumOfAllowedDownloads()
    {
        return $this->numOfAllowedDownloads;
    }
    /**
     * Set numOfAllowedDownloads value
     * @param int $numOfAllowedDownloads
     * @return \StructType\DownloadItem
     */
    public function setNumOfAllowedDownloads($numOfAllowedDownloads = null)
    {
        // validation for constraint: int
        if (!is_null($numOfAllowedDownloads) && !(is_int($numOfAllowedDownloads) || ctype_digit($numOfAllowedDownloads))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfAllowedDownloads, true), gettype($numOfAllowedDownloads)), __LINE__);
        }
        $this->numOfAllowedDownloads = $numOfAllowedDownloads;
        return $this;
    }
    /**
     * Get daysBeforeExpiration value
     * @return int|null
     */
    public function getDaysBeforeExpiration()
    {
        return $this->daysBeforeExpiration;
    }
    /**
     * Set daysBeforeExpiration value
     * @param int $daysBeforeExpiration
     * @return \StructType\DownloadItem
     */
    public function setDaysBeforeExpiration($daysBeforeExpiration = null)
    {
        // validation for constraint: int
        if (!is_null($daysBeforeExpiration) && !(is_int($daysBeforeExpiration) || ctype_digit($daysBeforeExpiration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysBeforeExpiration, true), gettype($daysBeforeExpiration)), __LINE__);
        }
        $this->daysBeforeExpiration = $daysBeforeExpiration;
        return $this;
    }
    /**
     * Get immediateDownload value
     * @return bool|null
     */
    public function getImmediateDownload()
    {
        return $this->immediateDownload;
    }
    /**
     * Set immediateDownload value
     * @param bool $immediateDownload
     * @return \StructType\DownloadItem
     */
    public function setImmediateDownload($immediateDownload = null)
    {
        // validation for constraint: boolean
        if (!is_null($immediateDownload) && !is_bool($immediateDownload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($immediateDownload, true), gettype($immediateDownload)), __LINE__);
        }
        $this->immediateDownload = $immediateDownload;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\DownloadItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\DownloadItem
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\DownloadItem
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\DownloadItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\DownloadItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\DownloadItem
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get isFulfillable value
     * @return bool|null
     */
    public function getIsFulfillable()
    {
        return $this->isFulfillable;
    }
    /**
     * Set isFulfillable value
     * @param bool $isFulfillable
     * @return \StructType\DownloadItem
     */
    public function setIsFulfillable($isFulfillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfillable) && !is_bool($isFulfillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfillable, true), gettype($isFulfillable)), __LINE__);
        }
        $this->isFulfillable = $isFulfillable;
        return $this;
    }
    /**
     * Get useMarginalRates value
     * @return bool|null
     */
    public function getUseMarginalRates()
    {
        return $this->useMarginalRates;
    }
    /**
     * Set useMarginalRates value
     * @param bool $useMarginalRates
     * @return \StructType\DownloadItem
     */
    public function setUseMarginalRates($useMarginalRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMarginalRates) && !is_bool($useMarginalRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMarginalRates, true), gettype($useMarginalRates)), __LINE__);
        }
        $this->useMarginalRates = $useMarginalRates;
        return $this;
    }
    /**
     * Get overallQuantityPricingType value
     * @return string|null
     */
    public function getOverallQuantityPricingType()
    {
        return $this->overallQuantityPricingType;
    }
    /**
     * Set overallQuantityPricingType value
     * @uses \EnumType\ItemOverallQuantityPricingType::valueIsValid()
     * @uses \EnumType\ItemOverallQuantityPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallQuantityPricingType
     * @return \StructType\DownloadItem
     */
    public function setOverallQuantityPricingType($overallQuantityPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOverallQuantityPricingType::valueIsValid($overallQuantityPricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOverallQuantityPricingType', is_array($overallQuantityPricingType) ? implode(', ', $overallQuantityPricingType) : var_export($overallQuantityPricingType, true), implode(', ', \EnumType\ItemOverallQuantityPricingType::getValidValues())), __LINE__);
        }
        $this->overallQuantityPricingType = $overallQuantityPricingType;
        return $this;
    }
    /**
     * Get pricingGroup value
     * @return \StructType\RecordRef|null
     */
    public function getPricingGroup()
    {
        return $this->pricingGroup;
    }
    /**
     * Set pricingGroup value
     * @param \StructType\RecordRef $pricingGroup
     * @return \StructType\DownloadItem
     */
    public function setPricingGroup(\StructType\RecordRef $pricingGroup = null)
    {
        $this->pricingGroup = $pricingGroup;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\DownloadItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\DownloadItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\DownloadItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\DownloadItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\DownloadItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\DownloadItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get itemRevenueCategory value
     * @return \StructType\RecordRef|null
     */
    public function getItemRevenueCategory()
    {
        return $this->itemRevenueCategory;
    }
    /**
     * Set itemRevenueCategory value
     * @param \StructType\RecordRef $itemRevenueCategory
     * @return \StructType\DownloadItem
     */
    public function setItemRevenueCategory(\StructType\RecordRef $itemRevenueCategory = null)
    {
        $this->itemRevenueCategory = $itemRevenueCategory;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\DownloadItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get revenueRecognitionRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueRecognitionRule()
    {
        return $this->revenueRecognitionRule;
    }
    /**
     * Set revenueRecognitionRule value
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @return \StructType\DownloadItem
     */
    public function setRevenueRecognitionRule(\StructType\RecordRef $revenueRecognitionRule = null)
    {
        $this->revenueRecognitionRule = $revenueRecognitionRule;
        return $this;
    }
    /**
     * Get revRecForecastRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecForecastRule()
    {
        return $this->revRecForecastRule;
    }
    /**
     * Set revRecForecastRule value
     * @param \StructType\RecordRef $revRecForecastRule
     * @return \StructType\DownloadItem
     */
    public function setRevRecForecastRule(\StructType\RecordRef $revRecForecastRule = null)
    {
        $this->revRecForecastRule = $revRecForecastRule;
        return $this;
    }
    /**
     * Get revenueAllocationGroup value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueAllocationGroup()
    {
        return $this->revenueAllocationGroup;
    }
    /**
     * Set revenueAllocationGroup value
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @return \StructType\DownloadItem
     */
    public function setRevenueAllocationGroup(\StructType\RecordRef $revenueAllocationGroup = null)
    {
        $this->revenueAllocationGroup = $revenueAllocationGroup;
        return $this;
    }
    /**
     * Get createRevenuePlansOn value
     * @return \StructType\RecordRef|null
     */
    public function getCreateRevenuePlansOn()
    {
        return $this->createRevenuePlansOn;
    }
    /**
     * Set createRevenuePlansOn value
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @return \StructType\DownloadItem
     */
    public function setCreateRevenuePlansOn(\StructType\RecordRef $createRevenuePlansOn = null)
    {
        $this->createRevenuePlansOn = $createRevenuePlansOn;
        return $this;
    }
    /**
     * Get directRevenuePosting value
     * @return bool|null
     */
    public function getDirectRevenuePosting()
    {
        return $this->directRevenuePosting;
    }
    /**
     * Set directRevenuePosting value
     * @param bool $directRevenuePosting
     * @return \StructType\DownloadItem
     */
    public function setDirectRevenuePosting($directRevenuePosting = null)
    {
        // validation for constraint: boolean
        if (!is_null($directRevenuePosting) && !is_bool($directRevenuePosting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directRevenuePosting, true), gettype($directRevenuePosting)), __LINE__);
        }
        $this->directRevenuePosting = $directRevenuePosting;
        return $this;
    }
    /**
     * Get storeDisplayName value
     * @return string|null
     */
    public function getStoreDisplayName()
    {
        return $this->storeDisplayName;
    }
    /**
     * Set storeDisplayName value
     * @param string $storeDisplayName
     * @return \StructType\DownloadItem
     */
    public function setStoreDisplayName($storeDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($storeDisplayName) && !is_string($storeDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDisplayName, true), gettype($storeDisplayName)), __LINE__);
        }
        $this->storeDisplayName = $storeDisplayName;
        return $this;
    }
    /**
     * Get storeDisplayThumbnail value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayThumbnail()
    {
        return $this->storeDisplayThumbnail;
    }
    /**
     * Set storeDisplayThumbnail value
     * @param \StructType\RecordRef $storeDisplayThumbnail
     * @return \StructType\DownloadItem
     */
    public function setStoreDisplayThumbnail(\StructType\RecordRef $storeDisplayThumbnail = null)
    {
        $this->storeDisplayThumbnail = $storeDisplayThumbnail;
        return $this;
    }
    /**
     * Get storeDisplayImage value
     * @return \StructType\RecordRef|null
     */
    public function getStoreDisplayImage()
    {
        return $this->storeDisplayImage;
    }
    /**
     * Set storeDisplayImage value
     * @param \StructType\RecordRef $storeDisplayImage
     * @return \StructType\DownloadItem
     */
    public function setStoreDisplayImage(\StructType\RecordRef $storeDisplayImage = null)
    {
        $this->storeDisplayImage = $storeDisplayImage;
        return $this;
    }
    /**
     * Get featuredDescription value
     * @return string|null
     */
    public function getFeaturedDescription()
    {
        return $this->featuredDescription;
    }
    /**
     * Set featuredDescription value
     * @param string $featuredDescription
     * @return \StructType\DownloadItem
     */
    public function setFeaturedDescription($featuredDescription = null)
    {
        // validation for constraint: string
        if (!is_null($featuredDescription) && !is_string($featuredDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuredDescription, true), gettype($featuredDescription)), __LINE__);
        }
        $this->featuredDescription = $featuredDescription;
        return $this;
    }
    /**
     * Get storeDescription value
     * @return string|null
     */
    public function getStoreDescription()
    {
        return $this->storeDescription;
    }
    /**
     * Set storeDescription value
     * @param string $storeDescription
     * @return \StructType\DownloadItem
     */
    public function setStoreDescription($storeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDescription) && !is_string($storeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDescription, true), gettype($storeDescription)), __LINE__);
        }
        $this->storeDescription = $storeDescription;
        return $this;
    }
    /**
     * Get storeDetailedDescription value
     * @return string|null
     */
    public function getStoreDetailedDescription()
    {
        return $this->storeDetailedDescription;
    }
    /**
     * Set storeDetailedDescription value
     * @param string $storeDetailedDescription
     * @return \StructType\DownloadItem
     */
    public function setStoreDetailedDescription($storeDetailedDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDetailedDescription) && !is_string($storeDetailedDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDetailedDescription, true), gettype($storeDetailedDescription)), __LINE__);
        }
        $this->storeDetailedDescription = $storeDetailedDescription;
        return $this;
    }
    /**
     * Get storeItemTemplate value
     * @return \StructType\RecordRef|null
     */
    public function getStoreItemTemplate()
    {
        return $this->storeItemTemplate;
    }
    /**
     * Set storeItemTemplate value
     * @param \StructType\RecordRef $storeItemTemplate
     * @return \StructType\DownloadItem
     */
    public function setStoreItemTemplate(\StructType\RecordRef $storeItemTemplate = null)
    {
        $this->storeItemTemplate = $storeItemTemplate;
        return $this;
    }
    /**
     * Get pageTitle value
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->pageTitle;
    }
    /**
     * Set pageTitle value
     * @param string $pageTitle
     * @return \StructType\DownloadItem
     */
    public function setPageTitle($pageTitle = null)
    {
        // validation for constraint: string
        if (!is_null($pageTitle) && !is_string($pageTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageTitle, true), gettype($pageTitle)), __LINE__);
        }
        $this->pageTitle = $pageTitle;
        return $this;
    }
    /**
     * Get metaTagHtml value
     * @return string|null
     */
    public function getMetaTagHtml()
    {
        return $this->metaTagHtml;
    }
    /**
     * Set metaTagHtml value
     * @param string $metaTagHtml
     * @return \StructType\DownloadItem
     */
    public function setMetaTagHtml($metaTagHtml = null)
    {
        // validation for constraint: string
        if (!is_null($metaTagHtml) && !is_string($metaTagHtml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metaTagHtml, true), gettype($metaTagHtml)), __LINE__);
        }
        $this->metaTagHtml = $metaTagHtml;
        return $this;
    }
    /**
     * Get excludeFromSitemap value
     * @return bool|null
     */
    public function getExcludeFromSitemap()
    {
        return $this->excludeFromSitemap;
    }
    /**
     * Set excludeFromSitemap value
     * @param bool $excludeFromSitemap
     * @return \StructType\DownloadItem
     */
    public function setExcludeFromSitemap($excludeFromSitemap = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromSitemap) && !is_bool($excludeFromSitemap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromSitemap, true), gettype($excludeFromSitemap)), __LINE__);
        }
        $this->excludeFromSitemap = $excludeFromSitemap;
        return $this;
    }
    /**
     * Get sitemapPriority value
     * @return string|null
     */
    public function getSitemapPriority()
    {
        return $this->sitemapPriority;
    }
    /**
     * Set sitemapPriority value
     * @uses \EnumType\SitemapPriority::valueIsValid()
     * @uses \EnumType\SitemapPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sitemapPriority
     * @return \StructType\DownloadItem
     */
    public function setSitemapPriority($sitemapPriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SitemapPriority::valueIsValid($sitemapPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SitemapPriority', is_array($sitemapPriority) ? implode(', ', $sitemapPriority) : var_export($sitemapPriority, true), implode(', ', \EnumType\SitemapPriority::getValidValues())), __LINE__);
        }
        $this->sitemapPriority = $sitemapPriority;
        return $this;
    }
    /**
     * Get searchKeywords value
     * @return string|null
     */
    public function getSearchKeywords()
    {
        return $this->searchKeywords;
    }
    /**
     * Set searchKeywords value
     * @param string $searchKeywords
     * @return \StructType\DownloadItem
     */
    public function setSearchKeywords($searchKeywords = null)
    {
        // validation for constraint: string
        if (!is_null($searchKeywords) && !is_string($searchKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchKeywords, true), gettype($searchKeywords)), __LINE__);
        }
        $this->searchKeywords = $searchKeywords;
        return $this;
    }
    /**
     * Get isDonationItem value
     * @return bool|null
     */
    public function getIsDonationItem()
    {
        return $this->isDonationItem;
    }
    /**
     * Set isDonationItem value
     * @param bool $isDonationItem
     * @return \StructType\DownloadItem
     */
    public function setIsDonationItem($isDonationItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDonationItem) && !is_bool($isDonationItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDonationItem, true), gettype($isDonationItem)), __LINE__);
        }
        $this->isDonationItem = $isDonationItem;
        return $this;
    }
    /**
     * Get showDefaultDonationAmount value
     * @return bool|null
     */
    public function getShowDefaultDonationAmount()
    {
        return $this->showDefaultDonationAmount;
    }
    /**
     * Set showDefaultDonationAmount value
     * @param bool $showDefaultDonationAmount
     * @return \StructType\DownloadItem
     */
    public function setShowDefaultDonationAmount($showDefaultDonationAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDefaultDonationAmount) && !is_bool($showDefaultDonationAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDefaultDonationAmount, true), gettype($showDefaultDonationAmount)), __LINE__);
        }
        $this->showDefaultDonationAmount = $showDefaultDonationAmount;
        return $this;
    }
    /**
     * Get maxDonationAmount value
     * @return float|null
     */
    public function getMaxDonationAmount()
    {
        return $this->maxDonationAmount;
    }
    /**
     * Set maxDonationAmount value
     * @param float $maxDonationAmount
     * @return \StructType\DownloadItem
     */
    public function setMaxDonationAmount($maxDonationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($maxDonationAmount) && !(is_float($maxDonationAmount) || is_numeric($maxDonationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxDonationAmount, true), gettype($maxDonationAmount)), __LINE__);
        }
        $this->maxDonationAmount = $maxDonationAmount;
        return $this;
    }
    /**
     * Get dontShowPrice value
     * @return bool|null
     */
    public function getDontShowPrice()
    {
        return $this->dontShowPrice;
    }
    /**
     * Set dontShowPrice value
     * @param bool $dontShowPrice
     * @return \StructType\DownloadItem
     */
    public function setDontShowPrice($dontShowPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($dontShowPrice) && !is_bool($dontShowPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dontShowPrice, true), gettype($dontShowPrice)), __LINE__);
        }
        $this->dontShowPrice = $dontShowPrice;
        return $this;
    }
    /**
     * Get noPriceMessage value
     * @return string|null
     */
    public function getNoPriceMessage()
    {
        return $this->noPriceMessage;
    }
    /**
     * Set noPriceMessage value
     * @param string $noPriceMessage
     * @return \StructType\DownloadItem
     */
    public function setNoPriceMessage($noPriceMessage = null)
    {
        // validation for constraint: string
        if (!is_null($noPriceMessage) && !is_string($noPriceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noPriceMessage, true), gettype($noPriceMessage)), __LINE__);
        }
        $this->noPriceMessage = $noPriceMessage;
        return $this;
    }
    /**
     * Get outOfStockMessage value
     * @return string|null
     */
    public function getOutOfStockMessage()
    {
        return $this->outOfStockMessage;
    }
    /**
     * Set outOfStockMessage value
     * @param string $outOfStockMessage
     * @return \StructType\DownloadItem
     */
    public function setOutOfStockMessage($outOfStockMessage = null)
    {
        // validation for constraint: string
        if (!is_null($outOfStockMessage) && !is_string($outOfStockMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outOfStockMessage, true), gettype($outOfStockMessage)), __LINE__);
        }
        $this->outOfStockMessage = $outOfStockMessage;
        return $this;
    }
    /**
     * Get outOfStockBehavior value
     * @return string|null
     */
    public function getOutOfStockBehavior()
    {
        return $this->outOfStockBehavior;
    }
    /**
     * Set outOfStockBehavior value
     * @uses \EnumType\ItemOutOfStockBehavior::valueIsValid()
     * @uses \EnumType\ItemOutOfStockBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outOfStockBehavior
     * @return \StructType\DownloadItem
     */
    public function setOutOfStockBehavior($outOfStockBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOutOfStockBehavior::valueIsValid($outOfStockBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOutOfStockBehavior', is_array($outOfStockBehavior) ? implode(', ', $outOfStockBehavior) : var_export($outOfStockBehavior, true), implode(', ', \EnumType\ItemOutOfStockBehavior::getValidValues())), __LINE__);
        }
        $this->outOfStockBehavior = $outOfStockBehavior;
        return $this;
    }
    /**
     * Get relatedItemsDescription value
     * @return string|null
     */
    public function getRelatedItemsDescription()
    {
        return $this->relatedItemsDescription;
    }
    /**
     * Set relatedItemsDescription value
     * @param string $relatedItemsDescription
     * @return \StructType\DownloadItem
     */
    public function setRelatedItemsDescription($relatedItemsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($relatedItemsDescription) && !is_string($relatedItemsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedItemsDescription, true), gettype($relatedItemsDescription)), __LINE__);
        }
        $this->relatedItemsDescription = $relatedItemsDescription;
        return $this;
    }
    /**
     * Get specialsDescription value
     * @return string|null
     */
    public function getSpecialsDescription()
    {
        return $this->specialsDescription;
    }
    /**
     * Set specialsDescription value
     * @param string $specialsDescription
     * @return \StructType\DownloadItem
     */
    public function setSpecialsDescription($specialsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($specialsDescription) && !is_string($specialsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialsDescription, true), gettype($specialsDescription)), __LINE__);
        }
        $this->specialsDescription = $specialsDescription;
        return $this;
    }
    /**
     * Get pricingMatrix value
     * @return \StructType\PricingMatrix|null
     */
    public function getPricingMatrix()
    {
        return $this->pricingMatrix;
    }
    /**
     * Set pricingMatrix value
     * @param \StructType\PricingMatrix $pricingMatrix
     * @return \StructType\DownloadItem
     */
    public function setPricingMatrix(\StructType\PricingMatrix $pricingMatrix = null)
    {
        $this->pricingMatrix = $pricingMatrix;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\ItemAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\DownloadItem
     */
    public function setAccountingBookDetailList(\StructType\ItemAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get siteCategoryList value
     * @return \StructType\SiteCategoryList|null
     */
    public function getSiteCategoryList()
    {
        return $this->siteCategoryList;
    }
    /**
     * Set siteCategoryList value
     * @param \StructType\SiteCategoryList $siteCategoryList
     * @return \StructType\DownloadItem
     */
    public function setSiteCategoryList(\StructType\SiteCategoryList $siteCategoryList = null)
    {
        $this->siteCategoryList = $siteCategoryList;
        return $this;
    }
    /**
     * Get presentationItemList value
     * @return \StructType\PresentationItemList|null
     */
    public function getPresentationItemList()
    {
        return $this->presentationItemList;
    }
    /**
     * Set presentationItemList value
     * @param \StructType\PresentationItemList $presentationItemList
     * @return \StructType\DownloadItem
     */
    public function setPresentationItemList(\StructType\PresentationItemList $presentationItemList = null)
    {
        $this->presentationItemList = $presentationItemList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\DownloadItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\DownloadItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\DownloadItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
