<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionList StructType
 * @subpackage Structs
 */
class DimensionList extends AbstractStructBase
{
    /**
     * The dimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DimensionRef[]
     */
    public $dimension;
    /**
     * Constructor method for DimensionList
     * @uses DimensionList::setDimension()
     * @param \StructType\DimensionRef[] $dimension
     */
    public function __construct(array $dimension = array())
    {
        $this
            ->setDimension($dimension);
    }
    /**
     * Get dimension value
     * @return \StructType\DimensionRef[]|null
     */
    public function getDimension()
    {
        return $this->dimension;
    }
    /**
     * This method is responsible for validating the values passed to the setDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDimensionForArrayConstraintsFromSetDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dimensionListDimensionItem) {
            // validation for constraint: itemType
            if (!$dimensionListDimensionItem instanceof \StructType\DimensionRef) {
                $invalidValues[] = is_object($dimensionListDimensionItem) ? get_class($dimensionListDimensionItem) : sprintf('%s(%s)', gettype($dimensionListDimensionItem), var_export($dimensionListDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dimension property can only contain items of type \StructType\DimensionRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dimension value
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionRef[] $dimension
     * @return \StructType\DimensionList
     */
    public function setDimension(array $dimension = array())
    {
        // validation for constraint: array
        if ('' !== ($dimensionArrayErrorMessage = self::validateDimensionForArrayConstraintsFromSetDimension($dimension))) {
            throw new \InvalidArgumentException($dimensionArrayErrorMessage, __LINE__);
        }
        $this->dimension = $dimension;
        return $this;
    }
    /**
     * Add item to dimension value
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionRef $item
     * @return \StructType\DimensionList
     */
    public function addToDimension(\StructType\DimensionRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DimensionRef) {
            throw new \InvalidArgumentException(sprintf('The dimension property can only contain items of type \StructType\DimensionRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dimension[] = $item;
        return $this;
    }
}
