<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositPayment StructType
 * @subpackage Structs
 */
class DepositPayment extends AbstractStructBase
{
    /**
     * The deposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deposit;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The docDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docDate;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The docNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $docNumber;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The refNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refNum;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The transactionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $transactionAmount;
    /**
     * The paymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $paymentAmount;
    /**
     * The lineId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lineId;
    /**
     * Constructor method for DepositPayment
     * @uses DepositPayment::setDeposit()
     * @uses DepositPayment::setId()
     * @uses DepositPayment::setDocDate()
     * @uses DepositPayment::setType()
     * @uses DepositPayment::setDocNumber()
     * @uses DepositPayment::setMemo()
     * @uses DepositPayment::setPaymentMethod()
     * @uses DepositPayment::setRefNum()
     * @uses DepositPayment::setEntity()
     * @uses DepositPayment::setCurrency()
     * @uses DepositPayment::setTransactionAmount()
     * @uses DepositPayment::setPaymentAmount()
     * @uses DepositPayment::setLineId()
     * @param bool $deposit
     * @param int $id
     * @param string $docDate
     * @param string $type
     * @param string $docNumber
     * @param string $memo
     * @param \StructType\RecordRef $paymentMethod
     * @param string $refNum
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $currency
     * @param float $transactionAmount
     * @param float $paymentAmount
     * @param int $lineId
     */
    public function __construct($deposit = null, $id = null, $docDate = null, $type = null, $docNumber = null, $memo = null, \StructType\RecordRef $paymentMethod = null, $refNum = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $currency = null, $transactionAmount = null, $paymentAmount = null, $lineId = null)
    {
        $this
            ->setDeposit($deposit)
            ->setId($id)
            ->setDocDate($docDate)
            ->setType($type)
            ->setDocNumber($docNumber)
            ->setMemo($memo)
            ->setPaymentMethod($paymentMethod)
            ->setRefNum($refNum)
            ->setEntity($entity)
            ->setCurrency($currency)
            ->setTransactionAmount($transactionAmount)
            ->setPaymentAmount($paymentAmount)
            ->setLineId($lineId);
    }
    /**
     * Get deposit value
     * @return bool|null
     */
    public function getDeposit()
    {
        return $this->deposit;
    }
    /**
     * Set deposit value
     * @param bool $deposit
     * @return \StructType\DepositPayment
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($deposit) && !is_bool($deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deposit, true), gettype($deposit)), __LINE__);
        }
        $this->deposit = $deposit;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DepositPayment
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\DepositPayment
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docDate, true), gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\DepositPayment
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\DepositPayment
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\DepositPayment
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\DepositPayment
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get refNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->refNum;
    }
    /**
     * Set refNum value
     * @param string $refNum
     * @return \StructType\DepositPayment
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->refNum = $refNum;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\DepositPayment
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\DepositPayment
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get transactionAmount value
     * @return float|null
     */
    public function getTransactionAmount()
    {
        return $this->transactionAmount;
    }
    /**
     * Set transactionAmount value
     * @param float $transactionAmount
     * @return \StructType\DepositPayment
     */
    public function setTransactionAmount($transactionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($transactionAmount) && !(is_float($transactionAmount) || is_numeric($transactionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transactionAmount, true), gettype($transactionAmount)), __LINE__);
        }
        $this->transactionAmount = $transactionAmount;
        return $this;
    }
    /**
     * Get paymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }
    /**
     * Set paymentAmount value
     * @param float $paymentAmount
     * @return \StructType\DepositPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->paymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get lineId value
     * @return int|null
     */
    public function getLineId()
    {
        return $this->lineId;
    }
    /**
     * Set lineId value
     * @param int $lineId
     * @return \StructType\DepositPayment
     */
    public function setLineId($lineId = null)
    {
        // validation for constraint: int
        if (!is_null($lineId) && !(is_int($lineId) || ctype_digit($lineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineId, true), gettype($lineId)), __LINE__);
        }
        $this->lineId = $lineId;
        return $this;
    }
}
