<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositCashBackList StructType
 * @subpackage Structs
 */
class DepositCashBackList extends AbstractStructBase
{
    /**
     * The depositCashBack
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DepositCashBack[]
     */
    public $depositCashBack;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for DepositCashBackList
     * @uses DepositCashBackList::setDepositCashBack()
     * @uses DepositCashBackList::setReplaceAll()
     * @param \StructType\DepositCashBack[] $depositCashBack
     * @param bool $replaceAll
     */
    public function __construct(array $depositCashBack = array(), $replaceAll = true)
    {
        $this
            ->setDepositCashBack($depositCashBack)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get depositCashBack value
     * @return \StructType\DepositCashBack[]|null
     */
    public function getDepositCashBack()
    {
        return $this->depositCashBack;
    }
    /**
     * This method is responsible for validating the values passed to the setDepositCashBack method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepositCashBack method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositCashBackForArrayConstraintsFromSetDepositCashBack(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $depositCashBackListDepositCashBackItem) {
            // validation for constraint: itemType
            if (!$depositCashBackListDepositCashBackItem instanceof \StructType\DepositCashBack) {
                $invalidValues[] = is_object($depositCashBackListDepositCashBackItem) ? get_class($depositCashBackListDepositCashBackItem) : sprintf('%s(%s)', gettype($depositCashBackListDepositCashBackItem), var_export($depositCashBackListDepositCashBackItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The depositCashBack property can only contain items of type \StructType\DepositCashBack, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set depositCashBack value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositCashBack[] $depositCashBack
     * @return \StructType\DepositCashBackList
     */
    public function setDepositCashBack(array $depositCashBack = array())
    {
        // validation for constraint: array
        if ('' !== ($depositCashBackArrayErrorMessage = self::validateDepositCashBackForArrayConstraintsFromSetDepositCashBack($depositCashBack))) {
            throw new \InvalidArgumentException($depositCashBackArrayErrorMessage, __LINE__);
        }
        $this->depositCashBack = $depositCashBack;
        return $this;
    }
    /**
     * Add item to depositCashBack value
     * @throws \InvalidArgumentException
     * @param \StructType\DepositCashBack $item
     * @return \StructType\DepositCashBackList
     */
    public function addToDepositCashBack(\StructType\DepositCashBack $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DepositCashBack) {
            throw new \InvalidArgumentException(sprintf('The depositCashBack property can only contain items of type \StructType\DepositCashBack, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->depositCashBack[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\DepositCashBackList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
