<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositApplication StructType
 * Meta information extracted from the WSDL
 * - type: tranCust:DepositApplication
 * @subpackage Structs
 */
class DepositApplication extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The arAcct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $arAcct;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The deposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deposit;
    /**
     * The depDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $depDate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The applied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $applied;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The unapplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unapplied;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The applyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DepositApplicationApplyList
     */
    public $applyList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for DepositApplication
     * @uses DepositApplication::setCreatedDate()
     * @uses DepositApplication::setLastModifiedDate()
     * @uses DepositApplication::setArAcct()
     * @uses DepositApplication::setStatus()
     * @uses DepositApplication::setCustomer()
     * @uses DepositApplication::setTranDate()
     * @uses DepositApplication::setPostingPeriod()
     * @uses DepositApplication::setDeposit()
     * @uses DepositApplication::setDepDate()
     * @uses DepositApplication::setCurrency()
     * @uses DepositApplication::setExchangeRate()
     * @uses DepositApplication::setMemo()
     * @uses DepositApplication::setSubsidiary()
     * @uses DepositApplication::setTotal()
     * @uses DepositApplication::setDepartment()
     * @uses DepositApplication::setApplied()
     * @uses DepositApplication::setClass()
     * @uses DepositApplication::setUnapplied()
     * @uses DepositApplication::setLocation()
     * @uses DepositApplication::setTranId()
     * @uses DepositApplication::setApplyList()
     * @uses DepositApplication::setAccountingBookDetailList()
     * @uses DepositApplication::setCustomFieldList()
     * @uses DepositApplication::setInternalId()
     * @uses DepositApplication::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $arAcct
     * @param string $status
     * @param \StructType\RecordRef $customer
     * @param string $tranDate
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $deposit
     * @param string $depDate
     * @param \StructType\RecordRef $currency
     * @param float $exchangeRate
     * @param string $memo
     * @param \StructType\RecordRef $subsidiary
     * @param float $total
     * @param \StructType\RecordRef $department
     * @param float $applied
     * @param \StructType\RecordRef $class
     * @param float $unapplied
     * @param \StructType\RecordRef $location
     * @param string $tranId
     * @param \StructType\DepositApplicationApplyList $applyList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $arAcct = null, $status = null, \StructType\RecordRef $customer = null, $tranDate = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $deposit = null, $depDate = null, \StructType\RecordRef $currency = null, $exchangeRate = null, $memo = null, \StructType\RecordRef $subsidiary = null, $total = null, \StructType\RecordRef $department = null, $applied = null, \StructType\RecordRef $class = null, $unapplied = null, \StructType\RecordRef $location = null, $tranId = null, \StructType\DepositApplicationApplyList $applyList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setArAcct($arAcct)
            ->setStatus($status)
            ->setCustomer($customer)
            ->setTranDate($tranDate)
            ->setPostingPeriod($postingPeriod)
            ->setDeposit($deposit)
            ->setDepDate($depDate)
            ->setCurrency($currency)
            ->setExchangeRate($exchangeRate)
            ->setMemo($memo)
            ->setSubsidiary($subsidiary)
            ->setTotal($total)
            ->setDepartment($department)
            ->setApplied($applied)
            ->setClass($class)
            ->setUnapplied($unapplied)
            ->setLocation($location)
            ->setTranId($tranId)
            ->setApplyList($applyList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\DepositApplication
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\DepositApplication
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get arAcct value
     * @return \StructType\RecordRef|null
     */
    public function getArAcct()
    {
        return $this->arAcct;
    }
    /**
     * Set arAcct value
     * @param \StructType\RecordRef $arAcct
     * @return \StructType\DepositApplication
     */
    public function setArAcct(\StructType\RecordRef $arAcct = null)
    {
        $this->arAcct = $arAcct;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\DepositApplication
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\DepositApplication
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\DepositApplication
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\DepositApplication
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get deposit value
     * @return \StructType\RecordRef|null
     */
    public function getDeposit()
    {
        return $this->deposit;
    }
    /**
     * Set deposit value
     * @param \StructType\RecordRef $deposit
     * @return \StructType\DepositApplication
     */
    public function setDeposit(\StructType\RecordRef $deposit = null)
    {
        $this->deposit = $deposit;
        return $this;
    }
    /**
     * Get depDate value
     * @return string|null
     */
    public function getDepDate()
    {
        return $this->depDate;
    }
    /**
     * Set depDate value
     * @param string $depDate
     * @return \StructType\DepositApplication
     */
    public function setDepDate($depDate = null)
    {
        // validation for constraint: string
        if (!is_null($depDate) && !is_string($depDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depDate, true), gettype($depDate)), __LINE__);
        }
        $this->depDate = $depDate;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\DepositApplication
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\DepositApplication
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\DepositApplication
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\DepositApplication
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\DepositApplication
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\DepositApplication
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get applied value
     * @return float|null
     */
    public function getApplied()
    {
        return $this->applied;
    }
    /**
     * Set applied value
     * @param float $applied
     * @return \StructType\DepositApplication
     */
    public function setApplied($applied = null)
    {
        // validation for constraint: float
        if (!is_null($applied) && !(is_float($applied) || is_numeric($applied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($applied, true), gettype($applied)), __LINE__);
        }
        $this->applied = $applied;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\DepositApplication
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get unapplied value
     * @return float|null
     */
    public function getUnapplied()
    {
        return $this->unapplied;
    }
    /**
     * Set unapplied value
     * @param float $unapplied
     * @return \StructType\DepositApplication
     */
    public function setUnapplied($unapplied = null)
    {
        // validation for constraint: float
        if (!is_null($unapplied) && !(is_float($unapplied) || is_numeric($unapplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unapplied, true), gettype($unapplied)), __LINE__);
        }
        $this->unapplied = $unapplied;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\DepositApplication
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\DepositApplication
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get applyList value
     * @return \StructType\DepositApplicationApplyList|null
     */
    public function getApplyList()
    {
        return $this->applyList;
    }
    /**
     * Set applyList value
     * @param \StructType\DepositApplicationApplyList $applyList
     * @return \StructType\DepositApplication
     */
    public function setApplyList(\StructType\DepositApplicationApplyList $applyList = null)
    {
        $this->applyList = $applyList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\DepositApplication
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\DepositApplication
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\DepositApplication
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\DepositApplication
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
