<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DemandPlan StructType
 * @subpackage Structs
 */
class DemandPlan extends AbstractStructBase
{
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The calculatedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $calculatedQuantity;
    /**
     * The periodDemandPlanList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PeriodDemandPlanList
     */
    public $periodDemandPlanList;
    /**
     * Constructor method for DemandPlan
     * @uses DemandPlan::setStartDate()
     * @uses DemandPlan::setEndDate()
     * @uses DemandPlan::setCalculatedQuantity()
     * @uses DemandPlan::setPeriodDemandPlanList()
     * @param string $startDate
     * @param string $endDate
     * @param float $calculatedQuantity
     * @param \StructType\PeriodDemandPlanList $periodDemandPlanList
     */
    public function __construct($startDate = null, $endDate = null, $calculatedQuantity = null, \StructType\PeriodDemandPlanList $periodDemandPlanList = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCalculatedQuantity($calculatedQuantity)
            ->setPeriodDemandPlanList($periodDemandPlanList);
    }
    /**
     * Get startDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\DemandPlan
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\DemandPlan
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get calculatedQuantity value
     * @return float|null
     */
    public function getCalculatedQuantity()
    {
        return $this->calculatedQuantity;
    }
    /**
     * Set calculatedQuantity value
     * @param float $calculatedQuantity
     * @return \StructType\DemandPlan
     */
    public function setCalculatedQuantity($calculatedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($calculatedQuantity) && !(is_float($calculatedQuantity) || is_numeric($calculatedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calculatedQuantity, true), gettype($calculatedQuantity)), __LINE__);
        }
        $this->calculatedQuantity = $calculatedQuantity;
        return $this;
    }
    /**
     * Get periodDemandPlanList value
     * @return \StructType\PeriodDemandPlanList|null
     */
    public function getPeriodDemandPlanList()
    {
        return $this->periodDemandPlanList;
    }
    /**
     * Set periodDemandPlanList value
     * @param \StructType\PeriodDemandPlanList $periodDemandPlanList
     * @return \StructType\DemandPlan
     */
    public function setPeriodDemandPlanList(\StructType\PeriodDemandPlanList $periodDemandPlanList = null)
    {
        $this->periodDemandPlanList = $periodDemandPlanList;
        return $this;
    }
}
