<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerTaxRegistrationList StructType
 * @subpackage Structs
 */
class CustomerTaxRegistrationList extends AbstractStructBase
{
    /**
     * The customerTaxRegistration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerTaxRegistration[]
     */
    public $customerTaxRegistration;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerTaxRegistrationList
     * @uses CustomerTaxRegistrationList::setCustomerTaxRegistration()
     * @uses CustomerTaxRegistrationList::setReplaceAll()
     * @param \StructType\CustomerTaxRegistration[] $customerTaxRegistration
     * @param bool $replaceAll
     */
    public function __construct(array $customerTaxRegistration = array(), $replaceAll = true)
    {
        $this
            ->setCustomerTaxRegistration($customerTaxRegistration)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get customerTaxRegistration value
     * @return \StructType\CustomerTaxRegistration[]|null
     */
    public function getCustomerTaxRegistration()
    {
        return $this->customerTaxRegistration;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerTaxRegistration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerTaxRegistration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerTaxRegistrationForArrayConstraintsFromSetCustomerTaxRegistration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTaxRegistrationListCustomerTaxRegistrationItem) {
            // validation for constraint: itemType
            if (!$customerTaxRegistrationListCustomerTaxRegistrationItem instanceof \StructType\CustomerTaxRegistration) {
                $invalidValues[] = is_object($customerTaxRegistrationListCustomerTaxRegistrationItem) ? get_class($customerTaxRegistrationListCustomerTaxRegistrationItem) : sprintf('%s(%s)', gettype($customerTaxRegistrationListCustomerTaxRegistrationItem), var_export($customerTaxRegistrationListCustomerTaxRegistrationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customerTaxRegistration property can only contain items of type \StructType\CustomerTaxRegistration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customerTaxRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerTaxRegistration[] $customerTaxRegistration
     * @return \StructType\CustomerTaxRegistrationList
     */
    public function setCustomerTaxRegistration(array $customerTaxRegistration = array())
    {
        // validation for constraint: array
        if ('' !== ($customerTaxRegistrationArrayErrorMessage = self::validateCustomerTaxRegistrationForArrayConstraintsFromSetCustomerTaxRegistration($customerTaxRegistration))) {
            throw new \InvalidArgumentException($customerTaxRegistrationArrayErrorMessage, __LINE__);
        }
        $this->customerTaxRegistration = $customerTaxRegistration;
        return $this;
    }
    /**
     * Add item to customerTaxRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerTaxRegistration $item
     * @return \StructType\CustomerTaxRegistrationList
     */
    public function addToCustomerTaxRegistration(\StructType\CustomerTaxRegistration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerTaxRegistration) {
            throw new \InvalidArgumentException(sprintf('The customerTaxRegistration property can only contain items of type \StructType\CustomerTaxRegistration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customerTaxRegistration[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerTaxRegistrationList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
