<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerStatus StructType
 * Meta information extracted from the WSDL
 * - type: listRel:CustomerStatus
 * @subpackage Structs
 */
class CustomerStatus extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The stage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stage;
    /**
     * The probability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $probability;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The includeInLeadReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeInLeadReports;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CustomerStatus
     * @uses CustomerStatus::setName()
     * @uses CustomerStatus::setStage()
     * @uses CustomerStatus::setProbability()
     * @uses CustomerStatus::setDescription()
     * @uses CustomerStatus::setIncludeInLeadReports()
     * @uses CustomerStatus::setIsInactive()
     * @uses CustomerStatus::setInternalId()
     * @uses CustomerStatus::setExternalId()
     * @param string $name
     * @param string $stage
     * @param float $probability
     * @param string $description
     * @param bool $includeInLeadReports
     * @param bool $isInactive
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $stage = null, $probability = null, $description = null, $includeInLeadReports = null, $isInactive = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setStage($stage)
            ->setProbability($probability)
            ->setDescription($description)
            ->setIncludeInLeadReports($includeInLeadReports)
            ->setIsInactive($isInactive)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomerStatus
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get stage value
     * @return string|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Set stage value
     * @uses \EnumType\CustomerStatusStage::valueIsValid()
     * @uses \EnumType\CustomerStatusStage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stage
     * @return \StructType\CustomerStatus
     */
    public function setStage($stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerStatusStage::valueIsValid($stage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomerStatusStage', is_array($stage) ? implode(', ', $stage) : var_export($stage, true), implode(', ', \EnumType\CustomerStatusStage::getValidValues())), __LINE__);
        }
        $this->stage = $stage;
        return $this;
    }
    /**
     * Get probability value
     * @return float|null
     */
    public function getProbability()
    {
        return $this->probability;
    }
    /**
     * Set probability value
     * @param float $probability
     * @return \StructType\CustomerStatus
     */
    public function setProbability($probability = null)
    {
        // validation for constraint: float
        if (!is_null($probability) && !(is_float($probability) || is_numeric($probability))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($probability, true), gettype($probability)), __LINE__);
        }
        $this->probability = $probability;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomerStatus
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get includeInLeadReports value
     * @return bool|null
     */
    public function getIncludeInLeadReports()
    {
        return $this->includeInLeadReports;
    }
    /**
     * Set includeInLeadReports value
     * @param bool $includeInLeadReports
     * @return \StructType\CustomerStatus
     */
    public function setIncludeInLeadReports($includeInLeadReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInLeadReports) && !is_bool($includeInLeadReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInLeadReports, true), gettype($includeInLeadReports)), __LINE__);
        }
        $this->includeInLeadReports = $includeInLeadReports;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\CustomerStatus
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomerStatus
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CustomerStatus
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
