<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerRefund StructType
 * Meta information extracted from the WSDL
 * - type: tranCust:CustomerRefund
 * @subpackage Structs
 */
class CustomerRefund extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The transactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionNumber;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The arAcct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $arAcct;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The voidJournal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $voidJournal;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The debitCardIssueNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $debitCardIssueNo;
    /**
     * The creditCardProcessor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $creditCardProcessor;
    /**
     * The chargeIt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $chargeIt;
    /**
     * The pnRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pnRefNum;
    /**
     * The validFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validFrom;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The paymentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentOption;
    /**
     * The inputAuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inputAuthCode;
    /**
     * The inputReferenceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inputReferenceCode;
    /**
     * The checkNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $checkNumber;
    /**
     * The paymentCardCsc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentCardCsc;
    /**
     * The paymentProcessingProfile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentProcessingProfile;
    /**
     * The handlingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingMode;
    /**
     * The outputAuthCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputAuthCode;
    /**
     * The outputReferenceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputReferenceCode;
    /**
     * The paymentOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentOperation;
    /**
     * The dynamicDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dynamicDescriptor;
    /**
     * The creditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $creditCard;
    /**
     * The ccIsPurchaseCardBin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccIsPurchaseCardBin;
    /**
     * The ccNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccNumber;
    /**
     * The ccProcessAsPurchaseCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccProcessAsPurchaseCard;
    /**
     * The ccExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccExpireDate;
    /**
     * The ccName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccName;
    /**
     * The ccStreet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccStreet;
    /**
     * The ccZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccZipCode;
    /**
     * The ccApproved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccApproved;
    /**
     * The applyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerRefundApplyList
     */
    public $applyList;
    /**
     * The depositList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerRefundDepositList
     */
    public $depositList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The payeeAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payeeAddressList;
    /**
     * The payeeAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $payeeAddress;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CustomerRefund
     * @uses CustomerRefund::setCreatedDate()
     * @uses CustomerRefund::setLastModifiedDate()
     * @uses CustomerRefund::setStatus()
     * @uses CustomerRefund::setTransactionNumber()
     * @uses CustomerRefund::setCustomer()
     * @uses CustomerRefund::setCustomForm()
     * @uses CustomerRefund::setBalance()
     * @uses CustomerRefund::setArAcct()
     * @uses CustomerRefund::setCurrencyName()
     * @uses CustomerRefund::setExchangeRate()
     * @uses CustomerRefund::setTotal()
     * @uses CustomerRefund::setCurrency()
     * @uses CustomerRefund::setTranDate()
     * @uses CustomerRefund::setVoidJournal()
     * @uses CustomerRefund::setPostingPeriod()
     * @uses CustomerRefund::setMemo()
     * @uses CustomerRefund::setPaymentMethod()
     * @uses CustomerRefund::setAccount()
     * @uses CustomerRefund::setToBePrinted()
     * @uses CustomerRefund::setTranId()
     * @uses CustomerRefund::setDebitCardIssueNo()
     * @uses CustomerRefund::setCreditCardProcessor()
     * @uses CustomerRefund::setChargeIt()
     * @uses CustomerRefund::setPnRefNum()
     * @uses CustomerRefund::setValidFrom()
     * @uses CustomerRefund::setSubsidiary()
     * @uses CustomerRefund::setDepartment()
     * @uses CustomerRefund::setClass()
     * @uses CustomerRefund::setLocation()
     * @uses CustomerRefund::setPaymentOption()
     * @uses CustomerRefund::setInputAuthCode()
     * @uses CustomerRefund::setInputReferenceCode()
     * @uses CustomerRefund::setCheckNumber()
     * @uses CustomerRefund::setPaymentCardCsc()
     * @uses CustomerRefund::setPaymentProcessingProfile()
     * @uses CustomerRefund::setHandlingMode()
     * @uses CustomerRefund::setOutputAuthCode()
     * @uses CustomerRefund::setOutputReferenceCode()
     * @uses CustomerRefund::setPaymentOperation()
     * @uses CustomerRefund::setDynamicDescriptor()
     * @uses CustomerRefund::setCreditCard()
     * @uses CustomerRefund::setCcIsPurchaseCardBin()
     * @uses CustomerRefund::setCcNumber()
     * @uses CustomerRefund::setCcProcessAsPurchaseCard()
     * @uses CustomerRefund::setCcExpireDate()
     * @uses CustomerRefund::setCcName()
     * @uses CustomerRefund::setCcStreet()
     * @uses CustomerRefund::setCcZipCode()
     * @uses CustomerRefund::setCcApproved()
     * @uses CustomerRefund::setApplyList()
     * @uses CustomerRefund::setDepositList()
     * @uses CustomerRefund::setAccountingBookDetailList()
     * @uses CustomerRefund::setPayeeAddressList()
     * @uses CustomerRefund::setPayeeAddress()
     * @uses CustomerRefund::setCustomFieldList()
     * @uses CustomerRefund::setInternalId()
     * @uses CustomerRefund::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $status
     * @param string $transactionNumber
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRef $customForm
     * @param float $balance
     * @param \StructType\RecordRef $arAcct
     * @param string $currencyName
     * @param float $exchangeRate
     * @param float $total
     * @param \StructType\RecordRef $currency
     * @param string $tranDate
     * @param \StructType\RecordRef $voidJournal
     * @param \StructType\RecordRef $postingPeriod
     * @param string $memo
     * @param \StructType\RecordRef $paymentMethod
     * @param \StructType\RecordRef $account
     * @param bool $toBePrinted
     * @param string $tranId
     * @param string $debitCardIssueNo
     * @param \StructType\RecordRef $creditCardProcessor
     * @param bool $chargeIt
     * @param string $pnRefNum
     * @param string $validFrom
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $paymentOption
     * @param string $inputAuthCode
     * @param string $inputReferenceCode
     * @param string $checkNumber
     * @param string $paymentCardCsc
     * @param \StructType\RecordRef $paymentProcessingProfile
     * @param string $handlingMode
     * @param string $outputAuthCode
     * @param string $outputReferenceCode
     * @param string $paymentOperation
     * @param string $dynamicDescriptor
     * @param \StructType\RecordRef $creditCard
     * @param bool $ccIsPurchaseCardBin
     * @param string $ccNumber
     * @param bool $ccProcessAsPurchaseCard
     * @param string $ccExpireDate
     * @param string $ccName
     * @param string $ccStreet
     * @param string $ccZipCode
     * @param bool $ccApproved
     * @param \StructType\CustomerRefundApplyList $applyList
     * @param \StructType\CustomerRefundDepositList $depositList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\RecordRef $payeeAddressList
     * @param \StructType\Address $payeeAddress
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $status = null, $transactionNumber = null, \StructType\RecordRef $customer = null, \StructType\RecordRef $customForm = null, $balance = null, \StructType\RecordRef $arAcct = null, $currencyName = null, $exchangeRate = null, $total = null, \StructType\RecordRef $currency = null, $tranDate = null, \StructType\RecordRef $voidJournal = null, \StructType\RecordRef $postingPeriod = null, $memo = null, \StructType\RecordRef $paymentMethod = null, \StructType\RecordRef $account = null, $toBePrinted = null, $tranId = null, $debitCardIssueNo = null, \StructType\RecordRef $creditCardProcessor = null, $chargeIt = null, $pnRefNum = null, $validFrom = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $paymentOption = null, $inputAuthCode = null, $inputReferenceCode = null, $checkNumber = null, $paymentCardCsc = null, \StructType\RecordRef $paymentProcessingProfile = null, $handlingMode = null, $outputAuthCode = null, $outputReferenceCode = null, $paymentOperation = null, $dynamicDescriptor = null, \StructType\RecordRef $creditCard = null, $ccIsPurchaseCardBin = null, $ccNumber = null, $ccProcessAsPurchaseCard = null, $ccExpireDate = null, $ccName = null, $ccStreet = null, $ccZipCode = null, $ccApproved = null, \StructType\CustomerRefundApplyList $applyList = null, \StructType\CustomerRefundDepositList $depositList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\RecordRef $payeeAddressList = null, \StructType\Address $payeeAddress = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setStatus($status)
            ->setTransactionNumber($transactionNumber)
            ->setCustomer($customer)
            ->setCustomForm($customForm)
            ->setBalance($balance)
            ->setArAcct($arAcct)
            ->setCurrencyName($currencyName)
            ->setExchangeRate($exchangeRate)
            ->setTotal($total)
            ->setCurrency($currency)
            ->setTranDate($tranDate)
            ->setVoidJournal($voidJournal)
            ->setPostingPeriod($postingPeriod)
            ->setMemo($memo)
            ->setPaymentMethod($paymentMethod)
            ->setAccount($account)
            ->setToBePrinted($toBePrinted)
            ->setTranId($tranId)
            ->setDebitCardIssueNo($debitCardIssueNo)
            ->setCreditCardProcessor($creditCardProcessor)
            ->setChargeIt($chargeIt)
            ->setPnRefNum($pnRefNum)
            ->setValidFrom($validFrom)
            ->setSubsidiary($subsidiary)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setPaymentOption($paymentOption)
            ->setInputAuthCode($inputAuthCode)
            ->setInputReferenceCode($inputReferenceCode)
            ->setCheckNumber($checkNumber)
            ->setPaymentCardCsc($paymentCardCsc)
            ->setPaymentProcessingProfile($paymentProcessingProfile)
            ->setHandlingMode($handlingMode)
            ->setOutputAuthCode($outputAuthCode)
            ->setOutputReferenceCode($outputReferenceCode)
            ->setPaymentOperation($paymentOperation)
            ->setDynamicDescriptor($dynamicDescriptor)
            ->setCreditCard($creditCard)
            ->setCcIsPurchaseCardBin($ccIsPurchaseCardBin)
            ->setCcNumber($ccNumber)
            ->setCcProcessAsPurchaseCard($ccProcessAsPurchaseCard)
            ->setCcExpireDate($ccExpireDate)
            ->setCcName($ccName)
            ->setCcStreet($ccStreet)
            ->setCcZipCode($ccZipCode)
            ->setCcApproved($ccApproved)
            ->setApplyList($applyList)
            ->setDepositList($depositList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setPayeeAddressList($payeeAddressList)
            ->setPayeeAddress($payeeAddress)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\CustomerRefund
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\CustomerRefund
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CustomerRefund
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get transactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }
    /**
     * Set transactionNumber value
     * @param string $transactionNumber
     * @return \StructType\CustomerRefund
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->transactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\CustomerRefund
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\CustomerRefund
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\CustomerRefund
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get arAcct value
     * @return \StructType\RecordRef|null
     */
    public function getArAcct()
    {
        return $this->arAcct;
    }
    /**
     * Set arAcct value
     * @param \StructType\RecordRef $arAcct
     * @return \StructType\CustomerRefund
     */
    public function setArAcct(\StructType\RecordRef $arAcct = null)
    {
        $this->arAcct = $arAcct;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\CustomerRefund
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CustomerRefund
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\CustomerRefund
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CustomerRefund
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\CustomerRefund
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get voidJournal value
     * @return \StructType\RecordRef|null
     */
    public function getVoidJournal()
    {
        return $this->voidJournal;
    }
    /**
     * Set voidJournal value
     * @param \StructType\RecordRef $voidJournal
     * @return \StructType\CustomerRefund
     */
    public function setVoidJournal(\StructType\RecordRef $voidJournal = null)
    {
        $this->voidJournal = $voidJournal;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\CustomerRefund
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\CustomerRefund
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\CustomerRefund
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\CustomerRefund
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\CustomerRefund
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\CustomerRefund
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get debitCardIssueNo value
     * @return string|null
     */
    public function getDebitCardIssueNo()
    {
        return $this->debitCardIssueNo;
    }
    /**
     * Set debitCardIssueNo value
     * @param string $debitCardIssueNo
     * @return \StructType\CustomerRefund
     */
    public function setDebitCardIssueNo($debitCardIssueNo = null)
    {
        // validation for constraint: string
        if (!is_null($debitCardIssueNo) && !is_string($debitCardIssueNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debitCardIssueNo, true), gettype($debitCardIssueNo)), __LINE__);
        }
        $this->debitCardIssueNo = $debitCardIssueNo;
        return $this;
    }
    /**
     * Get creditCardProcessor value
     * @return \StructType\RecordRef|null
     */
    public function getCreditCardProcessor()
    {
        return $this->creditCardProcessor;
    }
    /**
     * Set creditCardProcessor value
     * @param \StructType\RecordRef $creditCardProcessor
     * @return \StructType\CustomerRefund
     */
    public function setCreditCardProcessor(\StructType\RecordRef $creditCardProcessor = null)
    {
        $this->creditCardProcessor = $creditCardProcessor;
        return $this;
    }
    /**
     * Get chargeIt value
     * @return bool|null
     */
    public function getChargeIt()
    {
        return $this->chargeIt;
    }
    /**
     * Set chargeIt value
     * @param bool $chargeIt
     * @return \StructType\CustomerRefund
     */
    public function setChargeIt($chargeIt = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargeIt) && !is_bool($chargeIt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chargeIt, true), gettype($chargeIt)), __LINE__);
        }
        $this->chargeIt = $chargeIt;
        return $this;
    }
    /**
     * Get pnRefNum value
     * @return string|null
     */
    public function getPnRefNum()
    {
        return $this->pnRefNum;
    }
    /**
     * Set pnRefNum value
     * @param string $pnRefNum
     * @return \StructType\CustomerRefund
     */
    public function setPnRefNum($pnRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($pnRefNum) && !is_string($pnRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pnRefNum, true), gettype($pnRefNum)), __LINE__);
        }
        $this->pnRefNum = $pnRefNum;
        return $this;
    }
    /**
     * Get validFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->validFrom;
    }
    /**
     * Set validFrom value
     * @param string $validFrom
     * @return \StructType\CustomerRefund
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->validFrom = $validFrom;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\CustomerRefund
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CustomerRefund
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CustomerRefund
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CustomerRefund
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get paymentOption value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentOption()
    {
        return $this->paymentOption;
    }
    /**
     * Set paymentOption value
     * @param \StructType\RecordRef $paymentOption
     * @return \StructType\CustomerRefund
     */
    public function setPaymentOption(\StructType\RecordRef $paymentOption = null)
    {
        $this->paymentOption = $paymentOption;
        return $this;
    }
    /**
     * Get inputAuthCode value
     * @return string|null
     */
    public function getInputAuthCode()
    {
        return $this->inputAuthCode;
    }
    /**
     * Set inputAuthCode value
     * @param string $inputAuthCode
     * @return \StructType\CustomerRefund
     */
    public function setInputAuthCode($inputAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputAuthCode) && !is_string($inputAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputAuthCode, true), gettype($inputAuthCode)), __LINE__);
        }
        $this->inputAuthCode = $inputAuthCode;
        return $this;
    }
    /**
     * Get inputReferenceCode value
     * @return string|null
     */
    public function getInputReferenceCode()
    {
        return $this->inputReferenceCode;
    }
    /**
     * Set inputReferenceCode value
     * @param string $inputReferenceCode
     * @return \StructType\CustomerRefund
     */
    public function setInputReferenceCode($inputReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputReferenceCode) && !is_string($inputReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputReferenceCode, true), gettype($inputReferenceCode)), __LINE__);
        }
        $this->inputReferenceCode = $inputReferenceCode;
        return $this;
    }
    /**
     * Get checkNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->checkNumber;
    }
    /**
     * Set checkNumber value
     * @param string $checkNumber
     * @return \StructType\CustomerRefund
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->checkNumber = $checkNumber;
        return $this;
    }
    /**
     * Get paymentCardCsc value
     * @return string|null
     */
    public function getPaymentCardCsc()
    {
        return $this->paymentCardCsc;
    }
    /**
     * Set paymentCardCsc value
     * @param string $paymentCardCsc
     * @return \StructType\CustomerRefund
     */
    public function setPaymentCardCsc($paymentCardCsc = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCardCsc) && !is_string($paymentCardCsc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCardCsc, true), gettype($paymentCardCsc)), __LINE__);
        }
        $this->paymentCardCsc = $paymentCardCsc;
        return $this;
    }
    /**
     * Get paymentProcessingProfile value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentProcessingProfile()
    {
        return $this->paymentProcessingProfile;
    }
    /**
     * Set paymentProcessingProfile value
     * @param \StructType\RecordRef $paymentProcessingProfile
     * @return \StructType\CustomerRefund
     */
    public function setPaymentProcessingProfile(\StructType\RecordRef $paymentProcessingProfile = null)
    {
        $this->paymentProcessingProfile = $paymentProcessingProfile;
        return $this;
    }
    /**
     * Get handlingMode value
     * @return string|null
     */
    public function getHandlingMode()
    {
        return $this->handlingMode;
    }
    /**
     * Set handlingMode value
     * @uses \EnumType\CustomerRefundHandlingMode::valueIsValid()
     * @uses \EnumType\CustomerRefundHandlingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $handlingMode
     * @return \StructType\CustomerRefund
     */
    public function setHandlingMode($handlingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerRefundHandlingMode::valueIsValid($handlingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomerRefundHandlingMode', is_array($handlingMode) ? implode(', ', $handlingMode) : var_export($handlingMode, true), implode(', ', \EnumType\CustomerRefundHandlingMode::getValidValues())), __LINE__);
        }
        $this->handlingMode = $handlingMode;
        return $this;
    }
    /**
     * Get outputAuthCode value
     * @return string|null
     */
    public function getOutputAuthCode()
    {
        return $this->outputAuthCode;
    }
    /**
     * Set outputAuthCode value
     * @param string $outputAuthCode
     * @return \StructType\CustomerRefund
     */
    public function setOutputAuthCode($outputAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($outputAuthCode) && !is_string($outputAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputAuthCode, true), gettype($outputAuthCode)), __LINE__);
        }
        $this->outputAuthCode = $outputAuthCode;
        return $this;
    }
    /**
     * Get outputReferenceCode value
     * @return string|null
     */
    public function getOutputReferenceCode()
    {
        return $this->outputReferenceCode;
    }
    /**
     * Set outputReferenceCode value
     * @param string $outputReferenceCode
     * @return \StructType\CustomerRefund
     */
    public function setOutputReferenceCode($outputReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($outputReferenceCode) && !is_string($outputReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputReferenceCode, true), gettype($outputReferenceCode)), __LINE__);
        }
        $this->outputReferenceCode = $outputReferenceCode;
        return $this;
    }
    /**
     * Get paymentOperation value
     * @return string|null
     */
    public function getPaymentOperation()
    {
        return $this->paymentOperation;
    }
    /**
     * Set paymentOperation value
     * @uses \EnumType\CustomerRefundPaymentOperation::valueIsValid()
     * @uses \EnumType\CustomerRefundPaymentOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentOperation
     * @return \StructType\CustomerRefund
     */
    public function setPaymentOperation($paymentOperation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerRefundPaymentOperation::valueIsValid($paymentOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomerRefundPaymentOperation', is_array($paymentOperation) ? implode(', ', $paymentOperation) : var_export($paymentOperation, true), implode(', ', \EnumType\CustomerRefundPaymentOperation::getValidValues())), __LINE__);
        }
        $this->paymentOperation = $paymentOperation;
        return $this;
    }
    /**
     * Get dynamicDescriptor value
     * @return string|null
     */
    public function getDynamicDescriptor()
    {
        return $this->dynamicDescriptor;
    }
    /**
     * Set dynamicDescriptor value
     * @param string $dynamicDescriptor
     * @return \StructType\CustomerRefund
     */
    public function setDynamicDescriptor($dynamicDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicDescriptor) && !is_string($dynamicDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicDescriptor, true), gettype($dynamicDescriptor)), __LINE__);
        }
        $this->dynamicDescriptor = $dynamicDescriptor;
        return $this;
    }
    /**
     * Get creditCard value
     * @return \StructType\RecordRef|null
     */
    public function getCreditCard()
    {
        return $this->creditCard;
    }
    /**
     * Set creditCard value
     * @param \StructType\RecordRef $creditCard
     * @return \StructType\CustomerRefund
     */
    public function setCreditCard(\StructType\RecordRef $creditCard = null)
    {
        $this->creditCard = $creditCard;
        return $this;
    }
    /**
     * Get ccIsPurchaseCardBin value
     * @return bool|null
     */
    public function getCcIsPurchaseCardBin()
    {
        return $this->ccIsPurchaseCardBin;
    }
    /**
     * Set ccIsPurchaseCardBin value
     * @param bool $ccIsPurchaseCardBin
     * @return \StructType\CustomerRefund
     */
    public function setCcIsPurchaseCardBin($ccIsPurchaseCardBin = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccIsPurchaseCardBin) && !is_bool($ccIsPurchaseCardBin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccIsPurchaseCardBin, true), gettype($ccIsPurchaseCardBin)), __LINE__);
        }
        $this->ccIsPurchaseCardBin = $ccIsPurchaseCardBin;
        return $this;
    }
    /**
     * Get ccNumber value
     * @return string|null
     */
    public function getCcNumber()
    {
        return $this->ccNumber;
    }
    /**
     * Set ccNumber value
     * @param string $ccNumber
     * @return \StructType\CustomerRefund
     */
    public function setCcNumber($ccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumber) && !is_string($ccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumber, true), gettype($ccNumber)), __LINE__);
        }
        $this->ccNumber = $ccNumber;
        return $this;
    }
    /**
     * Get ccProcessAsPurchaseCard value
     * @return bool|null
     */
    public function getCcProcessAsPurchaseCard()
    {
        return $this->ccProcessAsPurchaseCard;
    }
    /**
     * Set ccProcessAsPurchaseCard value
     * @param bool $ccProcessAsPurchaseCard
     * @return \StructType\CustomerRefund
     */
    public function setCcProcessAsPurchaseCard($ccProcessAsPurchaseCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccProcessAsPurchaseCard) && !is_bool($ccProcessAsPurchaseCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccProcessAsPurchaseCard, true), gettype($ccProcessAsPurchaseCard)), __LINE__);
        }
        $this->ccProcessAsPurchaseCard = $ccProcessAsPurchaseCard;
        return $this;
    }
    /**
     * Get ccExpireDate value
     * @return string|null
     */
    public function getCcExpireDate()
    {
        return $this->ccExpireDate;
    }
    /**
     * Set ccExpireDate value
     * @param string $ccExpireDate
     * @return \StructType\CustomerRefund
     */
    public function setCcExpireDate($ccExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($ccExpireDate) && !is_string($ccExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccExpireDate, true), gettype($ccExpireDate)), __LINE__);
        }
        $this->ccExpireDate = $ccExpireDate;
        return $this;
    }
    /**
     * Get ccName value
     * @return string|null
     */
    public function getCcName()
    {
        return $this->ccName;
    }
    /**
     * Set ccName value
     * @param string $ccName
     * @return \StructType\CustomerRefund
     */
    public function setCcName($ccName = null)
    {
        // validation for constraint: string
        if (!is_null($ccName) && !is_string($ccName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccName, true), gettype($ccName)), __LINE__);
        }
        $this->ccName = $ccName;
        return $this;
    }
    /**
     * Get ccStreet value
     * @return string|null
     */
    public function getCcStreet()
    {
        return $this->ccStreet;
    }
    /**
     * Set ccStreet value
     * @param string $ccStreet
     * @return \StructType\CustomerRefund
     */
    public function setCcStreet($ccStreet = null)
    {
        // validation for constraint: string
        if (!is_null($ccStreet) && !is_string($ccStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccStreet, true), gettype($ccStreet)), __LINE__);
        }
        $this->ccStreet = $ccStreet;
        return $this;
    }
    /**
     * Get ccZipCode value
     * @return string|null
     */
    public function getCcZipCode()
    {
        return $this->ccZipCode;
    }
    /**
     * Set ccZipCode value
     * @param string $ccZipCode
     * @return \StructType\CustomerRefund
     */
    public function setCcZipCode($ccZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($ccZipCode) && !is_string($ccZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccZipCode, true), gettype($ccZipCode)), __LINE__);
        }
        $this->ccZipCode = $ccZipCode;
        return $this;
    }
    /**
     * Get ccApproved value
     * @return bool|null
     */
    public function getCcApproved()
    {
        return $this->ccApproved;
    }
    /**
     * Set ccApproved value
     * @param bool $ccApproved
     * @return \StructType\CustomerRefund
     */
    public function setCcApproved($ccApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccApproved) && !is_bool($ccApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccApproved, true), gettype($ccApproved)), __LINE__);
        }
        $this->ccApproved = $ccApproved;
        return $this;
    }
    /**
     * Get applyList value
     * @return \StructType\CustomerRefundApplyList|null
     */
    public function getApplyList()
    {
        return $this->applyList;
    }
    /**
     * Set applyList value
     * @param \StructType\CustomerRefundApplyList $applyList
     * @return \StructType\CustomerRefund
     */
    public function setApplyList(\StructType\CustomerRefundApplyList $applyList = null)
    {
        $this->applyList = $applyList;
        return $this;
    }
    /**
     * Get depositList value
     * @return \StructType\CustomerRefundDepositList|null
     */
    public function getDepositList()
    {
        return $this->depositList;
    }
    /**
     * Set depositList value
     * @param \StructType\CustomerRefundDepositList $depositList
     * @return \StructType\CustomerRefund
     */
    public function setDepositList(\StructType\CustomerRefundDepositList $depositList = null)
    {
        $this->depositList = $depositList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\CustomerRefund
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get payeeAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getPayeeAddressList()
    {
        return $this->payeeAddressList;
    }
    /**
     * Set payeeAddressList value
     * @param \StructType\RecordRef $payeeAddressList
     * @return \StructType\CustomerRefund
     */
    public function setPayeeAddressList(\StructType\RecordRef $payeeAddressList = null)
    {
        $this->payeeAddressList = $payeeAddressList;
        return $this;
    }
    /**
     * Get payeeAddress value
     * @return \StructType\Address|null
     */
    public function getPayeeAddress()
    {
        return $this->payeeAddress;
    }
    /**
     * Set payeeAddress value
     * @param \StructType\Address $payeeAddress
     * @return \StructType\CustomerRefund
     */
    public function setPayeeAddress(\StructType\Address $payeeAddress = null)
    {
        $this->payeeAddress = $payeeAddress;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomerRefund
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomerRefund
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CustomerRefund
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
