<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPaymentDeposit StructType
 * @subpackage Structs
 */
class CustomerPaymentDeposit extends AbstractStructBase
{
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apply;
    /**
     * The doc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $doc;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The depositDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $depositDate;
    /**
     * The refNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refNum;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The remaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $remaining;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for CustomerPaymentDeposit
     * @uses CustomerPaymentDeposit::setApply()
     * @uses CustomerPaymentDeposit::setDoc()
     * @uses CustomerPaymentDeposit::setLine()
     * @uses CustomerPaymentDeposit::setDepositDate()
     * @uses CustomerPaymentDeposit::setRefNum()
     * @uses CustomerPaymentDeposit::setTotal()
     * @uses CustomerPaymentDeposit::setRemaining()
     * @uses CustomerPaymentDeposit::setCurrency()
     * @uses CustomerPaymentDeposit::setAmount()
     * @param bool $apply
     * @param int $doc
     * @param int $line
     * @param string $depositDate
     * @param string $refNum
     * @param float $total
     * @param float $remaining
     * @param string $currency
     * @param float $amount
     */
    public function __construct($apply = null, $doc = null, $line = null, $depositDate = null, $refNum = null, $total = null, $remaining = null, $currency = null, $amount = null)
    {
        $this
            ->setApply($apply)
            ->setDoc($doc)
            ->setLine($line)
            ->setDepositDate($depositDate)
            ->setRefNum($refNum)
            ->setTotal($total)
            ->setRemaining($remaining)
            ->setCurrency($currency)
            ->setAmount($amount);
    }
    /**
     * Get apply value
     * @return bool|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * Set apply value
     * @param bool $apply
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setApply($apply = null)
    {
        // validation for constraint: boolean
        if (!is_null($apply) && !is_bool($apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apply, true), gettype($apply)), __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Get doc value
     * @return int|null
     */
    public function getDoc()
    {
        return $this->doc;
    }
    /**
     * Set doc value
     * @param int $doc
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setDoc($doc = null)
    {
        // validation for constraint: int
        if (!is_null($doc) && !(is_int($doc) || ctype_digit($doc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doc, true), gettype($doc)), __LINE__);
        }
        $this->doc = $doc;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get depositDate value
     * @return string|null
     */
    public function getDepositDate()
    {
        return $this->depositDate;
    }
    /**
     * Set depositDate value
     * @param string $depositDate
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setDepositDate($depositDate = null)
    {
        // validation for constraint: string
        if (!is_null($depositDate) && !is_string($depositDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositDate, true), gettype($depositDate)), __LINE__);
        }
        $this->depositDate = $depositDate;
        return $this;
    }
    /**
     * Get refNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->refNum;
    }
    /**
     * Set refNum value
     * @param string $refNum
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->refNum = $refNum;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get remaining value
     * @return float|null
     */
    public function getRemaining()
    {
        return $this->remaining;
    }
    /**
     * Set remaining value
     * @param float $remaining
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: float
        if (!is_null($remaining) && !(is_float($remaining) || is_numeric($remaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remaining, true), gettype($remaining)), __LINE__);
        }
        $this->remaining = $remaining;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CustomerPaymentDeposit
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
