<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPaymentCreditList StructType
 * @subpackage Structs
 */
class CustomerPaymentCreditList extends AbstractStructBase
{
    /**
     * The credit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerPaymentCredit[]
     */
    public $credit;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerPaymentCreditList
     * @uses CustomerPaymentCreditList::setCredit()
     * @uses CustomerPaymentCreditList::setReplaceAll()
     * @param \StructType\CustomerPaymentCredit[] $credit
     * @param bool $replaceAll
     */
    public function __construct(array $credit = array(), $replaceAll = true)
    {
        $this
            ->setCredit($credit)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get credit value
     * @return \StructType\CustomerPaymentCredit[]|null
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * This method is responsible for validating the values passed to the setCredit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCredit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditForArrayConstraintsFromSetCredit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerPaymentCreditListCreditItem) {
            // validation for constraint: itemType
            if (!$customerPaymentCreditListCreditItem instanceof \StructType\CustomerPaymentCredit) {
                $invalidValues[] = is_object($customerPaymentCreditListCreditItem) ? get_class($customerPaymentCreditListCreditItem) : sprintf('%s(%s)', gettype($customerPaymentCreditListCreditItem), var_export($customerPaymentCreditListCreditItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The credit property can only contain items of type \StructType\CustomerPaymentCredit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set credit value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentCredit[] $credit
     * @return \StructType\CustomerPaymentCreditList
     */
    public function setCredit(array $credit = array())
    {
        // validation for constraint: array
        if ('' !== ($creditArrayErrorMessage = self::validateCreditForArrayConstraintsFromSetCredit($credit))) {
            throw new \InvalidArgumentException($creditArrayErrorMessage, __LINE__);
        }
        $this->credit = $credit;
        return $this;
    }
    /**
     * Add item to credit value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentCredit $item
     * @return \StructType\CustomerPaymentCreditList
     */
    public function addToCredit(\StructType\CustomerPaymentCredit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerPaymentCredit) {
            throw new \InvalidArgumentException(sprintf('The credit property can only contain items of type \StructType\CustomerPaymentCredit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->credit[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerPaymentCreditList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
