<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPaymentApplyList StructType
 * @subpackage Structs
 */
class CustomerPaymentApplyList extends AbstractStructBase
{
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerPaymentApply[]
     */
    public $apply;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerPaymentApplyList
     * @uses CustomerPaymentApplyList::setApply()
     * @uses CustomerPaymentApplyList::setReplaceAll()
     * @param \StructType\CustomerPaymentApply[] $apply
     * @param bool $replaceAll
     */
    public function __construct(array $apply = array(), $replaceAll = true)
    {
        $this
            ->setApply($apply)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get apply value
     * @return \StructType\CustomerPaymentApply[]|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * This method is responsible for validating the values passed to the setApply method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApply method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplyForArrayConstraintsFromSetApply(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerPaymentApplyListApplyItem) {
            // validation for constraint: itemType
            if (!$customerPaymentApplyListApplyItem instanceof \StructType\CustomerPaymentApply) {
                $invalidValues[] = is_object($customerPaymentApplyListApplyItem) ? get_class($customerPaymentApplyListApplyItem) : sprintf('%s(%s)', gettype($customerPaymentApplyListApplyItem), var_export($customerPaymentApplyListApplyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The apply property can only contain items of type \StructType\CustomerPaymentApply, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set apply value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentApply[] $apply
     * @return \StructType\CustomerPaymentApplyList
     */
    public function setApply(array $apply = array())
    {
        // validation for constraint: array
        if ('' !== ($applyArrayErrorMessage = self::validateApplyForArrayConstraintsFromSetApply($apply))) {
            throw new \InvalidArgumentException($applyArrayErrorMessage, __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Add item to apply value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentApply $item
     * @return \StructType\CustomerPaymentApplyList
     */
    public function addToApply(\StructType\CustomerPaymentApply $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerPaymentApply) {
            throw new \InvalidArgumentException(sprintf('The apply property can only contain items of type \StructType\CustomerPaymentApply, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->apply[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerPaymentApplyList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
