<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPaymentApply StructType
 * @subpackage Structs
 */
class CustomerPaymentApply extends AbstractStructBase
{
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apply;
    /**
     * The doc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $doc;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The applyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applyDate;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $job;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The refNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refNum;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The due
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $due;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The discDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discDate;
    /**
     * The discAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discAmt;
    /**
     * The disc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $disc;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for CustomerPaymentApply
     * @uses CustomerPaymentApply::setApply()
     * @uses CustomerPaymentApply::setDoc()
     * @uses CustomerPaymentApply::setLine()
     * @uses CustomerPaymentApply::setApplyDate()
     * @uses CustomerPaymentApply::setJob()
     * @uses CustomerPaymentApply::setType()
     * @uses CustomerPaymentApply::setRefNum()
     * @uses CustomerPaymentApply::setTotal()
     * @uses CustomerPaymentApply::setDue()
     * @uses CustomerPaymentApply::setCurrency()
     * @uses CustomerPaymentApply::setDiscDate()
     * @uses CustomerPaymentApply::setDiscAmt()
     * @uses CustomerPaymentApply::setDisc()
     * @uses CustomerPaymentApply::setAmount()
     * @param bool $apply
     * @param int $doc
     * @param int $line
     * @param string $applyDate
     * @param string $job
     * @param string $type
     * @param string $refNum
     * @param float $total
     * @param float $due
     * @param string $currency
     * @param string $discDate
     * @param float $discAmt
     * @param float $disc
     * @param float $amount
     */
    public function __construct($apply = null, $doc = null, $line = null, $applyDate = null, $job = null, $type = null, $refNum = null, $total = null, $due = null, $currency = null, $discDate = null, $discAmt = null, $disc = null, $amount = null)
    {
        $this
            ->setApply($apply)
            ->setDoc($doc)
            ->setLine($line)
            ->setApplyDate($applyDate)
            ->setJob($job)
            ->setType($type)
            ->setRefNum($refNum)
            ->setTotal($total)
            ->setDue($due)
            ->setCurrency($currency)
            ->setDiscDate($discDate)
            ->setDiscAmt($discAmt)
            ->setDisc($disc)
            ->setAmount($amount);
    }
    /**
     * Get apply value
     * @return bool|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * Set apply value
     * @param bool $apply
     * @return \StructType\CustomerPaymentApply
     */
    public function setApply($apply = null)
    {
        // validation for constraint: boolean
        if (!is_null($apply) && !is_bool($apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apply, true), gettype($apply)), __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Get doc value
     * @return int|null
     */
    public function getDoc()
    {
        return $this->doc;
    }
    /**
     * Set doc value
     * @param int $doc
     * @return \StructType\CustomerPaymentApply
     */
    public function setDoc($doc = null)
    {
        // validation for constraint: int
        if (!is_null($doc) && !(is_int($doc) || ctype_digit($doc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doc, true), gettype($doc)), __LINE__);
        }
        $this->doc = $doc;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\CustomerPaymentApply
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get applyDate value
     * @return string|null
     */
    public function getApplyDate()
    {
        return $this->applyDate;
    }
    /**
     * Set applyDate value
     * @param string $applyDate
     * @return \StructType\CustomerPaymentApply
     */
    public function setApplyDate($applyDate = null)
    {
        // validation for constraint: string
        if (!is_null($applyDate) && !is_string($applyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyDate, true), gettype($applyDate)), __LINE__);
        }
        $this->applyDate = $applyDate;
        return $this;
    }
    /**
     * Get job value
     * @return string|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param string $job
     * @return \StructType\CustomerPaymentApply
     */
    public function setJob($job = null)
    {
        // validation for constraint: string
        if (!is_null($job) && !is_string($job)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job, true), gettype($job)), __LINE__);
        }
        $this->job = $job;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CustomerPaymentApply
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get refNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->refNum;
    }
    /**
     * Set refNum value
     * @param string $refNum
     * @return \StructType\CustomerPaymentApply
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->refNum = $refNum;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\CustomerPaymentApply
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get due value
     * @return float|null
     */
    public function getDue()
    {
        return $this->due;
    }
    /**
     * Set due value
     * @param float $due
     * @return \StructType\CustomerPaymentApply
     */
    public function setDue($due = null)
    {
        // validation for constraint: float
        if (!is_null($due) && !(is_float($due) || is_numeric($due))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($due, true), gettype($due)), __LINE__);
        }
        $this->due = $due;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\CustomerPaymentApply
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get discDate value
     * @return string|null
     */
    public function getDiscDate()
    {
        return $this->discDate;
    }
    /**
     * Set discDate value
     * @param string $discDate
     * @return \StructType\CustomerPaymentApply
     */
    public function setDiscDate($discDate = null)
    {
        // validation for constraint: string
        if (!is_null($discDate) && !is_string($discDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discDate, true), gettype($discDate)), __LINE__);
        }
        $this->discDate = $discDate;
        return $this;
    }
    /**
     * Get discAmt value
     * @return float|null
     */
    public function getDiscAmt()
    {
        return $this->discAmt;
    }
    /**
     * Set discAmt value
     * @param float $discAmt
     * @return \StructType\CustomerPaymentApply
     */
    public function setDiscAmt($discAmt = null)
    {
        // validation for constraint: float
        if (!is_null($discAmt) && !(is_float($discAmt) || is_numeric($discAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discAmt, true), gettype($discAmt)), __LINE__);
        }
        $this->discAmt = $discAmt;
        return $this;
    }
    /**
     * Get disc value
     * @return float|null
     */
    public function getDisc()
    {
        return $this->disc;
    }
    /**
     * Set disc value
     * @param float $disc
     * @return \StructType\CustomerPaymentApply
     */
    public function setDisc($disc = null)
    {
        // validation for constraint: float
        if (!is_null($disc) && !(is_float($disc) || is_numeric($disc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disc, true), gettype($disc)), __LINE__);
        }
        $this->disc = $disc;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CustomerPaymentApply
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
