<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerGroupPricingList StructType
 * @subpackage Structs
 */
class CustomerGroupPricingList extends AbstractStructBase
{
    /**
     * The groupPricing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerGroupPricing[]
     */
    public $groupPricing;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerGroupPricingList
     * @uses CustomerGroupPricingList::setGroupPricing()
     * @uses CustomerGroupPricingList::setReplaceAll()
     * @param \StructType\CustomerGroupPricing[] $groupPricing
     * @param bool $replaceAll
     */
    public function __construct(array $groupPricing = array(), $replaceAll = true)
    {
        $this
            ->setGroupPricing($groupPricing)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get groupPricing value
     * @return \StructType\CustomerGroupPricing[]|null
     */
    public function getGroupPricing()
    {
        return $this->groupPricing;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupPricing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupPricing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupPricingForArrayConstraintsFromSetGroupPricing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerGroupPricingListGroupPricingItem) {
            // validation for constraint: itemType
            if (!$customerGroupPricingListGroupPricingItem instanceof \StructType\CustomerGroupPricing) {
                $invalidValues[] = is_object($customerGroupPricingListGroupPricingItem) ? get_class($customerGroupPricingListGroupPricingItem) : sprintf('%s(%s)', gettype($customerGroupPricingListGroupPricingItem), var_export($customerGroupPricingListGroupPricingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The groupPricing property can only contain items of type \StructType\CustomerGroupPricing, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set groupPricing value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerGroupPricing[] $groupPricing
     * @return \StructType\CustomerGroupPricingList
     */
    public function setGroupPricing(array $groupPricing = array())
    {
        // validation for constraint: array
        if ('' !== ($groupPricingArrayErrorMessage = self::validateGroupPricingForArrayConstraintsFromSetGroupPricing($groupPricing))) {
            throw new \InvalidArgumentException($groupPricingArrayErrorMessage, __LINE__);
        }
        $this->groupPricing = $groupPricing;
        return $this;
    }
    /**
     * Add item to groupPricing value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerGroupPricing $item
     * @return \StructType\CustomerGroupPricingList
     */
    public function addToGroupPricing(\StructType\CustomerGroupPricing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerGroupPricing) {
            throw new \InvalidArgumentException(sprintf('The groupPricing property can only contain items of type \StructType\CustomerGroupPricing, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->groupPricing[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerGroupPricingList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
