<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDownload StructType
 * @subpackage Structs
 */
class CustomerDownload extends AbstractStructBase
{
    /**
     * The file
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $file;
    /**
     * The licenseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licenseCode;
    /**
     * The remainingDownloads
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $remainingDownloads;
    /**
     * The expiration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expiration;
    /**
     * Constructor method for CustomerDownload
     * @uses CustomerDownload::setFile()
     * @uses CustomerDownload::setLicenseCode()
     * @uses CustomerDownload::setRemainingDownloads()
     * @uses CustomerDownload::setExpiration()
     * @param \StructType\RecordRef $file
     * @param string $licenseCode
     * @param int $remainingDownloads
     * @param string $expiration
     */
    public function __construct(\StructType\RecordRef $file = null, $licenseCode = null, $remainingDownloads = null, $expiration = null)
    {
        $this
            ->setFile($file)
            ->setLicenseCode($licenseCode)
            ->setRemainingDownloads($remainingDownloads)
            ->setExpiration($expiration);
    }
    /**
     * Get file value
     * @return \StructType\RecordRef|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param \StructType\RecordRef $file
     * @return \StructType\CustomerDownload
     */
    public function setFile(\StructType\RecordRef $file = null)
    {
        $this->file = $file;
        return $this;
    }
    /**
     * Get licenseCode value
     * @return string|null
     */
    public function getLicenseCode()
    {
        return $this->licenseCode;
    }
    /**
     * Set licenseCode value
     * @param string $licenseCode
     * @return \StructType\CustomerDownload
     */
    public function setLicenseCode($licenseCode = null)
    {
        // validation for constraint: string
        if (!is_null($licenseCode) && !is_string($licenseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseCode, true), gettype($licenseCode)), __LINE__);
        }
        $this->licenseCode = $licenseCode;
        return $this;
    }
    /**
     * Get remainingDownloads value
     * @return int|null
     */
    public function getRemainingDownloads()
    {
        return $this->remainingDownloads;
    }
    /**
     * Set remainingDownloads value
     * @param int $remainingDownloads
     * @return \StructType\CustomerDownload
     */
    public function setRemainingDownloads($remainingDownloads = null)
    {
        // validation for constraint: int
        if (!is_null($remainingDownloads) && !(is_int($remainingDownloads) || ctype_digit($remainingDownloads))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainingDownloads, true), gettype($remainingDownloads)), __LINE__);
        }
        $this->remainingDownloads = $remainingDownloads;
        return $this;
    }
    /**
     * Get expiration value
     * @return string|null
     */
    public function getExpiration()
    {
        return $this->expiration;
    }
    /**
     * Set expiration value
     * @param string $expiration
     * @return \StructType\CustomerDownload
     */
    public function setExpiration($expiration = null)
    {
        // validation for constraint: string
        if (!is_null($expiration) && !is_string($expiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration, true), gettype($expiration)), __LINE__);
        }
        $this->expiration = $expiration;
        return $this;
    }
}
