<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCurrencyList StructType
 * @subpackage Structs
 */
class CustomerCurrencyList extends AbstractStructBase
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerCurrency[]
     */
    public $currency;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerCurrencyList
     * @uses CustomerCurrencyList::setCurrency()
     * @uses CustomerCurrencyList::setReplaceAll()
     * @param \StructType\CustomerCurrency[] $currency
     * @param bool $replaceAll
     */
    public function __construct(array $currency = array(), $replaceAll = true)
    {
        $this
            ->setCurrency($currency)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get currency value
     * @return \StructType\CustomerCurrency[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerCurrencyListCurrencyItem) {
            // validation for constraint: itemType
            if (!$customerCurrencyListCurrencyItem instanceof \StructType\CustomerCurrency) {
                $invalidValues[] = is_object($customerCurrencyListCurrencyItem) ? get_class($customerCurrencyListCurrencyItem) : sprintf('%s(%s)', gettype($customerCurrencyListCurrencyItem), var_export($customerCurrencyListCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\CustomerCurrency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCurrency[] $currency
     * @return \StructType\CustomerCurrencyList
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCurrency $item
     * @return \StructType\CustomerCurrencyList
     */
    public function addToCurrency(\StructType\CustomerCurrency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerCurrency) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\CustomerCurrency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerCurrencyList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
