<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCreditCards StructType
 * @subpackage Structs
 */
class CustomerCreditCards extends AbstractStructBase
{
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The ccNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccNumber;
    /**
     * The ccExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccExpireDate;
    /**
     * The ccName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccName;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $paymentMethod;
    /**
     * The cardState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $cardState;
    /**
     * The stateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stateFrom;
    /**
     * The debitcardIssueNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $debitcardIssueNo;
    /**
     * The ccMemo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ccMemo;
    /**
     * The validfrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $validfrom;
    /**
     * The ccDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ccDefault;
    /**
     * Constructor method for CustomerCreditCards
     * @uses CustomerCreditCards::setInternalId()
     * @uses CustomerCreditCards::setCcNumber()
     * @uses CustomerCreditCards::setCcExpireDate()
     * @uses CustomerCreditCards::setCcName()
     * @uses CustomerCreditCards::setPaymentMethod()
     * @uses CustomerCreditCards::setCardState()
     * @uses CustomerCreditCards::setStateFrom()
     * @uses CustomerCreditCards::setDebitcardIssueNo()
     * @uses CustomerCreditCards::setCcMemo()
     * @uses CustomerCreditCards::setValidfrom()
     * @uses CustomerCreditCards::setCcDefault()
     * @param string $internalId
     * @param string $ccNumber
     * @param string $ccExpireDate
     * @param string $ccName
     * @param \StructType\RecordRef $paymentMethod
     * @param \StructType\RecordRef $cardState
     * @param string $stateFrom
     * @param string $debitcardIssueNo
     * @param string $ccMemo
     * @param string $validfrom
     * @param bool $ccDefault
     */
    public function __construct($internalId = null, $ccNumber = null, $ccExpireDate = null, $ccName = null, \StructType\RecordRef $paymentMethod = null, \StructType\RecordRef $cardState = null, $stateFrom = null, $debitcardIssueNo = null, $ccMemo = null, $validfrom = null, $ccDefault = null)
    {
        $this
            ->setInternalId($internalId)
            ->setCcNumber($ccNumber)
            ->setCcExpireDate($ccExpireDate)
            ->setCcName($ccName)
            ->setPaymentMethod($paymentMethod)
            ->setCardState($cardState)
            ->setStateFrom($stateFrom)
            ->setDebitcardIssueNo($debitcardIssueNo)
            ->setCcMemo($ccMemo)
            ->setValidfrom($validfrom)
            ->setCcDefault($ccDefault);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomerCreditCards
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get ccNumber value
     * @return string|null
     */
    public function getCcNumber()
    {
        return $this->ccNumber;
    }
    /**
     * Set ccNumber value
     * @param string $ccNumber
     * @return \StructType\CustomerCreditCards
     */
    public function setCcNumber($ccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumber) && !is_string($ccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumber, true), gettype($ccNumber)), __LINE__);
        }
        $this->ccNumber = $ccNumber;
        return $this;
    }
    /**
     * Get ccExpireDate value
     * @return string|null
     */
    public function getCcExpireDate()
    {
        return $this->ccExpireDate;
    }
    /**
     * Set ccExpireDate value
     * @param string $ccExpireDate
     * @return \StructType\CustomerCreditCards
     */
    public function setCcExpireDate($ccExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($ccExpireDate) && !is_string($ccExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccExpireDate, true), gettype($ccExpireDate)), __LINE__);
        }
        $this->ccExpireDate = $ccExpireDate;
        return $this;
    }
    /**
     * Get ccName value
     * @return string|null
     */
    public function getCcName()
    {
        return $this->ccName;
    }
    /**
     * Set ccName value
     * @param string $ccName
     * @return \StructType\CustomerCreditCards
     */
    public function setCcName($ccName = null)
    {
        // validation for constraint: string
        if (!is_null($ccName) && !is_string($ccName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccName, true), gettype($ccName)), __LINE__);
        }
        $this->ccName = $ccName;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \StructType\RecordRef|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param \StructType\RecordRef $paymentMethod
     * @return \StructType\CustomerCreditCards
     */
    public function setPaymentMethod(\StructType\RecordRef $paymentMethod = null)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get cardState value
     * @return \StructType\RecordRef|null
     */
    public function getCardState()
    {
        return $this->cardState;
    }
    /**
     * Set cardState value
     * @param \StructType\RecordRef $cardState
     * @return \StructType\CustomerCreditCards
     */
    public function setCardState(\StructType\RecordRef $cardState = null)
    {
        $this->cardState = $cardState;
        return $this;
    }
    /**
     * Get stateFrom value
     * @return string|null
     */
    public function getStateFrom()
    {
        return $this->stateFrom;
    }
    /**
     * Set stateFrom value
     * @param string $stateFrom
     * @return \StructType\CustomerCreditCards
     */
    public function setStateFrom($stateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($stateFrom) && !is_string($stateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateFrom, true), gettype($stateFrom)), __LINE__);
        }
        $this->stateFrom = $stateFrom;
        return $this;
    }
    /**
     * Get debitcardIssueNo value
     * @return string|null
     */
    public function getDebitcardIssueNo()
    {
        return $this->debitcardIssueNo;
    }
    /**
     * Set debitcardIssueNo value
     * @param string $debitcardIssueNo
     * @return \StructType\CustomerCreditCards
     */
    public function setDebitcardIssueNo($debitcardIssueNo = null)
    {
        // validation for constraint: string
        if (!is_null($debitcardIssueNo) && !is_string($debitcardIssueNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debitcardIssueNo, true), gettype($debitcardIssueNo)), __LINE__);
        }
        $this->debitcardIssueNo = $debitcardIssueNo;
        return $this;
    }
    /**
     * Get ccMemo value
     * @return string|null
     */
    public function getCcMemo()
    {
        return $this->ccMemo;
    }
    /**
     * Set ccMemo value
     * @param string $ccMemo
     * @return \StructType\CustomerCreditCards
     */
    public function setCcMemo($ccMemo = null)
    {
        // validation for constraint: string
        if (!is_null($ccMemo) && !is_string($ccMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccMemo, true), gettype($ccMemo)), __LINE__);
        }
        $this->ccMemo = $ccMemo;
        return $this;
    }
    /**
     * Get validfrom value
     * @return string|null
     */
    public function getValidfrom()
    {
        return $this->validfrom;
    }
    /**
     * Set validfrom value
     * @param string $validfrom
     * @return \StructType\CustomerCreditCards
     */
    public function setValidfrom($validfrom = null)
    {
        // validation for constraint: string
        if (!is_null($validfrom) && !is_string($validfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validfrom, true), gettype($validfrom)), __LINE__);
        }
        $this->validfrom = $validfrom;
        return $this;
    }
    /**
     * Get ccDefault value
     * @return bool|null
     */
    public function getCcDefault()
    {
        return $this->ccDefault;
    }
    /**
     * Set ccDefault value
     * @param bool $ccDefault
     * @return \StructType\CustomerCreditCards
     */
    public function setCcDefault($ccDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($ccDefault) && !is_bool($ccDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ccDefault, true), gettype($ccDefault)), __LINE__);
        }
        $this->ccDefault = $ccDefault;
        return $this;
    }
}
