<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAddressbook StructType
 * @subpackage Structs
 */
class CustomerAddressbook extends AbstractStructBase
{
    /**
     * The defaultShipping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $defaultShipping;
    /**
     * The defaultBilling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $defaultBilling;
    /**
     * The isResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isResidential;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The addressbookAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $addressbookAddress;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for CustomerAddressbook
     * @uses CustomerAddressbook::setDefaultShipping()
     * @uses CustomerAddressbook::setDefaultBilling()
     * @uses CustomerAddressbook::setIsResidential()
     * @uses CustomerAddressbook::setLabel()
     * @uses CustomerAddressbook::setAddressbookAddress()
     * @uses CustomerAddressbook::setInternalId()
     * @param bool $defaultShipping
     * @param bool $defaultBilling
     * @param bool $isResidential
     * @param string $label
     * @param \StructType\Address $addressbookAddress
     * @param string $internalId
     */
    public function __construct($defaultShipping = null, $defaultBilling = null, $isResidential = null, $label = null, \StructType\Address $addressbookAddress = null, $internalId = null)
    {
        $this
            ->setDefaultShipping($defaultShipping)
            ->setDefaultBilling($defaultBilling)
            ->setIsResidential($isResidential)
            ->setLabel($label)
            ->setAddressbookAddress($addressbookAddress)
            ->setInternalId($internalId);
    }
    /**
     * Get defaultShipping value
     * @return bool|null
     */
    public function getDefaultShipping()
    {
        return $this->defaultShipping;
    }
    /**
     * Set defaultShipping value
     * @param bool $defaultShipping
     * @return \StructType\CustomerAddressbook
     */
    public function setDefaultShipping($defaultShipping = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultShipping) && !is_bool($defaultShipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultShipping, true), gettype($defaultShipping)), __LINE__);
        }
        $this->defaultShipping = $defaultShipping;
        return $this;
    }
    /**
     * Get defaultBilling value
     * @return bool|null
     */
    public function getDefaultBilling()
    {
        return $this->defaultBilling;
    }
    /**
     * Set defaultBilling value
     * @param bool $defaultBilling
     * @return \StructType\CustomerAddressbook
     */
    public function setDefaultBilling($defaultBilling = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultBilling) && !is_bool($defaultBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultBilling, true), gettype($defaultBilling)), __LINE__);
        }
        $this->defaultBilling = $defaultBilling;
        return $this;
    }
    /**
     * Get isResidential value
     * @return bool|null
     */
    public function getIsResidential()
    {
        return $this->isResidential;
    }
    /**
     * Set isResidential value
     * @param bool $isResidential
     * @return \StructType\CustomerAddressbook
     */
    public function setIsResidential($isResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResidential) && !is_bool($isResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResidential, true), gettype($isResidential)), __LINE__);
        }
        $this->isResidential = $isResidential;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\CustomerAddressbook
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get addressbookAddress value
     * @return \StructType\Address|null
     */
    public function getAddressbookAddress()
    {
        return $this->addressbookAddress;
    }
    /**
     * Set addressbookAddress value
     * @param \StructType\Address $addressbookAddress
     * @return \StructType\CustomerAddressbook
     */
    public function setAddressbookAddress(\StructType\Address $addressbookAddress = null)
    {
        $this->addressbookAddress = $addressbookAddress;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomerAddressbook
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
