<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomTransactionLineList StructType
 * @subpackage Structs
 */
class CustomTransactionLineList extends AbstractStructBase
{
    /**
     * The customTransactionLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomTransactionLine[]
     */
    public $customTransactionLine;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomTransactionLineList
     * @uses CustomTransactionLineList::setCustomTransactionLine()
     * @uses CustomTransactionLineList::setReplaceAll()
     * @param \StructType\CustomTransactionLine[] $customTransactionLine
     * @param bool $replaceAll
     */
    public function __construct(array $customTransactionLine = array(), $replaceAll = true)
    {
        $this
            ->setCustomTransactionLine($customTransactionLine)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get customTransactionLine value
     * @return \StructType\CustomTransactionLine[]|null
     */
    public function getCustomTransactionLine()
    {
        return $this->customTransactionLine;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomTransactionLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomTransactionLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomTransactionLineForArrayConstraintsFromSetCustomTransactionLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customTransactionLineListCustomTransactionLineItem) {
            // validation for constraint: itemType
            if (!$customTransactionLineListCustomTransactionLineItem instanceof \StructType\CustomTransactionLine) {
                $invalidValues[] = is_object($customTransactionLineListCustomTransactionLineItem) ? get_class($customTransactionLineListCustomTransactionLineItem) : sprintf('%s(%s)', gettype($customTransactionLineListCustomTransactionLineItem), var_export($customTransactionLineListCustomTransactionLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customTransactionLine property can only contain items of type \StructType\CustomTransactionLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customTransactionLine value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomTransactionLine[] $customTransactionLine
     * @return \StructType\CustomTransactionLineList
     */
    public function setCustomTransactionLine(array $customTransactionLine = array())
    {
        // validation for constraint: array
        if ('' !== ($customTransactionLineArrayErrorMessage = self::validateCustomTransactionLineForArrayConstraintsFromSetCustomTransactionLine($customTransactionLine))) {
            throw new \InvalidArgumentException($customTransactionLineArrayErrorMessage, __LINE__);
        }
        $this->customTransactionLine = $customTransactionLine;
        return $this;
    }
    /**
     * Add item to customTransactionLine value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomTransactionLine $item
     * @return \StructType\CustomTransactionLineList
     */
    public function addToCustomTransactionLine(\StructType\CustomTransactionLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomTransactionLine) {
            throw new \InvalidArgumentException(sprintf('The customTransactionLine property can only contain items of type \StructType\CustomTransactionLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customTransactionLine[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomTransactionLineList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
