<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSaleShipGroup StructType
 * @subpackage Structs
 */
class CustomSaleShipGroup extends AbstractStructBase
{
    /**
     * The sourceAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceAddress;
    /**
     * The destinationAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddress;
    /**
     * The shippingMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingMethod;
    /**
     * The shippingRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingRate;
    /**
     * The handlingRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingRate;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The isFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $isFulfilled;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The sourceAddressRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceAddressRef;
    /**
     * The destinationAddressRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddressRef;
    /**
     * The shippingMethodRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingMethodRef;
    /**
     * Constructor method for CustomSaleShipGroup
     * @uses CustomSaleShipGroup::setSourceAddress()
     * @uses CustomSaleShipGroup::setDestinationAddress()
     * @uses CustomSaleShipGroup::setShippingMethod()
     * @uses CustomSaleShipGroup::setShippingRate()
     * @uses CustomSaleShipGroup::setHandlingRate()
     * @uses CustomSaleShipGroup::setId()
     * @uses CustomSaleShipGroup::setIsFulfilled()
     * @uses CustomSaleShipGroup::setWeight()
     * @uses CustomSaleShipGroup::setSourceAddressRef()
     * @uses CustomSaleShipGroup::setDestinationAddressRef()
     * @uses CustomSaleShipGroup::setShippingMethodRef()
     * @param string $sourceAddress
     * @param string $destinationAddress
     * @param string $shippingMethod
     * @param float $shippingRate
     * @param float $handlingRate
     * @param int $id
     * @param string $isFulfilled
     * @param float $weight
     * @param string $sourceAddressRef
     * @param string $destinationAddressRef
     * @param string $shippingMethodRef
     */
    public function __construct($sourceAddress = null, $destinationAddress = null, $shippingMethod = null, $shippingRate = null, $handlingRate = null, $id = null, $isFulfilled = null, $weight = null, $sourceAddressRef = null, $destinationAddressRef = null, $shippingMethodRef = null)
    {
        $this
            ->setSourceAddress($sourceAddress)
            ->setDestinationAddress($destinationAddress)
            ->setShippingMethod($shippingMethod)
            ->setShippingRate($shippingRate)
            ->setHandlingRate($handlingRate)
            ->setId($id)
            ->setIsFulfilled($isFulfilled)
            ->setWeight($weight)
            ->setSourceAddressRef($sourceAddressRef)
            ->setDestinationAddressRef($destinationAddressRef)
            ->setShippingMethodRef($shippingMethodRef);
    }
    /**
     * Get sourceAddress value
     * @return string|null
     */
    public function getSourceAddress()
    {
        return $this->sourceAddress;
    }
    /**
     * Set sourceAddress value
     * @param string $sourceAddress
     * @return \StructType\CustomSaleShipGroup
     */
    public function setSourceAddress($sourceAddress = null)
    {
        // validation for constraint: string
        if (!is_null($sourceAddress) && !is_string($sourceAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceAddress, true), gettype($sourceAddress)), __LINE__);
        }
        $this->sourceAddress = $sourceAddress;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \StructType\CustomSaleShipGroup
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAddress, true), gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get shippingMethod value
     * @return string|null
     */
    public function getShippingMethod()
    {
        return $this->shippingMethod;
    }
    /**
     * Set shippingMethod value
     * @param string $shippingMethod
     * @return \StructType\CustomSaleShipGroup
     */
    public function setShippingMethod($shippingMethod = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMethod) && !is_string($shippingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingMethod, true), gettype($shippingMethod)), __LINE__);
        }
        $this->shippingMethod = $shippingMethod;
        return $this;
    }
    /**
     * Get shippingRate value
     * @return float|null
     */
    public function getShippingRate()
    {
        return $this->shippingRate;
    }
    /**
     * Set shippingRate value
     * @param float $shippingRate
     * @return \StructType\CustomSaleShipGroup
     */
    public function setShippingRate($shippingRate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingRate) && !(is_float($shippingRate) || is_numeric($shippingRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingRate, true), gettype($shippingRate)), __LINE__);
        }
        $this->shippingRate = $shippingRate;
        return $this;
    }
    /**
     * Get handlingRate value
     * @return float|null
     */
    public function getHandlingRate()
    {
        return $this->handlingRate;
    }
    /**
     * Set handlingRate value
     * @param float $handlingRate
     * @return \StructType\CustomSaleShipGroup
     */
    public function setHandlingRate($handlingRate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingRate) && !(is_float($handlingRate) || is_numeric($handlingRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingRate, true), gettype($handlingRate)), __LINE__);
        }
        $this->handlingRate = $handlingRate;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\CustomSaleShipGroup
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get isFulfilled value
     * @return string|null
     */
    public function getIsFulfilled()
    {
        return $this->isFulfilled;
    }
    /**
     * Set isFulfilled value
     * @param string $isFulfilled
     * @return \StructType\CustomSaleShipGroup
     */
    public function setIsFulfilled($isFulfilled = null)
    {
        // validation for constraint: string
        if (!is_null($isFulfilled) && !is_string($isFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isFulfilled, true), gettype($isFulfilled)), __LINE__);
        }
        $this->isFulfilled = $isFulfilled;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\CustomSaleShipGroup
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get sourceAddressRef value
     * @return string|null
     */
    public function getSourceAddressRef()
    {
        return $this->sourceAddressRef;
    }
    /**
     * Set sourceAddressRef value
     * @param string $sourceAddressRef
     * @return \StructType\CustomSaleShipGroup
     */
    public function setSourceAddressRef($sourceAddressRef = null)
    {
        // validation for constraint: string
        if (!is_null($sourceAddressRef) && !is_string($sourceAddressRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceAddressRef, true), gettype($sourceAddressRef)), __LINE__);
        }
        $this->sourceAddressRef = $sourceAddressRef;
        return $this;
    }
    /**
     * Get destinationAddressRef value
     * @return string|null
     */
    public function getDestinationAddressRef()
    {
        return $this->destinationAddressRef;
    }
    /**
     * Set destinationAddressRef value
     * @param string $destinationAddressRef
     * @return \StructType\CustomSaleShipGroup
     */
    public function setDestinationAddressRef($destinationAddressRef = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddressRef) && !is_string($destinationAddressRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAddressRef, true), gettype($destinationAddressRef)), __LINE__);
        }
        $this->destinationAddressRef = $destinationAddressRef;
        return $this;
    }
    /**
     * Get shippingMethodRef value
     * @return string|null
     */
    public function getShippingMethodRef()
    {
        return $this->shippingMethodRef;
    }
    /**
     * Set shippingMethodRef value
     * @param string $shippingMethodRef
     * @return \StructType\CustomSaleShipGroup
     */
    public function setShippingMethodRef($shippingMethodRef = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMethodRef) && !is_string($shippingMethodRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingMethodRef, true), gettype($shippingMethodRef)), __LINE__);
        }
        $this->shippingMethodRef = $shippingMethodRef;
        return $this;
    }
}
