<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSaleItem StructType
 * @subpackage Structs
 */
class CustomSaleItem extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The currentPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $currentPercent;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The percentComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentComplete;
    /**
     * The quantityOnHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityOnHand;
    /**
     * The quantityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityAvailable;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityRemaining;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The licenseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licenseCode;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecStartDate;
    /**
     * The revRecTermInMonths
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $revRecTermInMonths;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecEndDate;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The excludeFromRateRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeFromRateRequest;
    /**
     * The catchUpPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $catchUpPeriod;
    /**
     * The giftCertFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertFrom;
    /**
     * The giftCertRecipientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientName;
    /**
     * The giftCertRecipientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientEmail;
    /**
     * The giftCertMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertMessage;
    /**
     * The shipAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddress;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The shipGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shipGroup;
    /**
     * The itemIsFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemIsFulfilled;
    /**
     * The giftCertNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertNumber;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeIsEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeIsEstimate;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAmount;
    /**
     * The vsoeAllocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAllocation;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for CustomSaleItem
     * @uses CustomSaleItem::setItem()
     * @uses CustomSaleItem::setLine()
     * @uses CustomSaleItem::setDescription()
     * @uses CustomSaleItem::setAmount()
     * @uses CustomSaleItem::setIsTaxable()
     * @uses CustomSaleItem::setOptions()
     * @uses CustomSaleItem::setDeferRevRec()
     * @uses CustomSaleItem::setQuantity()
     * @uses CustomSaleItem::setCurrentPercent()
     * @uses CustomSaleItem::setUnits()
     * @uses CustomSaleItem::setInventoryDetail()
     * @uses CustomSaleItem::setSerialNumbers()
     * @uses CustomSaleItem::setBinNumbers()
     * @uses CustomSaleItem::setPrice()
     * @uses CustomSaleItem::setRate()
     * @uses CustomSaleItem::setPercentComplete()
     * @uses CustomSaleItem::setQuantityOnHand()
     * @uses CustomSaleItem::setQuantityAvailable()
     * @uses CustomSaleItem::setQuantityRemaining()
     * @uses CustomSaleItem::setDepartment()
     * @uses CustomSaleItem::setLicenseCode()
     * @uses CustomSaleItem::setClass()
     * @uses CustomSaleItem::setLocation()
     * @uses CustomSaleItem::setRevRecSchedule()
     * @uses CustomSaleItem::setRevRecStartDate()
     * @uses CustomSaleItem::setRevRecTermInMonths()
     * @uses CustomSaleItem::setRevRecEndDate()
     * @uses CustomSaleItem::setGrossAmt()
     * @uses CustomSaleItem::setCostEstimateType()
     * @uses CustomSaleItem::setCostEstimate()
     * @uses CustomSaleItem::setTaxDetailsReference()
     * @uses CustomSaleItem::setExcludeFromRateRequest()
     * @uses CustomSaleItem::setCatchUpPeriod()
     * @uses CustomSaleItem::setGiftCertFrom()
     * @uses CustomSaleItem::setGiftCertRecipientName()
     * @uses CustomSaleItem::setGiftCertRecipientEmail()
     * @uses CustomSaleItem::setGiftCertMessage()
     * @uses CustomSaleItem::setShipAddress()
     * @uses CustomSaleItem::setShippingAddress()
     * @uses CustomSaleItem::setShipMethod()
     * @uses CustomSaleItem::setShipGroup()
     * @uses CustomSaleItem::setItemIsFulfilled()
     * @uses CustomSaleItem::setGiftCertNumber()
     * @uses CustomSaleItem::setTaxAmount()
     * @uses CustomSaleItem::setVsoeSopGroup()
     * @uses CustomSaleItem::setVsoeIsEstimate()
     * @uses CustomSaleItem::setVsoePrice()
     * @uses CustomSaleItem::setVsoeAmount()
     * @uses CustomSaleItem::setVsoeAllocation()
     * @uses CustomSaleItem::setVsoeDeferral()
     * @uses CustomSaleItem::setVsoePermitDiscount()
     * @uses CustomSaleItem::setVsoeDelivered()
     * @uses CustomSaleItem::setCustomFieldList()
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param string $description
     * @param float $amount
     * @param bool $isTaxable
     * @param \StructType\CustomFieldList $options
     * @param bool $deferRevRec
     * @param float $quantity
     * @param float $currentPercent
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $serialNumbers
     * @param string $binNumbers
     * @param \StructType\RecordRef $price
     * @param string $rate
     * @param float $percentComplete
     * @param float $quantityOnHand
     * @param float $quantityAvailable
     * @param float $quantityRemaining
     * @param \StructType\RecordRef $department
     * @param string $licenseCode
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $revRecStartDate
     * @param int $revRecTermInMonths
     * @param string $revRecEndDate
     * @param float $grossAmt
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param string $taxDetailsReference
     * @param bool $excludeFromRateRequest
     * @param \StructType\RecordRef $catchUpPeriod
     * @param string $giftCertFrom
     * @param string $giftCertRecipientName
     * @param string $giftCertRecipientEmail
     * @param string $giftCertMessage
     * @param \StructType\RecordRef $shipAddress
     * @param \StructType\Address $shippingAddress
     * @param \StructType\RecordRef $shipMethod
     * @param int $shipGroup
     * @param string $itemIsFulfilled
     * @param string $giftCertNumber
     * @param float $taxAmount
     * @param string $vsoeSopGroup
     * @param bool $vsoeIsEstimate
     * @param float $vsoePrice
     * @param float $vsoeAmount
     * @param float $vsoeAllocation
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $item = null, $line = null, $description = null, $amount = null, $isTaxable = null, \StructType\CustomFieldList $options = null, $deferRevRec = null, $quantity = null, $currentPercent = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $serialNumbers = null, $binNumbers = null, \StructType\RecordRef $price = null, $rate = null, $percentComplete = null, $quantityOnHand = null, $quantityAvailable = null, $quantityRemaining = null, \StructType\RecordRef $department = null, $licenseCode = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $revRecSchedule = null, $revRecStartDate = null, $revRecTermInMonths = null, $revRecEndDate = null, $grossAmt = null, $costEstimateType = null, $costEstimate = null, $taxDetailsReference = null, $excludeFromRateRequest = null, \StructType\RecordRef $catchUpPeriod = null, $giftCertFrom = null, $giftCertRecipientName = null, $giftCertRecipientEmail = null, $giftCertMessage = null, \StructType\RecordRef $shipAddress = null, \StructType\Address $shippingAddress = null, \StructType\RecordRef $shipMethod = null, $shipGroup = null, $itemIsFulfilled = null, $giftCertNumber = null, $taxAmount = null, $vsoeSopGroup = null, $vsoeIsEstimate = null, $vsoePrice = null, $vsoeAmount = null, $vsoeAllocation = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setItem($item)
            ->setLine($line)
            ->setDescription($description)
            ->setAmount($amount)
            ->setIsTaxable($isTaxable)
            ->setOptions($options)
            ->setDeferRevRec($deferRevRec)
            ->setQuantity($quantity)
            ->setCurrentPercent($currentPercent)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setSerialNumbers($serialNumbers)
            ->setBinNumbers($binNumbers)
            ->setPrice($price)
            ->setRate($rate)
            ->setPercentComplete($percentComplete)
            ->setQuantityOnHand($quantityOnHand)
            ->setQuantityAvailable($quantityAvailable)
            ->setQuantityRemaining($quantityRemaining)
            ->setDepartment($department)
            ->setLicenseCode($licenseCode)
            ->setClass($class)
            ->setLocation($location)
            ->setRevRecSchedule($revRecSchedule)
            ->setRevRecStartDate($revRecStartDate)
            ->setRevRecTermInMonths($revRecTermInMonths)
            ->setRevRecEndDate($revRecEndDate)
            ->setGrossAmt($grossAmt)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setExcludeFromRateRequest($excludeFromRateRequest)
            ->setCatchUpPeriod($catchUpPeriod)
            ->setGiftCertFrom($giftCertFrom)
            ->setGiftCertRecipientName($giftCertRecipientName)
            ->setGiftCertRecipientEmail($giftCertRecipientEmail)
            ->setGiftCertMessage($giftCertMessage)
            ->setShipAddress($shipAddress)
            ->setShippingAddress($shippingAddress)
            ->setShipMethod($shipMethod)
            ->setShipGroup($shipGroup)
            ->setItemIsFulfilled($itemIsFulfilled)
            ->setGiftCertNumber($giftCertNumber)
            ->setTaxAmount($taxAmount)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeIsEstimate($vsoeIsEstimate)
            ->setVsoePrice($vsoePrice)
            ->setVsoeAmount($vsoeAmount)
            ->setVsoeAllocation($vsoeAllocation)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\CustomSaleItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\CustomSaleItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomSaleItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CustomSaleItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\CustomSaleItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\CustomSaleItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\CustomSaleItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\CustomSaleItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get currentPercent value
     * @return float|null
     */
    public function getCurrentPercent()
    {
        return $this->currentPercent;
    }
    /**
     * Set currentPercent value
     * @param float $currentPercent
     * @return \StructType\CustomSaleItem
     */
    public function setCurrentPercent($currentPercent = null)
    {
        // validation for constraint: float
        if (!is_null($currentPercent) && !(is_float($currentPercent) || is_numeric($currentPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentPercent, true), gettype($currentPercent)), __LINE__);
        }
        $this->currentPercent = $currentPercent;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\CustomSaleItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\CustomSaleItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\CustomSaleItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\CustomSaleItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\CustomSaleItem
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\CustomSaleItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get percentComplete value
     * @return float|null
     */
    public function getPercentComplete()
    {
        return $this->percentComplete;
    }
    /**
     * Set percentComplete value
     * @param float $percentComplete
     * @return \StructType\CustomSaleItem
     */
    public function setPercentComplete($percentComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentComplete) && !(is_float($percentComplete) || is_numeric($percentComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentComplete, true), gettype($percentComplete)), __LINE__);
        }
        $this->percentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get quantityOnHand value
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->quantityOnHand;
    }
    /**
     * Set quantityOnHand value
     * @param float $quantityOnHand
     * @return \StructType\CustomSaleItem
     */
    public function setQuantityOnHand($quantityOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOnHand) && !(is_float($quantityOnHand) || is_numeric($quantityOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOnHand, true), gettype($quantityOnHand)), __LINE__);
        }
        $this->quantityOnHand = $quantityOnHand;
        return $this;
    }
    /**
     * Get quantityAvailable value
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->quantityAvailable;
    }
    /**
     * Set quantityAvailable value
     * @param float $quantityAvailable
     * @return \StructType\CustomSaleItem
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAvailable) && !(is_float($quantityAvailable) || is_numeric($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->quantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return float|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * Set quantityRemaining value
     * @param float $quantityRemaining
     * @return \StructType\CustomSaleItem
     */
    public function setQuantityRemaining($quantityRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($quantityRemaining) && !(is_float($quantityRemaining) || is_numeric($quantityRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityRemaining, true), gettype($quantityRemaining)), __LINE__);
        }
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CustomSaleItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get licenseCode value
     * @return string|null
     */
    public function getLicenseCode()
    {
        return $this->licenseCode;
    }
    /**
     * Set licenseCode value
     * @param string $licenseCode
     * @return \StructType\CustomSaleItem
     */
    public function setLicenseCode($licenseCode = null)
    {
        // validation for constraint: string
        if (!is_null($licenseCode) && !is_string($licenseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseCode, true), gettype($licenseCode)), __LINE__);
        }
        $this->licenseCode = $licenseCode;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CustomSaleItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CustomSaleItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\CustomSaleItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return string|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * Set revRecStartDate value
     * @param string $revRecStartDate
     * @return \StructType\CustomSaleItem
     */
    public function setRevRecStartDate($revRecStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecStartDate) && !is_string($revRecStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecStartDate, true), gettype($revRecStartDate)), __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Get revRecTermInMonths value
     * @return int|null
     */
    public function getRevRecTermInMonths()
    {
        return $this->revRecTermInMonths;
    }
    /**
     * Set revRecTermInMonths value
     * @param int $revRecTermInMonths
     * @return \StructType\CustomSaleItem
     */
    public function setRevRecTermInMonths($revRecTermInMonths = null)
    {
        // validation for constraint: int
        if (!is_null($revRecTermInMonths) && !(is_int($revRecTermInMonths) || ctype_digit($revRecTermInMonths))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revRecTermInMonths, true), gettype($revRecTermInMonths)), __LINE__);
        }
        $this->revRecTermInMonths = $revRecTermInMonths;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return string|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * Set revRecEndDate value
     * @param string $revRecEndDate
     * @return \StructType\CustomSaleItem
     */
    public function setRevRecEndDate($revRecEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecEndDate) && !is_string($revRecEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecEndDate, true), gettype($revRecEndDate)), __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\CustomSaleItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\CustomSaleItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\CustomSaleItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\CustomSaleItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get excludeFromRateRequest value
     * @return bool|null
     */
    public function getExcludeFromRateRequest()
    {
        return $this->excludeFromRateRequest;
    }
    /**
     * Set excludeFromRateRequest value
     * @param bool $excludeFromRateRequest
     * @return \StructType\CustomSaleItem
     */
    public function setExcludeFromRateRequest($excludeFromRateRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromRateRequest) && !is_bool($excludeFromRateRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeFromRateRequest, true), gettype($excludeFromRateRequest)), __LINE__);
        }
        $this->excludeFromRateRequest = $excludeFromRateRequest;
        return $this;
    }
    /**
     * Get catchUpPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getCatchUpPeriod()
    {
        return $this->catchUpPeriod;
    }
    /**
     * Set catchUpPeriod value
     * @param \StructType\RecordRef $catchUpPeriod
     * @return \StructType\CustomSaleItem
     */
    public function setCatchUpPeriod(\StructType\RecordRef $catchUpPeriod = null)
    {
        $this->catchUpPeriod = $catchUpPeriod;
        return $this;
    }
    /**
     * Get giftCertFrom value
     * @return string|null
     */
    public function getGiftCertFrom()
    {
        return $this->giftCertFrom;
    }
    /**
     * Set giftCertFrom value
     * @param string $giftCertFrom
     * @return \StructType\CustomSaleItem
     */
    public function setGiftCertFrom($giftCertFrom = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertFrom) && !is_string($giftCertFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertFrom, true), gettype($giftCertFrom)), __LINE__);
        }
        $this->giftCertFrom = $giftCertFrom;
        return $this;
    }
    /**
     * Get giftCertRecipientName value
     * @return string|null
     */
    public function getGiftCertRecipientName()
    {
        return $this->giftCertRecipientName;
    }
    /**
     * Set giftCertRecipientName value
     * @param string $giftCertRecipientName
     * @return \StructType\CustomSaleItem
     */
    public function setGiftCertRecipientName($giftCertRecipientName = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientName) && !is_string($giftCertRecipientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientName, true), gettype($giftCertRecipientName)), __LINE__);
        }
        $this->giftCertRecipientName = $giftCertRecipientName;
        return $this;
    }
    /**
     * Get giftCertRecipientEmail value
     * @return string|null
     */
    public function getGiftCertRecipientEmail()
    {
        return $this->giftCertRecipientEmail;
    }
    /**
     * Set giftCertRecipientEmail value
     * @param string $giftCertRecipientEmail
     * @return \StructType\CustomSaleItem
     */
    public function setGiftCertRecipientEmail($giftCertRecipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientEmail) && !is_string($giftCertRecipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientEmail, true), gettype($giftCertRecipientEmail)), __LINE__);
        }
        $this->giftCertRecipientEmail = $giftCertRecipientEmail;
        return $this;
    }
    /**
     * Get giftCertMessage value
     * @return string|null
     */
    public function getGiftCertMessage()
    {
        return $this->giftCertMessage;
    }
    /**
     * Set giftCertMessage value
     * @param string $giftCertMessage
     * @return \StructType\CustomSaleItem
     */
    public function setGiftCertMessage($giftCertMessage = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertMessage) && !is_string($giftCertMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertMessage, true), gettype($giftCertMessage)), __LINE__);
        }
        $this->giftCertMessage = $giftCertMessage;
        return $this;
    }
    /**
     * Get shipAddress value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddress()
    {
        return $this->shipAddress;
    }
    /**
     * Set shipAddress value
     * @param \StructType\RecordRef $shipAddress
     * @return \StructType\CustomSaleItem
     */
    public function setShipAddress(\StructType\RecordRef $shipAddress = null)
    {
        $this->shipAddress = $shipAddress;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\CustomSaleItem
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\CustomSaleItem
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get shipGroup value
     * @return int|null
     */
    public function getShipGroup()
    {
        return $this->shipGroup;
    }
    /**
     * Set shipGroup value
     * @param int $shipGroup
     * @return \StructType\CustomSaleItem
     */
    public function setShipGroup($shipGroup = null)
    {
        // validation for constraint: int
        if (!is_null($shipGroup) && !(is_int($shipGroup) || ctype_digit($shipGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipGroup, true), gettype($shipGroup)), __LINE__);
        }
        $this->shipGroup = $shipGroup;
        return $this;
    }
    /**
     * Get itemIsFulfilled value
     * @return string|null
     */
    public function getItemIsFulfilled()
    {
        return $this->itemIsFulfilled;
    }
    /**
     * Set itemIsFulfilled value
     * @param string $itemIsFulfilled
     * @return \StructType\CustomSaleItem
     */
    public function setItemIsFulfilled($itemIsFulfilled = null)
    {
        // validation for constraint: string
        if (!is_null($itemIsFulfilled) && !is_string($itemIsFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemIsFulfilled, true), gettype($itemIsFulfilled)), __LINE__);
        }
        $this->itemIsFulfilled = $itemIsFulfilled;
        return $this;
    }
    /**
     * Get giftCertNumber value
     * @return string|null
     */
    public function getGiftCertNumber()
    {
        return $this->giftCertNumber;
    }
    /**
     * Set giftCertNumber value
     * @param string $giftCertNumber
     * @return \StructType\CustomSaleItem
     */
    public function setGiftCertNumber($giftCertNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertNumber) && !is_string($giftCertNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertNumber, true), gettype($giftCertNumber)), __LINE__);
        }
        $this->giftCertNumber = $giftCertNumber;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\CustomSaleItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\CustomSaleItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeIsEstimate value
     * @return bool|null
     */
    public function getVsoeIsEstimate()
    {
        return $this->vsoeIsEstimate;
    }
    /**
     * Set vsoeIsEstimate value
     * @param bool $vsoeIsEstimate
     * @return \StructType\CustomSaleItem
     */
    public function setVsoeIsEstimate($vsoeIsEstimate = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeIsEstimate) && !is_bool($vsoeIsEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeIsEstimate, true), gettype($vsoeIsEstimate)), __LINE__);
        }
        $this->vsoeIsEstimate = $vsoeIsEstimate;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\CustomSaleItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeAmount value
     * @return float|null
     */
    public function getVsoeAmount()
    {
        return $this->vsoeAmount;
    }
    /**
     * Set vsoeAmount value
     * @param float $vsoeAmount
     * @return \StructType\CustomSaleItem
     */
    public function setVsoeAmount($vsoeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAmount) && !(is_float($vsoeAmount) || is_numeric($vsoeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAmount, true), gettype($vsoeAmount)), __LINE__);
        }
        $this->vsoeAmount = $vsoeAmount;
        return $this;
    }
    /**
     * Get vsoeAllocation value
     * @return float|null
     */
    public function getVsoeAllocation()
    {
        return $this->vsoeAllocation;
    }
    /**
     * Set vsoeAllocation value
     * @param float $vsoeAllocation
     * @return \StructType\CustomSaleItem
     */
    public function setVsoeAllocation($vsoeAllocation = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAllocation) && !(is_float($vsoeAllocation) || is_numeric($vsoeAllocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAllocation, true), gettype($vsoeAllocation)), __LINE__);
        }
        $this->vsoeAllocation = $vsoeAllocation;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\CustomSaleItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\CustomSaleItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\CustomSaleItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomSaleItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
