<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeTranslations StructType
 * @subpackage Structs
 */
class CustomRecordTypeTranslations extends AbstractStructBase
{
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locale;
    /**
     * The localeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localeDescription;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for CustomRecordTypeTranslations
     * @uses CustomRecordTypeTranslations::setLocale()
     * @uses CustomRecordTypeTranslations::setLocaleDescription()
     * @uses CustomRecordTypeTranslations::setName()
     * @param string $locale
     * @param string $localeDescription
     * @param string $name
     */
    public function __construct($locale = null, $localeDescription = null, $name = null)
    {
        $this
            ->setLocale($locale)
            ->setLocaleDescription($localeDescription)
            ->setName($name);
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\CustomRecordTypeTranslations
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($locale) ? implode(', ', $locale) : var_export($locale, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get localeDescription value
     * @return string|null
     */
    public function getLocaleDescription()
    {
        return $this->localeDescription;
    }
    /**
     * Set localeDescription value
     * @param string $localeDescription
     * @return \StructType\CustomRecordTypeTranslations
     */
    public function setLocaleDescription($localeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($localeDescription) && !is_string($localeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localeDescription, true), gettype($localeDescription)), __LINE__);
        }
        $this->localeDescription = $localeDescription;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomRecordTypeTranslations
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
