<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeSublistsList StructType
 * @subpackage Structs
 */
class CustomRecordTypeSublistsList extends AbstractStructBase
{
    /**
     * The sublists
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeSublists[]
     */
    public $sublists;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeSublistsList
     * @uses CustomRecordTypeSublistsList::setSublists()
     * @uses CustomRecordTypeSublistsList::setReplaceAll()
     * @param \StructType\CustomRecordTypeSublists[] $sublists
     * @param bool $replaceAll
     */
    public function __construct(array $sublists = array(), $replaceAll = true)
    {
        $this
            ->setSublists($sublists)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get sublists value
     * @return \StructType\CustomRecordTypeSublists[]|null
     */
    public function getSublists()
    {
        return $this->sublists;
    }
    /**
     * This method is responsible for validating the values passed to the setSublists method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSublists method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSublistsForArrayConstraintsFromSetSublists(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeSublistsListSublistsItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeSublistsListSublistsItem instanceof \StructType\CustomRecordTypeSublists) {
                $invalidValues[] = is_object($customRecordTypeSublistsListSublistsItem) ? get_class($customRecordTypeSublistsListSublistsItem) : sprintf('%s(%s)', gettype($customRecordTypeSublistsListSublistsItem), var_export($customRecordTypeSublistsListSublistsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sublists property can only contain items of type \StructType\CustomRecordTypeSublists, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sublists value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeSublists[] $sublists
     * @return \StructType\CustomRecordTypeSublistsList
     */
    public function setSublists(array $sublists = array())
    {
        // validation for constraint: array
        if ('' !== ($sublistsArrayErrorMessage = self::validateSublistsForArrayConstraintsFromSetSublists($sublists))) {
            throw new \InvalidArgumentException($sublistsArrayErrorMessage, __LINE__);
        }
        $this->sublists = $sublists;
        return $this;
    }
    /**
     * Add item to sublists value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeSublists $item
     * @return \StructType\CustomRecordTypeSublistsList
     */
    public function addToSublists(\StructType\CustomRecordTypeSublists $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeSublists) {
            throw new \InvalidArgumentException(sprintf('The sublists property can only contain items of type \StructType\CustomRecordTypeSublists, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sublists[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeSublistsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
