<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypePermissionsList StructType
 * @subpackage Structs
 */
class CustomRecordTypePermissionsList extends AbstractStructBase
{
    /**
     * The permissions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypePermissions[]
     */
    public $permissions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypePermissionsList
     * @uses CustomRecordTypePermissionsList::setPermissions()
     * @uses CustomRecordTypePermissionsList::setReplaceAll()
     * @param \StructType\CustomRecordTypePermissions[] $permissions
     * @param bool $replaceAll
     */
    public function __construct(array $permissions = array(), $replaceAll = true)
    {
        $this
            ->setPermissions($permissions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get permissions value
     * @return \StructType\CustomRecordTypePermissions[]|null
     */
    public function getPermissions()
    {
        return $this->permissions;
    }
    /**
     * This method is responsible for validating the values passed to the setPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePermissionsForArrayConstraintsFromSetPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypePermissionsListPermissionsItem) {
            // validation for constraint: itemType
            if (!$customRecordTypePermissionsListPermissionsItem instanceof \StructType\CustomRecordTypePermissions) {
                $invalidValues[] = is_object($customRecordTypePermissionsListPermissionsItem) ? get_class($customRecordTypePermissionsListPermissionsItem) : sprintf('%s(%s)', gettype($customRecordTypePermissionsListPermissionsItem), var_export($customRecordTypePermissionsListPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The permissions property can only contain items of type \StructType\CustomRecordTypePermissions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set permissions value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypePermissions[] $permissions
     * @return \StructType\CustomRecordTypePermissionsList
     */
    public function setPermissions(array $permissions = array())
    {
        // validation for constraint: array
        if ('' !== ($permissionsArrayErrorMessage = self::validatePermissionsForArrayConstraintsFromSetPermissions($permissions))) {
            throw new \InvalidArgumentException($permissionsArrayErrorMessage, __LINE__);
        }
        $this->permissions = $permissions;
        return $this;
    }
    /**
     * Add item to permissions value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypePermissions $item
     * @return \StructType\CustomRecordTypePermissionsList
     */
    public function addToPermissions(\StructType\CustomRecordTypePermissions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypePermissions) {
            throw new \InvalidArgumentException(sprintf('The permissions property can only contain items of type \StructType\CustomRecordTypePermissions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->permissions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypePermissionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
