<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypePermissions StructType
 * @subpackage Structs
 */
class CustomRecordTypePermissions extends AbstractStructBase
{
    /**
     * The permittedRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $permittedRole;
    /**
     * The permittedLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $permittedLevel;
    /**
     * The restriction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $restriction;
    /**
     * The defaultForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultForm;
    /**
     * The restrictForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $restrictForm;
    /**
     * The searchForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $searchForm;
    /**
     * The searchResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $searchResults;
    /**
     * The listView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $listView;
    /**
     * The listViewRestricted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $listViewRestricted;
    /**
     * The dashboardView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $dashboardView;
    /**
     * The restrictDashboardView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $restrictDashboardView;
    /**
     * The sublistView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sublistView;
    /**
     * The restrictSublistView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $restrictSublistView;
    /**
     * Constructor method for CustomRecordTypePermissions
     * @uses CustomRecordTypePermissions::setPermittedRole()
     * @uses CustomRecordTypePermissions::setPermittedLevel()
     * @uses CustomRecordTypePermissions::setRestriction()
     * @uses CustomRecordTypePermissions::setDefaultForm()
     * @uses CustomRecordTypePermissions::setRestrictForm()
     * @uses CustomRecordTypePermissions::setSearchForm()
     * @uses CustomRecordTypePermissions::setSearchResults()
     * @uses CustomRecordTypePermissions::setListView()
     * @uses CustomRecordTypePermissions::setListViewRestricted()
     * @uses CustomRecordTypePermissions::setDashboardView()
     * @uses CustomRecordTypePermissions::setRestrictDashboardView()
     * @uses CustomRecordTypePermissions::setSublistView()
     * @uses CustomRecordTypePermissions::setRestrictSublistView()
     * @param \StructType\RecordRef $permittedRole
     * @param string $permittedLevel
     * @param string $restriction
     * @param \StructType\RecordRef $defaultForm
     * @param bool $restrictForm
     * @param \StructType\RecordRef $searchForm
     * @param \StructType\RecordRef $searchResults
     * @param \StructType\RecordRef $listView
     * @param bool $listViewRestricted
     * @param \StructType\RecordRef $dashboardView
     * @param bool $restrictDashboardView
     * @param \StructType\RecordRef $sublistView
     * @param bool $restrictSublistView
     */
    public function __construct(\StructType\RecordRef $permittedRole = null, $permittedLevel = null, $restriction = null, \StructType\RecordRef $defaultForm = null, $restrictForm = null, \StructType\RecordRef $searchForm = null, \StructType\RecordRef $searchResults = null, \StructType\RecordRef $listView = null, $listViewRestricted = null, \StructType\RecordRef $dashboardView = null, $restrictDashboardView = null, \StructType\RecordRef $sublistView = null, $restrictSublistView = null)
    {
        $this
            ->setPermittedRole($permittedRole)
            ->setPermittedLevel($permittedLevel)
            ->setRestriction($restriction)
            ->setDefaultForm($defaultForm)
            ->setRestrictForm($restrictForm)
            ->setSearchForm($searchForm)
            ->setSearchResults($searchResults)
            ->setListView($listView)
            ->setListViewRestricted($listViewRestricted)
            ->setDashboardView($dashboardView)
            ->setRestrictDashboardView($restrictDashboardView)
            ->setSublistView($sublistView)
            ->setRestrictSublistView($restrictSublistView);
    }
    /**
     * Get permittedRole value
     * @return \StructType\RecordRef|null
     */
    public function getPermittedRole()
    {
        return $this->permittedRole;
    }
    /**
     * Set permittedRole value
     * @param \StructType\RecordRef $permittedRole
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setPermittedRole(\StructType\RecordRef $permittedRole = null)
    {
        $this->permittedRole = $permittedRole;
        return $this;
    }
    /**
     * Get permittedLevel value
     * @return string|null
     */
    public function getPermittedLevel()
    {
        return $this->permittedLevel;
    }
    /**
     * Set permittedLevel value
     * @uses \EnumType\CustomRecordTypePermissionsPermittedLevel::valueIsValid()
     * @uses \EnumType\CustomRecordTypePermissionsPermittedLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $permittedLevel
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setPermittedLevel($permittedLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomRecordTypePermissionsPermittedLevel::valueIsValid($permittedLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomRecordTypePermissionsPermittedLevel', is_array($permittedLevel) ? implode(', ', $permittedLevel) : var_export($permittedLevel, true), implode(', ', \EnumType\CustomRecordTypePermissionsPermittedLevel::getValidValues())), __LINE__);
        }
        $this->permittedLevel = $permittedLevel;
        return $this;
    }
    /**
     * Get restriction value
     * @return string|null
     */
    public function getRestriction()
    {
        return $this->restriction;
    }
    /**
     * Set restriction value
     * @uses \EnumType\CustomRecordTypePermissionsRestriction::valueIsValid()
     * @uses \EnumType\CustomRecordTypePermissionsRestriction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restriction
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setRestriction($restriction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomRecordTypePermissionsRestriction::valueIsValid($restriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomRecordTypePermissionsRestriction', is_array($restriction) ? implode(', ', $restriction) : var_export($restriction, true), implode(', ', \EnumType\CustomRecordTypePermissionsRestriction::getValidValues())), __LINE__);
        }
        $this->restriction = $restriction;
        return $this;
    }
    /**
     * Get defaultForm value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultForm()
    {
        return $this->defaultForm;
    }
    /**
     * Set defaultForm value
     * @param \StructType\RecordRef $defaultForm
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setDefaultForm(\StructType\RecordRef $defaultForm = null)
    {
        $this->defaultForm = $defaultForm;
        return $this;
    }
    /**
     * Get restrictForm value
     * @return bool|null
     */
    public function getRestrictForm()
    {
        return $this->restrictForm;
    }
    /**
     * Set restrictForm value
     * @param bool $restrictForm
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setRestrictForm($restrictForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictForm) && !is_bool($restrictForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictForm, true), gettype($restrictForm)), __LINE__);
        }
        $this->restrictForm = $restrictForm;
        return $this;
    }
    /**
     * Get searchForm value
     * @return \StructType\RecordRef|null
     */
    public function getSearchForm()
    {
        return $this->searchForm;
    }
    /**
     * Set searchForm value
     * @param \StructType\RecordRef $searchForm
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setSearchForm(\StructType\RecordRef $searchForm = null)
    {
        $this->searchForm = $searchForm;
        return $this;
    }
    /**
     * Get searchResults value
     * @return \StructType\RecordRef|null
     */
    public function getSearchResults()
    {
        return $this->searchResults;
    }
    /**
     * Set searchResults value
     * @param \StructType\RecordRef $searchResults
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setSearchResults(\StructType\RecordRef $searchResults = null)
    {
        $this->searchResults = $searchResults;
        return $this;
    }
    /**
     * Get listView value
     * @return \StructType\RecordRef|null
     */
    public function getListView()
    {
        return $this->listView;
    }
    /**
     * Set listView value
     * @param \StructType\RecordRef $listView
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setListView(\StructType\RecordRef $listView = null)
    {
        $this->listView = $listView;
        return $this;
    }
    /**
     * Get listViewRestricted value
     * @return bool|null
     */
    public function getListViewRestricted()
    {
        return $this->listViewRestricted;
    }
    /**
     * Set listViewRestricted value
     * @param bool $listViewRestricted
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setListViewRestricted($listViewRestricted = null)
    {
        // validation for constraint: boolean
        if (!is_null($listViewRestricted) && !is_bool($listViewRestricted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($listViewRestricted, true), gettype($listViewRestricted)), __LINE__);
        }
        $this->listViewRestricted = $listViewRestricted;
        return $this;
    }
    /**
     * Get dashboardView value
     * @return \StructType\RecordRef|null
     */
    public function getDashboardView()
    {
        return $this->dashboardView;
    }
    /**
     * Set dashboardView value
     * @param \StructType\RecordRef $dashboardView
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setDashboardView(\StructType\RecordRef $dashboardView = null)
    {
        $this->dashboardView = $dashboardView;
        return $this;
    }
    /**
     * Get restrictDashboardView value
     * @return bool|null
     */
    public function getRestrictDashboardView()
    {
        return $this->restrictDashboardView;
    }
    /**
     * Set restrictDashboardView value
     * @param bool $restrictDashboardView
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setRestrictDashboardView($restrictDashboardView = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictDashboardView) && !is_bool($restrictDashboardView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictDashboardView, true), gettype($restrictDashboardView)), __LINE__);
        }
        $this->restrictDashboardView = $restrictDashboardView;
        return $this;
    }
    /**
     * Get sublistView value
     * @return \StructType\RecordRef|null
     */
    public function getSublistView()
    {
        return $this->sublistView;
    }
    /**
     * Set sublistView value
     * @param \StructType\RecordRef $sublistView
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setSublistView(\StructType\RecordRef $sublistView = null)
    {
        $this->sublistView = $sublistView;
        return $this;
    }
    /**
     * Get restrictSublistView value
     * @return bool|null
     */
    public function getRestrictSublistView()
    {
        return $this->restrictSublistView;
    }
    /**
     * Set restrictSublistView value
     * @param bool $restrictSublistView
     * @return \StructType\CustomRecordTypePermissions
     */
    public function setRestrictSublistView($restrictSublistView = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictSublistView) && !is_bool($restrictSublistView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictSublistView, true), gettype($restrictSublistView)), __LINE__);
        }
        $this->restrictSublistView = $restrictSublistView;
        return $this;
    }
}
