<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeLinksList StructType
 * @subpackage Structs
 */
class CustomRecordTypeLinksList extends AbstractStructBase
{
    /**
     * The links
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeLinks[]
     */
    public $links;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeLinksList
     * @uses CustomRecordTypeLinksList::setLinks()
     * @uses CustomRecordTypeLinksList::setReplaceAll()
     * @param \StructType\CustomRecordTypeLinks[] $links
     * @param bool $replaceAll
     */
    public function __construct(array $links = array(), $replaceAll = true)
    {
        $this
            ->setLinks($links)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get links value
     * @return \StructType\CustomRecordTypeLinks[]|null
     */
    public function getLinks()
    {
        return $this->links;
    }
    /**
     * This method is responsible for validating the values passed to the setLinks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinksForArrayConstraintsFromSetLinks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeLinksListLinksItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeLinksListLinksItem instanceof \StructType\CustomRecordTypeLinks) {
                $invalidValues[] = is_object($customRecordTypeLinksListLinksItem) ? get_class($customRecordTypeLinksListLinksItem) : sprintf('%s(%s)', gettype($customRecordTypeLinksListLinksItem), var_export($customRecordTypeLinksListLinksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The links property can only contain items of type \StructType\CustomRecordTypeLinks, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set links value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeLinks[] $links
     * @return \StructType\CustomRecordTypeLinksList
     */
    public function setLinks(array $links = array())
    {
        // validation for constraint: array
        if ('' !== ($linksArrayErrorMessage = self::validateLinksForArrayConstraintsFromSetLinks($links))) {
            throw new \InvalidArgumentException($linksArrayErrorMessage, __LINE__);
        }
        $this->links = $links;
        return $this;
    }
    /**
     * Add item to links value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeLinks $item
     * @return \StructType\CustomRecordTypeLinksList
     */
    public function addToLinks(\StructType\CustomRecordTypeLinks $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeLinks) {
            throw new \InvalidArgumentException(sprintf('The links property can only contain items of type \StructType\CustomRecordTypeLinks, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->links[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeLinksList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
