<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeFormsList StructType
 * @subpackage Structs
 */
class CustomRecordTypeFormsList extends AbstractStructBase
{
    /**
     * The forms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeForms[]
     */
    public $forms;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeFormsList
     * @uses CustomRecordTypeFormsList::setForms()
     * @uses CustomRecordTypeFormsList::setReplaceAll()
     * @param \StructType\CustomRecordTypeForms[] $forms
     * @param bool $replaceAll
     */
    public function __construct(array $forms = array(), $replaceAll = true)
    {
        $this
            ->setForms($forms)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get forms value
     * @return \StructType\CustomRecordTypeForms[]|null
     */
    public function getForms()
    {
        return $this->forms;
    }
    /**
     * This method is responsible for validating the values passed to the setForms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setForms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormsForArrayConstraintsFromSetForms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeFormsListFormsItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeFormsListFormsItem instanceof \StructType\CustomRecordTypeForms) {
                $invalidValues[] = is_object($customRecordTypeFormsListFormsItem) ? get_class($customRecordTypeFormsListFormsItem) : sprintf('%s(%s)', gettype($customRecordTypeFormsListFormsItem), var_export($customRecordTypeFormsListFormsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The forms property can only contain items of type \StructType\CustomRecordTypeForms, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set forms value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeForms[] $forms
     * @return \StructType\CustomRecordTypeFormsList
     */
    public function setForms(array $forms = array())
    {
        // validation for constraint: array
        if ('' !== ($formsArrayErrorMessage = self::validateFormsForArrayConstraintsFromSetForms($forms))) {
            throw new \InvalidArgumentException($formsArrayErrorMessage, __LINE__);
        }
        $this->forms = $forms;
        return $this;
    }
    /**
     * Add item to forms value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeForms $item
     * @return \StructType\CustomRecordTypeFormsList
     */
    public function addToForms(\StructType\CustomRecordTypeForms $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeForms) {
            throw new \InvalidArgumentException(sprintf('The forms property can only contain items of type \StructType\CustomRecordTypeForms, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->forms[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeFormsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
