<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordType StructType
 * Meta information extracted from the WSDL
 * - type: setupCustom:CustomRecordType
 * @subpackage Structs
 */
class CustomRecordType extends Record
{
    /**
     * The recordName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recordName;
    /**
     * The includeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeName;
    /**
     * The showId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showId;
    /**
     * The showCreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showCreationDate;
    /**
     * The showCreationDateOnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showCreationDateOnList;
    /**
     * The showLastModified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showLastModified;
    /**
     * The showLastModifiedOnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showLastModifiedOnList;
    /**
     * The showOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showOwner;
    /**
     * The showOwnerOnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showOwnerOnList;
    /**
     * The showOwnerAllowChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showOwnerAllowChange;
    /**
     * The accessType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessType;
    /**
     * The allowAttachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowAttachments;
    /**
     * The showNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showNotes;
    /**
     * The enableMailMerge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enableMailMerge;
    /**
     * The isOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOrdered;
    /**
     * The isAvailableOffline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isAvailableOffline;
    /**
     * The allowQuickSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowQuickSearch;
    /**
     * The hierarchical
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hierarchical;
    /**
     * The enableDle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enableDle;
    /**
     * The enableNameTranslation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enableNameTranslation;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The disclaimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $disclaimer;
    /**
     * The enableNumbering
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enableNumbering;
    /**
     * The numberingPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberingPrefix;
    /**
     * The numberingSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberingSuffix;
    /**
     * The numberingMinDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberingMinDigits;
    /**
     * The numberingInit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberingInit;
    /**
     * The numberingCurrentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberingCurrentNumber;
    /**
     * The allowNumberingOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowNumberingOverride;
    /**
     * The isNumberingUpdateable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isNumberingUpdateable;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The tabsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeTabsList
     */
    public $tabsList;
    /**
     * The sublistsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeSublistsList
     */
    public $sublistsList;
    /**
     * The formsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeFormsList
     */
    public $formsList;
    /**
     * The onlineFormsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeOnlineFormsList
     */
    public $onlineFormsList;
    /**
     * The permissionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypePermissionsList
     */
    public $permissionsList;
    /**
     * The linksList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeLinksList
     */
    public $linksList;
    /**
     * The managersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeManagersList
     */
    public $managersList;
    /**
     * The childrenList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeChildrenList
     */
    public $childrenList;
    /**
     * The parentsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeParentsList
     */
    public $parentsList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeTranslationsList
     */
    public $translationsList;
    /**
     * The scriptId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scriptId;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for CustomRecordType
     * @uses CustomRecordType::setRecordName()
     * @uses CustomRecordType::setIncludeName()
     * @uses CustomRecordType::setShowId()
     * @uses CustomRecordType::setShowCreationDate()
     * @uses CustomRecordType::setShowCreationDateOnList()
     * @uses CustomRecordType::setShowLastModified()
     * @uses CustomRecordType::setShowLastModifiedOnList()
     * @uses CustomRecordType::setShowOwner()
     * @uses CustomRecordType::setShowOwnerOnList()
     * @uses CustomRecordType::setShowOwnerAllowChange()
     * @uses CustomRecordType::setAccessType()
     * @uses CustomRecordType::setAllowAttachments()
     * @uses CustomRecordType::setShowNotes()
     * @uses CustomRecordType::setEnableMailMerge()
     * @uses CustomRecordType::setIsOrdered()
     * @uses CustomRecordType::setIsAvailableOffline()
     * @uses CustomRecordType::setAllowQuickSearch()
     * @uses CustomRecordType::setHierarchical()
     * @uses CustomRecordType::setEnableDle()
     * @uses CustomRecordType::setEnableNameTranslation()
     * @uses CustomRecordType::setIsInactive()
     * @uses CustomRecordType::setDisclaimer()
     * @uses CustomRecordType::setEnableNumbering()
     * @uses CustomRecordType::setNumberingPrefix()
     * @uses CustomRecordType::setNumberingSuffix()
     * @uses CustomRecordType::setNumberingMinDigits()
     * @uses CustomRecordType::setNumberingInit()
     * @uses CustomRecordType::setNumberingCurrentNumber()
     * @uses CustomRecordType::setAllowNumberingOverride()
     * @uses CustomRecordType::setIsNumberingUpdateable()
     * @uses CustomRecordType::setOwner()
     * @uses CustomRecordType::setDescription()
     * @uses CustomRecordType::setTabsList()
     * @uses CustomRecordType::setSublistsList()
     * @uses CustomRecordType::setFormsList()
     * @uses CustomRecordType::setOnlineFormsList()
     * @uses CustomRecordType::setPermissionsList()
     * @uses CustomRecordType::setLinksList()
     * @uses CustomRecordType::setManagersList()
     * @uses CustomRecordType::setChildrenList()
     * @uses CustomRecordType::setParentsList()
     * @uses CustomRecordType::setTranslationsList()
     * @uses CustomRecordType::setScriptId()
     * @uses CustomRecordType::setCustomFieldList()
     * @uses CustomRecordType::setInternalId()
     * @param string $recordName
     * @param bool $includeName
     * @param bool $showId
     * @param bool $showCreationDate
     * @param bool $showCreationDateOnList
     * @param bool $showLastModified
     * @param bool $showLastModifiedOnList
     * @param bool $showOwner
     * @param bool $showOwnerOnList
     * @param bool $showOwnerAllowChange
     * @param string $accessType
     * @param bool $allowAttachments
     * @param bool $showNotes
     * @param bool $enableMailMerge
     * @param bool $isOrdered
     * @param bool $isAvailableOffline
     * @param bool $allowQuickSearch
     * @param bool $hierarchical
     * @param bool $enableDle
     * @param bool $enableNameTranslation
     * @param bool $isInactive
     * @param string $disclaimer
     * @param bool $enableNumbering
     * @param string $numberingPrefix
     * @param string $numberingSuffix
     * @param int $numberingMinDigits
     * @param int $numberingInit
     * @param int $numberingCurrentNumber
     * @param bool $allowNumberingOverride
     * @param bool $isNumberingUpdateable
     * @param \StructType\RecordRef $owner
     * @param string $description
     * @param \StructType\CustomRecordTypeTabsList $tabsList
     * @param \StructType\CustomRecordTypeSublistsList $sublistsList
     * @param \StructType\CustomRecordTypeFormsList $formsList
     * @param \StructType\CustomRecordTypeOnlineFormsList $onlineFormsList
     * @param \StructType\CustomRecordTypePermissionsList $permissionsList
     * @param \StructType\CustomRecordTypeLinksList $linksList
     * @param \StructType\CustomRecordTypeManagersList $managersList
     * @param \StructType\CustomRecordTypeChildrenList $childrenList
     * @param \StructType\CustomRecordTypeParentsList $parentsList
     * @param \StructType\CustomRecordTypeTranslationsList $translationsList
     * @param string $scriptId
     * @param \StructType\CustomRecordTypeFieldList $customFieldList
     * @param string $internalId
     */
    public function __construct($recordName = null, $includeName = null, $showId = null, $showCreationDate = null, $showCreationDateOnList = null, $showLastModified = null, $showLastModifiedOnList = null, $showOwner = null, $showOwnerOnList = null, $showOwnerAllowChange = null, $accessType = null, $allowAttachments = null, $showNotes = null, $enableMailMerge = null, $isOrdered = null, $isAvailableOffline = null, $allowQuickSearch = null, $hierarchical = null, $enableDle = null, $enableNameTranslation = null, $isInactive = null, $disclaimer = null, $enableNumbering = null, $numberingPrefix = null, $numberingSuffix = null, $numberingMinDigits = null, $numberingInit = null, $numberingCurrentNumber = null, $allowNumberingOverride = null, $isNumberingUpdateable = null, \StructType\RecordRef $owner = null, $description = null, \StructType\CustomRecordTypeTabsList $tabsList = null, \StructType\CustomRecordTypeSublistsList $sublistsList = null, \StructType\CustomRecordTypeFormsList $formsList = null, \StructType\CustomRecordTypeOnlineFormsList $onlineFormsList = null, \StructType\CustomRecordTypePermissionsList $permissionsList = null, \StructType\CustomRecordTypeLinksList $linksList = null, \StructType\CustomRecordTypeManagersList $managersList = null, \StructType\CustomRecordTypeChildrenList $childrenList = null, \StructType\CustomRecordTypeParentsList $parentsList = null, \StructType\CustomRecordTypeTranslationsList $translationsList = null, $scriptId = null, \StructType\CustomRecordTypeFieldList $customFieldList = null, $internalId = null)
    {
        $this
            ->setRecordName($recordName)
            ->setIncludeName($includeName)
            ->setShowId($showId)
            ->setShowCreationDate($showCreationDate)
            ->setShowCreationDateOnList($showCreationDateOnList)
            ->setShowLastModified($showLastModified)
            ->setShowLastModifiedOnList($showLastModifiedOnList)
            ->setShowOwner($showOwner)
            ->setShowOwnerOnList($showOwnerOnList)
            ->setShowOwnerAllowChange($showOwnerAllowChange)
            ->setAccessType($accessType)
            ->setAllowAttachments($allowAttachments)
            ->setShowNotes($showNotes)
            ->setEnableMailMerge($enableMailMerge)
            ->setIsOrdered($isOrdered)
            ->setIsAvailableOffline($isAvailableOffline)
            ->setAllowQuickSearch($allowQuickSearch)
            ->setHierarchical($hierarchical)
            ->setEnableDle($enableDle)
            ->setEnableNameTranslation($enableNameTranslation)
            ->setIsInactive($isInactive)
            ->setDisclaimer($disclaimer)
            ->setEnableNumbering($enableNumbering)
            ->setNumberingPrefix($numberingPrefix)
            ->setNumberingSuffix($numberingSuffix)
            ->setNumberingMinDigits($numberingMinDigits)
            ->setNumberingInit($numberingInit)
            ->setNumberingCurrentNumber($numberingCurrentNumber)
            ->setAllowNumberingOverride($allowNumberingOverride)
            ->setIsNumberingUpdateable($isNumberingUpdateable)
            ->setOwner($owner)
            ->setDescription($description)
            ->setTabsList($tabsList)
            ->setSublistsList($sublistsList)
            ->setFormsList($formsList)
            ->setOnlineFormsList($onlineFormsList)
            ->setPermissionsList($permissionsList)
            ->setLinksList($linksList)
            ->setManagersList($managersList)
            ->setChildrenList($childrenList)
            ->setParentsList($parentsList)
            ->setTranslationsList($translationsList)
            ->setScriptId($scriptId)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId);
    }
    /**
     * Get recordName value
     * @return string|null
     */
    public function getRecordName()
    {
        return $this->recordName;
    }
    /**
     * Set recordName value
     * @param string $recordName
     * @return \StructType\CustomRecordType
     */
    public function setRecordName($recordName = null)
    {
        // validation for constraint: string
        if (!is_null($recordName) && !is_string($recordName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordName, true), gettype($recordName)), __LINE__);
        }
        $this->recordName = $recordName;
        return $this;
    }
    /**
     * Get includeName value
     * @return bool|null
     */
    public function getIncludeName()
    {
        return $this->includeName;
    }
    /**
     * Set includeName value
     * @param bool $includeName
     * @return \StructType\CustomRecordType
     */
    public function setIncludeName($includeName = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeName) && !is_bool($includeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeName, true), gettype($includeName)), __LINE__);
        }
        $this->includeName = $includeName;
        return $this;
    }
    /**
     * Get showId value
     * @return bool|null
     */
    public function getShowId()
    {
        return $this->showId;
    }
    /**
     * Set showId value
     * @param bool $showId
     * @return \StructType\CustomRecordType
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: boolean
        if (!is_null($showId) && !is_bool($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        $this->showId = $showId;
        return $this;
    }
    /**
     * Get showCreationDate value
     * @return bool|null
     */
    public function getShowCreationDate()
    {
        return $this->showCreationDate;
    }
    /**
     * Set showCreationDate value
     * @param bool $showCreationDate
     * @return \StructType\CustomRecordType
     */
    public function setShowCreationDate($showCreationDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCreationDate) && !is_bool($showCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCreationDate, true), gettype($showCreationDate)), __LINE__);
        }
        $this->showCreationDate = $showCreationDate;
        return $this;
    }
    /**
     * Get showCreationDateOnList value
     * @return bool|null
     */
    public function getShowCreationDateOnList()
    {
        return $this->showCreationDateOnList;
    }
    /**
     * Set showCreationDateOnList value
     * @param bool $showCreationDateOnList
     * @return \StructType\CustomRecordType
     */
    public function setShowCreationDateOnList($showCreationDateOnList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCreationDateOnList) && !is_bool($showCreationDateOnList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCreationDateOnList, true), gettype($showCreationDateOnList)), __LINE__);
        }
        $this->showCreationDateOnList = $showCreationDateOnList;
        return $this;
    }
    /**
     * Get showLastModified value
     * @return bool|null
     */
    public function getShowLastModified()
    {
        return $this->showLastModified;
    }
    /**
     * Set showLastModified value
     * @param bool $showLastModified
     * @return \StructType\CustomRecordType
     */
    public function setShowLastModified($showLastModified = null)
    {
        // validation for constraint: boolean
        if (!is_null($showLastModified) && !is_bool($showLastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showLastModified, true), gettype($showLastModified)), __LINE__);
        }
        $this->showLastModified = $showLastModified;
        return $this;
    }
    /**
     * Get showLastModifiedOnList value
     * @return bool|null
     */
    public function getShowLastModifiedOnList()
    {
        return $this->showLastModifiedOnList;
    }
    /**
     * Set showLastModifiedOnList value
     * @param bool $showLastModifiedOnList
     * @return \StructType\CustomRecordType
     */
    public function setShowLastModifiedOnList($showLastModifiedOnList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showLastModifiedOnList) && !is_bool($showLastModifiedOnList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showLastModifiedOnList, true), gettype($showLastModifiedOnList)), __LINE__);
        }
        $this->showLastModifiedOnList = $showLastModifiedOnList;
        return $this;
    }
    /**
     * Get showOwner value
     * @return bool|null
     */
    public function getShowOwner()
    {
        return $this->showOwner;
    }
    /**
     * Set showOwner value
     * @param bool $showOwner
     * @return \StructType\CustomRecordType
     */
    public function setShowOwner($showOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOwner) && !is_bool($showOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOwner, true), gettype($showOwner)), __LINE__);
        }
        $this->showOwner = $showOwner;
        return $this;
    }
    /**
     * Get showOwnerOnList value
     * @return bool|null
     */
    public function getShowOwnerOnList()
    {
        return $this->showOwnerOnList;
    }
    /**
     * Set showOwnerOnList value
     * @param bool $showOwnerOnList
     * @return \StructType\CustomRecordType
     */
    public function setShowOwnerOnList($showOwnerOnList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOwnerOnList) && !is_bool($showOwnerOnList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOwnerOnList, true), gettype($showOwnerOnList)), __LINE__);
        }
        $this->showOwnerOnList = $showOwnerOnList;
        return $this;
    }
    /**
     * Get showOwnerAllowChange value
     * @return bool|null
     */
    public function getShowOwnerAllowChange()
    {
        return $this->showOwnerAllowChange;
    }
    /**
     * Set showOwnerAllowChange value
     * @param bool $showOwnerAllowChange
     * @return \StructType\CustomRecordType
     */
    public function setShowOwnerAllowChange($showOwnerAllowChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOwnerAllowChange) && !is_bool($showOwnerAllowChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOwnerAllowChange, true), gettype($showOwnerAllowChange)), __LINE__);
        }
        $this->showOwnerAllowChange = $showOwnerAllowChange;
        return $this;
    }
    /**
     * Get accessType value
     * @return string|null
     */
    public function getAccessType()
    {
        return $this->accessType;
    }
    /**
     * Set accessType value
     * @uses \EnumType\CustomRecordTypeAccessType::valueIsValid()
     * @uses \EnumType\CustomRecordTypeAccessType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessType
     * @return \StructType\CustomRecordType
     */
    public function setAccessType($accessType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomRecordTypeAccessType::valueIsValid($accessType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomRecordTypeAccessType', is_array($accessType) ? implode(', ', $accessType) : var_export($accessType, true), implode(', ', \EnumType\CustomRecordTypeAccessType::getValidValues())), __LINE__);
        }
        $this->accessType = $accessType;
        return $this;
    }
    /**
     * Get allowAttachments value
     * @return bool|null
     */
    public function getAllowAttachments()
    {
        return $this->allowAttachments;
    }
    /**
     * Set allowAttachments value
     * @param bool $allowAttachments
     * @return \StructType\CustomRecordType
     */
    public function setAllowAttachments($allowAttachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAttachments) && !is_bool($allowAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowAttachments, true), gettype($allowAttachments)), __LINE__);
        }
        $this->allowAttachments = $allowAttachments;
        return $this;
    }
    /**
     * Get showNotes value
     * @return bool|null
     */
    public function getShowNotes()
    {
        return $this->showNotes;
    }
    /**
     * Set showNotes value
     * @param bool $showNotes
     * @return \StructType\CustomRecordType
     */
    public function setShowNotes($showNotes = null)
    {
        // validation for constraint: boolean
        if (!is_null($showNotes) && !is_bool($showNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showNotes, true), gettype($showNotes)), __LINE__);
        }
        $this->showNotes = $showNotes;
        return $this;
    }
    /**
     * Get enableMailMerge value
     * @return bool|null
     */
    public function getEnableMailMerge()
    {
        return $this->enableMailMerge;
    }
    /**
     * Set enableMailMerge value
     * @param bool $enableMailMerge
     * @return \StructType\CustomRecordType
     */
    public function setEnableMailMerge($enableMailMerge = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableMailMerge) && !is_bool($enableMailMerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableMailMerge, true), gettype($enableMailMerge)), __LINE__);
        }
        $this->enableMailMerge = $enableMailMerge;
        return $this;
    }
    /**
     * Get isOrdered value
     * @return bool|null
     */
    public function getIsOrdered()
    {
        return $this->isOrdered;
    }
    /**
     * Set isOrdered value
     * @param bool $isOrdered
     * @return \StructType\CustomRecordType
     */
    public function setIsOrdered($isOrdered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOrdered) && !is_bool($isOrdered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOrdered, true), gettype($isOrdered)), __LINE__);
        }
        $this->isOrdered = $isOrdered;
        return $this;
    }
    /**
     * Get isAvailableOffline value
     * @return bool|null
     */
    public function getIsAvailableOffline()
    {
        return $this->isAvailableOffline;
    }
    /**
     * Set isAvailableOffline value
     * @param bool $isAvailableOffline
     * @return \StructType\CustomRecordType
     */
    public function setIsAvailableOffline($isAvailableOffline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableOffline) && !is_bool($isAvailableOffline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableOffline, true), gettype($isAvailableOffline)), __LINE__);
        }
        $this->isAvailableOffline = $isAvailableOffline;
        return $this;
    }
    /**
     * Get allowQuickSearch value
     * @return bool|null
     */
    public function getAllowQuickSearch()
    {
        return $this->allowQuickSearch;
    }
    /**
     * Set allowQuickSearch value
     * @param bool $allowQuickSearch
     * @return \StructType\CustomRecordType
     */
    public function setAllowQuickSearch($allowQuickSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowQuickSearch) && !is_bool($allowQuickSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowQuickSearch, true), gettype($allowQuickSearch)), __LINE__);
        }
        $this->allowQuickSearch = $allowQuickSearch;
        return $this;
    }
    /**
     * Get hierarchical value
     * @return bool|null
     */
    public function getHierarchical()
    {
        return $this->hierarchical;
    }
    /**
     * Set hierarchical value
     * @param bool $hierarchical
     * @return \StructType\CustomRecordType
     */
    public function setHierarchical($hierarchical = null)
    {
        // validation for constraint: boolean
        if (!is_null($hierarchical) && !is_bool($hierarchical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hierarchical, true), gettype($hierarchical)), __LINE__);
        }
        $this->hierarchical = $hierarchical;
        return $this;
    }
    /**
     * Get enableDle value
     * @return bool|null
     */
    public function getEnableDle()
    {
        return $this->enableDle;
    }
    /**
     * Set enableDle value
     * @param bool $enableDle
     * @return \StructType\CustomRecordType
     */
    public function setEnableDle($enableDle = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableDle) && !is_bool($enableDle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableDle, true), gettype($enableDle)), __LINE__);
        }
        $this->enableDle = $enableDle;
        return $this;
    }
    /**
     * Get enableNameTranslation value
     * @return bool|null
     */
    public function getEnableNameTranslation()
    {
        return $this->enableNameTranslation;
    }
    /**
     * Set enableNameTranslation value
     * @param bool $enableNameTranslation
     * @return \StructType\CustomRecordType
     */
    public function setEnableNameTranslation($enableNameTranslation = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableNameTranslation) && !is_bool($enableNameTranslation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableNameTranslation, true), gettype($enableNameTranslation)), __LINE__);
        }
        $this->enableNameTranslation = $enableNameTranslation;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\CustomRecordType
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get disclaimer value
     * @return string|null
     */
    public function getDisclaimer()
    {
        return $this->disclaimer;
    }
    /**
     * Set disclaimer value
     * @param string $disclaimer
     * @return \StructType\CustomRecordType
     */
    public function setDisclaimer($disclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($disclaimer) && !is_string($disclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclaimer, true), gettype($disclaimer)), __LINE__);
        }
        $this->disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Get enableNumbering value
     * @return bool|null
     */
    public function getEnableNumbering()
    {
        return $this->enableNumbering;
    }
    /**
     * Set enableNumbering value
     * @param bool $enableNumbering
     * @return \StructType\CustomRecordType
     */
    public function setEnableNumbering($enableNumbering = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableNumbering) && !is_bool($enableNumbering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableNumbering, true), gettype($enableNumbering)), __LINE__);
        }
        $this->enableNumbering = $enableNumbering;
        return $this;
    }
    /**
     * Get numberingPrefix value
     * @return string|null
     */
    public function getNumberingPrefix()
    {
        return $this->numberingPrefix;
    }
    /**
     * Set numberingPrefix value
     * @param string $numberingPrefix
     * @return \StructType\CustomRecordType
     */
    public function setNumberingPrefix($numberingPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($numberingPrefix) && !is_string($numberingPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberingPrefix, true), gettype($numberingPrefix)), __LINE__);
        }
        $this->numberingPrefix = $numberingPrefix;
        return $this;
    }
    /**
     * Get numberingSuffix value
     * @return string|null
     */
    public function getNumberingSuffix()
    {
        return $this->numberingSuffix;
    }
    /**
     * Set numberingSuffix value
     * @param string $numberingSuffix
     * @return \StructType\CustomRecordType
     */
    public function setNumberingSuffix($numberingSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($numberingSuffix) && !is_string($numberingSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberingSuffix, true), gettype($numberingSuffix)), __LINE__);
        }
        $this->numberingSuffix = $numberingSuffix;
        return $this;
    }
    /**
     * Get numberingMinDigits value
     * @return int|null
     */
    public function getNumberingMinDigits()
    {
        return $this->numberingMinDigits;
    }
    /**
     * Set numberingMinDigits value
     * @param int $numberingMinDigits
     * @return \StructType\CustomRecordType
     */
    public function setNumberingMinDigits($numberingMinDigits = null)
    {
        // validation for constraint: int
        if (!is_null($numberingMinDigits) && !(is_int($numberingMinDigits) || ctype_digit($numberingMinDigits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberingMinDigits, true), gettype($numberingMinDigits)), __LINE__);
        }
        $this->numberingMinDigits = $numberingMinDigits;
        return $this;
    }
    /**
     * Get numberingInit value
     * @return int|null
     */
    public function getNumberingInit()
    {
        return $this->numberingInit;
    }
    /**
     * Set numberingInit value
     * @param int $numberingInit
     * @return \StructType\CustomRecordType
     */
    public function setNumberingInit($numberingInit = null)
    {
        // validation for constraint: int
        if (!is_null($numberingInit) && !(is_int($numberingInit) || ctype_digit($numberingInit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberingInit, true), gettype($numberingInit)), __LINE__);
        }
        $this->numberingInit = $numberingInit;
        return $this;
    }
    /**
     * Get numberingCurrentNumber value
     * @return int|null
     */
    public function getNumberingCurrentNumber()
    {
        return $this->numberingCurrentNumber;
    }
    /**
     * Set numberingCurrentNumber value
     * @param int $numberingCurrentNumber
     * @return \StructType\CustomRecordType
     */
    public function setNumberingCurrentNumber($numberingCurrentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($numberingCurrentNumber) && !(is_int($numberingCurrentNumber) || ctype_digit($numberingCurrentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberingCurrentNumber, true), gettype($numberingCurrentNumber)), __LINE__);
        }
        $this->numberingCurrentNumber = $numberingCurrentNumber;
        return $this;
    }
    /**
     * Get allowNumberingOverride value
     * @return bool|null
     */
    public function getAllowNumberingOverride()
    {
        return $this->allowNumberingOverride;
    }
    /**
     * Set allowNumberingOverride value
     * @param bool $allowNumberingOverride
     * @return \StructType\CustomRecordType
     */
    public function setAllowNumberingOverride($allowNumberingOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNumberingOverride) && !is_bool($allowNumberingOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNumberingOverride, true), gettype($allowNumberingOverride)), __LINE__);
        }
        $this->allowNumberingOverride = $allowNumberingOverride;
        return $this;
    }
    /**
     * Get isNumberingUpdateable value
     * @return bool|null
     */
    public function getIsNumberingUpdateable()
    {
        return $this->isNumberingUpdateable;
    }
    /**
     * Set isNumberingUpdateable value
     * @param bool $isNumberingUpdateable
     * @return \StructType\CustomRecordType
     */
    public function setIsNumberingUpdateable($isNumberingUpdateable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNumberingUpdateable) && !is_bool($isNumberingUpdateable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNumberingUpdateable, true), gettype($isNumberingUpdateable)), __LINE__);
        }
        $this->isNumberingUpdateable = $isNumberingUpdateable;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\CustomRecordType
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomRecordType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get tabsList value
     * @return \StructType\CustomRecordTypeTabsList|null
     */
    public function getTabsList()
    {
        return $this->tabsList;
    }
    /**
     * Set tabsList value
     * @param \StructType\CustomRecordTypeTabsList $tabsList
     * @return \StructType\CustomRecordType
     */
    public function setTabsList(\StructType\CustomRecordTypeTabsList $tabsList = null)
    {
        $this->tabsList = $tabsList;
        return $this;
    }
    /**
     * Get sublistsList value
     * @return \StructType\CustomRecordTypeSublistsList|null
     */
    public function getSublistsList()
    {
        return $this->sublistsList;
    }
    /**
     * Set sublistsList value
     * @param \StructType\CustomRecordTypeSublistsList $sublistsList
     * @return \StructType\CustomRecordType
     */
    public function setSublistsList(\StructType\CustomRecordTypeSublistsList $sublistsList = null)
    {
        $this->sublistsList = $sublistsList;
        return $this;
    }
    /**
     * Get formsList value
     * @return \StructType\CustomRecordTypeFormsList|null
     */
    public function getFormsList()
    {
        return $this->formsList;
    }
    /**
     * Set formsList value
     * @param \StructType\CustomRecordTypeFormsList $formsList
     * @return \StructType\CustomRecordType
     */
    public function setFormsList(\StructType\CustomRecordTypeFormsList $formsList = null)
    {
        $this->formsList = $formsList;
        return $this;
    }
    /**
     * Get onlineFormsList value
     * @return \StructType\CustomRecordTypeOnlineFormsList|null
     */
    public function getOnlineFormsList()
    {
        return $this->onlineFormsList;
    }
    /**
     * Set onlineFormsList value
     * @param \StructType\CustomRecordTypeOnlineFormsList $onlineFormsList
     * @return \StructType\CustomRecordType
     */
    public function setOnlineFormsList(\StructType\CustomRecordTypeOnlineFormsList $onlineFormsList = null)
    {
        $this->onlineFormsList = $onlineFormsList;
        return $this;
    }
    /**
     * Get permissionsList value
     * @return \StructType\CustomRecordTypePermissionsList|null
     */
    public function getPermissionsList()
    {
        return $this->permissionsList;
    }
    /**
     * Set permissionsList value
     * @param \StructType\CustomRecordTypePermissionsList $permissionsList
     * @return \StructType\CustomRecordType
     */
    public function setPermissionsList(\StructType\CustomRecordTypePermissionsList $permissionsList = null)
    {
        $this->permissionsList = $permissionsList;
        return $this;
    }
    /**
     * Get linksList value
     * @return \StructType\CustomRecordTypeLinksList|null
     */
    public function getLinksList()
    {
        return $this->linksList;
    }
    /**
     * Set linksList value
     * @param \StructType\CustomRecordTypeLinksList $linksList
     * @return \StructType\CustomRecordType
     */
    public function setLinksList(\StructType\CustomRecordTypeLinksList $linksList = null)
    {
        $this->linksList = $linksList;
        return $this;
    }
    /**
     * Get managersList value
     * @return \StructType\CustomRecordTypeManagersList|null
     */
    public function getManagersList()
    {
        return $this->managersList;
    }
    /**
     * Set managersList value
     * @param \StructType\CustomRecordTypeManagersList $managersList
     * @return \StructType\CustomRecordType
     */
    public function setManagersList(\StructType\CustomRecordTypeManagersList $managersList = null)
    {
        $this->managersList = $managersList;
        return $this;
    }
    /**
     * Get childrenList value
     * @return \StructType\CustomRecordTypeChildrenList|null
     */
    public function getChildrenList()
    {
        return $this->childrenList;
    }
    /**
     * Set childrenList value
     * @param \StructType\CustomRecordTypeChildrenList $childrenList
     * @return \StructType\CustomRecordType
     */
    public function setChildrenList(\StructType\CustomRecordTypeChildrenList $childrenList = null)
    {
        $this->childrenList = $childrenList;
        return $this;
    }
    /**
     * Get parentsList value
     * @return \StructType\CustomRecordTypeParentsList|null
     */
    public function getParentsList()
    {
        return $this->parentsList;
    }
    /**
     * Set parentsList value
     * @param \StructType\CustomRecordTypeParentsList $parentsList
     * @return \StructType\CustomRecordType
     */
    public function setParentsList(\StructType\CustomRecordTypeParentsList $parentsList = null)
    {
        $this->parentsList = $parentsList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\CustomRecordTypeTranslationsList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\CustomRecordTypeTranslationsList $translationsList
     * @return \StructType\CustomRecordType
     */
    public function setTranslationsList(\StructType\CustomRecordTypeTranslationsList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\CustomRecordType
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomRecordTypeFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomRecordTypeFieldList $customFieldList
     * @return \StructType\CustomRecordType
     */
    public function setCustomFieldList(\StructType\CustomRecordTypeFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomRecordType
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
