<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTranslations StructType
 * @subpackage Structs
 */
class CustomRecordTranslations extends AbstractStructBase
{
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locale;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * Constructor method for CustomRecordTranslations
     * @uses CustomRecordTranslations::setLocale()
     * @uses CustomRecordTranslations::setLanguage()
     * @uses CustomRecordTranslations::setLabel()
     * @param string $locale
     * @param string $language
     * @param string $label
     */
    public function __construct($locale = null, $language = null, $label = null)
    {
        $this
            ->setLocale($locale)
            ->setLanguage($language)
            ->setLabel($label);
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\CustomRecordTranslations
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($locale) ? implode(', ', $locale) : var_export($locale, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\CustomRecordTranslations
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\CustomRecordTranslations
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
}
