<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordRef StructType
 * @subpackage Structs
 */
class CustomRecordRef extends BaseRef
{
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * The typeId
     * @var string
     */
    public $typeId;
    /**
     * The scriptId
     * @var string
     */
    public $scriptId;
    /**
     * Constructor method for CustomRecordRef
     * @uses CustomRecordRef::setInternalId()
     * @uses CustomRecordRef::setExternalId()
     * @uses CustomRecordRef::setTypeId()
     * @uses CustomRecordRef::setScriptId()
     * @param string $internalId
     * @param string $externalId
     * @param string $typeId
     * @param string $scriptId
     */
    public function __construct($internalId = null, $externalId = null, $typeId = null, $scriptId = null)
    {
        $this
            ->setInternalId($internalId)
            ->setExternalId($externalId)
            ->setTypeId($typeId)
            ->setScriptId($scriptId);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomRecordRef
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CustomRecordRef
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get typeId value
     * @return string|null
     */
    public function getTypeId()
    {
        return $this->typeId;
    }
    /**
     * Set typeId value
     * @param string $typeId
     * @return \StructType\CustomRecordRef
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->typeId = $typeId;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\CustomRecordRef
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
}
