<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecord StructType
 * Meta information extracted from the WSDL
 * - type: setupCustom:CustomRecord
 * @subpackage Structs
 */
class CustomRecord extends Record
{
    /**
     * The customRecordId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customRecordId;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The disclaimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $disclaimer;
    /**
     * The created
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created;
    /**
     * The lastModified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModified;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The autoName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoName;
    /**
     * The altName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altName;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The recType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $recType;
    /**
     * The enableNumbering
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enableNumbering;
    /**
     * The numberingPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberingPrefix;
    /**
     * The numberingSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberingSuffix;
    /**
     * The numberingMinDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberingMinDigits;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The numberingInit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberingInit;
    /**
     * The numberingCurrentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numberingCurrentNumber;
    /**
     * The allowNumberingOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowNumberingOverride;
    /**
     * The isNumberingUpdateable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isNumberingUpdateable;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomRecordTranslationsList
     */
    public $translationsList;
    /**
     * The includeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeName;
    /**
     * The showId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showId;
    /**
     * The showCreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showCreationDate;
    /**
     * The showCreationDateOnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showCreationDateOnList;
    /**
     * The showLastModified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showLastModified;
    /**
     * The showLastModifiedOnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showLastModifiedOnList;
    /**
     * The showOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showOwner;
    /**
     * The showOwnerOnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showOwnerOnList;
    /**
     * The showOwnerAllowChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showOwnerAllowChange;
    /**
     * The usePermissions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $usePermissions;
    /**
     * The allowAttachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowAttachments;
    /**
     * The showNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $showNotes;
    /**
     * The enablEmailMerge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enablEmailMerge;
    /**
     * The isOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOrdered;
    /**
     * The allowInlineEditing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowInlineEditing;
    /**
     * The isAvailableOffline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isAvailableOffline;
    /**
     * The allowQuickSearch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $allowQuickSearch;
    /**
     * The recordName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recordName;
    /**
     * The scriptId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scriptId;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CustomRecord
     * @uses CustomRecord::setCustomRecordId()
     * @uses CustomRecord::setCustomForm()
     * @uses CustomRecord::setIsInactive()
     * @uses CustomRecord::setParent()
     * @uses CustomRecord::setDisclaimer()
     * @uses CustomRecord::setCreated()
     * @uses CustomRecord::setLastModified()
     * @uses CustomRecord::setName()
     * @uses CustomRecord::setAutoName()
     * @uses CustomRecord::setAltName()
     * @uses CustomRecord::setOwner()
     * @uses CustomRecord::setRecType()
     * @uses CustomRecord::setEnableNumbering()
     * @uses CustomRecord::setNumberingPrefix()
     * @uses CustomRecord::setNumberingSuffix()
     * @uses CustomRecord::setNumberingMinDigits()
     * @uses CustomRecord::setDescription()
     * @uses CustomRecord::setNumberingInit()
     * @uses CustomRecord::setNumberingCurrentNumber()
     * @uses CustomRecord::setAllowNumberingOverride()
     * @uses CustomRecord::setIsNumberingUpdateable()
     * @uses CustomRecord::setTranslationsList()
     * @uses CustomRecord::setIncludeName()
     * @uses CustomRecord::setShowId()
     * @uses CustomRecord::setShowCreationDate()
     * @uses CustomRecord::setShowCreationDateOnList()
     * @uses CustomRecord::setShowLastModified()
     * @uses CustomRecord::setShowLastModifiedOnList()
     * @uses CustomRecord::setShowOwner()
     * @uses CustomRecord::setShowOwnerOnList()
     * @uses CustomRecord::setShowOwnerAllowChange()
     * @uses CustomRecord::setUsePermissions()
     * @uses CustomRecord::setAllowAttachments()
     * @uses CustomRecord::setShowNotes()
     * @uses CustomRecord::setEnablEmailMerge()
     * @uses CustomRecord::setIsOrdered()
     * @uses CustomRecord::setAllowInlineEditing()
     * @uses CustomRecord::setIsAvailableOffline()
     * @uses CustomRecord::setAllowQuickSearch()
     * @uses CustomRecord::setRecordName()
     * @uses CustomRecord::setScriptId()
     * @uses CustomRecord::setCustomFieldList()
     * @uses CustomRecord::setInternalId()
     * @uses CustomRecord::setExternalId()
     * @param string $customRecordId
     * @param \StructType\RecordRef $customForm
     * @param bool $isInactive
     * @param \StructType\RecordRef $parent
     * @param string $disclaimer
     * @param string $created
     * @param string $lastModified
     * @param string $name
     * @param bool $autoName
     * @param string $altName
     * @param \StructType\RecordRef $owner
     * @param \StructType\RecordRef $recType
     * @param bool $enableNumbering
     * @param string $numberingPrefix
     * @param string $numberingSuffix
     * @param int $numberingMinDigits
     * @param string $description
     * @param int $numberingInit
     * @param int $numberingCurrentNumber
     * @param bool $allowNumberingOverride
     * @param bool $isNumberingUpdateable
     * @param \StructType\CustomRecordTranslationsList $translationsList
     * @param bool $includeName
     * @param bool $showId
     * @param bool $showCreationDate
     * @param bool $showCreationDateOnList
     * @param bool $showLastModified
     * @param bool $showLastModifiedOnList
     * @param bool $showOwner
     * @param bool $showOwnerOnList
     * @param bool $showOwnerAllowChange
     * @param bool $usePermissions
     * @param bool $allowAttachments
     * @param bool $showNotes
     * @param bool $enablEmailMerge
     * @param bool $isOrdered
     * @param bool $allowInlineEditing
     * @param bool $isAvailableOffline
     * @param bool $allowQuickSearch
     * @param string $recordName
     * @param string $scriptId
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($customRecordId = null, \StructType\RecordRef $customForm = null, $isInactive = null, \StructType\RecordRef $parent = null, $disclaimer = null, $created = null, $lastModified = null, $name = null, $autoName = null, $altName = null, \StructType\RecordRef $owner = null, \StructType\RecordRef $recType = null, $enableNumbering = null, $numberingPrefix = null, $numberingSuffix = null, $numberingMinDigits = null, $description = null, $numberingInit = null, $numberingCurrentNumber = null, $allowNumberingOverride = null, $isNumberingUpdateable = null, \StructType\CustomRecordTranslationsList $translationsList = null, $includeName = null, $showId = null, $showCreationDate = null, $showCreationDateOnList = null, $showLastModified = null, $showLastModifiedOnList = null, $showOwner = null, $showOwnerOnList = null, $showOwnerAllowChange = null, $usePermissions = null, $allowAttachments = null, $showNotes = null, $enablEmailMerge = null, $isOrdered = null, $allowInlineEditing = null, $isAvailableOffline = null, $allowQuickSearch = null, $recordName = null, $scriptId = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomRecordId($customRecordId)
            ->setCustomForm($customForm)
            ->setIsInactive($isInactive)
            ->setParent($parent)
            ->setDisclaimer($disclaimer)
            ->setCreated($created)
            ->setLastModified($lastModified)
            ->setName($name)
            ->setAutoName($autoName)
            ->setAltName($altName)
            ->setOwner($owner)
            ->setRecType($recType)
            ->setEnableNumbering($enableNumbering)
            ->setNumberingPrefix($numberingPrefix)
            ->setNumberingSuffix($numberingSuffix)
            ->setNumberingMinDigits($numberingMinDigits)
            ->setDescription($description)
            ->setNumberingInit($numberingInit)
            ->setNumberingCurrentNumber($numberingCurrentNumber)
            ->setAllowNumberingOverride($allowNumberingOverride)
            ->setIsNumberingUpdateable($isNumberingUpdateable)
            ->setTranslationsList($translationsList)
            ->setIncludeName($includeName)
            ->setShowId($showId)
            ->setShowCreationDate($showCreationDate)
            ->setShowCreationDateOnList($showCreationDateOnList)
            ->setShowLastModified($showLastModified)
            ->setShowLastModifiedOnList($showLastModifiedOnList)
            ->setShowOwner($showOwner)
            ->setShowOwnerOnList($showOwnerOnList)
            ->setShowOwnerAllowChange($showOwnerAllowChange)
            ->setUsePermissions($usePermissions)
            ->setAllowAttachments($allowAttachments)
            ->setShowNotes($showNotes)
            ->setEnablEmailMerge($enablEmailMerge)
            ->setIsOrdered($isOrdered)
            ->setAllowInlineEditing($allowInlineEditing)
            ->setIsAvailableOffline($isAvailableOffline)
            ->setAllowQuickSearch($allowQuickSearch)
            ->setRecordName($recordName)
            ->setScriptId($scriptId)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customRecordId value
     * @return string|null
     */
    public function getCustomRecordId()
    {
        return $this->customRecordId;
    }
    /**
     * Set customRecordId value
     * @param string $customRecordId
     * @return \StructType\CustomRecord
     */
    public function setCustomRecordId($customRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($customRecordId) && !is_string($customRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customRecordId, true), gettype($customRecordId)), __LINE__);
        }
        $this->customRecordId = $customRecordId;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\CustomRecord
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\CustomRecord
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\CustomRecord
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get disclaimer value
     * @return string|null
     */
    public function getDisclaimer()
    {
        return $this->disclaimer;
    }
    /**
     * Set disclaimer value
     * @param string $disclaimer
     * @return \StructType\CustomRecord
     */
    public function setDisclaimer($disclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($disclaimer) && !is_string($disclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclaimer, true), gettype($disclaimer)), __LINE__);
        }
        $this->disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Get created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->created;
    }
    /**
     * Set created value
     * @param string $created
     * @return \StructType\CustomRecord
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->created = $created;
        return $this;
    }
    /**
     * Get lastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->lastModified;
    }
    /**
     * Set lastModified value
     * @param string $lastModified
     * @return \StructType\CustomRecord
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->lastModified = $lastModified;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomRecord
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get autoName value
     * @return bool|null
     */
    public function getAutoName()
    {
        return $this->autoName;
    }
    /**
     * Set autoName value
     * @param bool $autoName
     * @return \StructType\CustomRecord
     */
    public function setAutoName($autoName = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoName) && !is_bool($autoName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoName, true), gettype($autoName)), __LINE__);
        }
        $this->autoName = $autoName;
        return $this;
    }
    /**
     * Get altName value
     * @return string|null
     */
    public function getAltName()
    {
        return $this->altName;
    }
    /**
     * Set altName value
     * @param string $altName
     * @return \StructType\CustomRecord
     */
    public function setAltName($altName = null)
    {
        // validation for constraint: string
        if (!is_null($altName) && !is_string($altName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altName, true), gettype($altName)), __LINE__);
        }
        $this->altName = $altName;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\CustomRecord
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get recType value
     * @return \StructType\RecordRef|null
     */
    public function getRecType()
    {
        return $this->recType;
    }
    /**
     * Set recType value
     * @param \StructType\RecordRef $recType
     * @return \StructType\CustomRecord
     */
    public function setRecType(\StructType\RecordRef $recType = null)
    {
        $this->recType = $recType;
        return $this;
    }
    /**
     * Get enableNumbering value
     * @return bool|null
     */
    public function getEnableNumbering()
    {
        return $this->enableNumbering;
    }
    /**
     * Set enableNumbering value
     * @param bool $enableNumbering
     * @return \StructType\CustomRecord
     */
    public function setEnableNumbering($enableNumbering = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableNumbering) && !is_bool($enableNumbering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableNumbering, true), gettype($enableNumbering)), __LINE__);
        }
        $this->enableNumbering = $enableNumbering;
        return $this;
    }
    /**
     * Get numberingPrefix value
     * @return string|null
     */
    public function getNumberingPrefix()
    {
        return $this->numberingPrefix;
    }
    /**
     * Set numberingPrefix value
     * @param string $numberingPrefix
     * @return \StructType\CustomRecord
     */
    public function setNumberingPrefix($numberingPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($numberingPrefix) && !is_string($numberingPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberingPrefix, true), gettype($numberingPrefix)), __LINE__);
        }
        $this->numberingPrefix = $numberingPrefix;
        return $this;
    }
    /**
     * Get numberingSuffix value
     * @return string|null
     */
    public function getNumberingSuffix()
    {
        return $this->numberingSuffix;
    }
    /**
     * Set numberingSuffix value
     * @param string $numberingSuffix
     * @return \StructType\CustomRecord
     */
    public function setNumberingSuffix($numberingSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($numberingSuffix) && !is_string($numberingSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberingSuffix, true), gettype($numberingSuffix)), __LINE__);
        }
        $this->numberingSuffix = $numberingSuffix;
        return $this;
    }
    /**
     * Get numberingMinDigits value
     * @return int|null
     */
    public function getNumberingMinDigits()
    {
        return $this->numberingMinDigits;
    }
    /**
     * Set numberingMinDigits value
     * @param int $numberingMinDigits
     * @return \StructType\CustomRecord
     */
    public function setNumberingMinDigits($numberingMinDigits = null)
    {
        // validation for constraint: int
        if (!is_null($numberingMinDigits) && !(is_int($numberingMinDigits) || ctype_digit($numberingMinDigits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberingMinDigits, true), gettype($numberingMinDigits)), __LINE__);
        }
        $this->numberingMinDigits = $numberingMinDigits;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomRecord
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberingInit value
     * @return int|null
     */
    public function getNumberingInit()
    {
        return $this->numberingInit;
    }
    /**
     * Set numberingInit value
     * @param int $numberingInit
     * @return \StructType\CustomRecord
     */
    public function setNumberingInit($numberingInit = null)
    {
        // validation for constraint: int
        if (!is_null($numberingInit) && !(is_int($numberingInit) || ctype_digit($numberingInit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberingInit, true), gettype($numberingInit)), __LINE__);
        }
        $this->numberingInit = $numberingInit;
        return $this;
    }
    /**
     * Get numberingCurrentNumber value
     * @return int|null
     */
    public function getNumberingCurrentNumber()
    {
        return $this->numberingCurrentNumber;
    }
    /**
     * Set numberingCurrentNumber value
     * @param int $numberingCurrentNumber
     * @return \StructType\CustomRecord
     */
    public function setNumberingCurrentNumber($numberingCurrentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($numberingCurrentNumber) && !(is_int($numberingCurrentNumber) || ctype_digit($numberingCurrentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberingCurrentNumber, true), gettype($numberingCurrentNumber)), __LINE__);
        }
        $this->numberingCurrentNumber = $numberingCurrentNumber;
        return $this;
    }
    /**
     * Get allowNumberingOverride value
     * @return bool|null
     */
    public function getAllowNumberingOverride()
    {
        return $this->allowNumberingOverride;
    }
    /**
     * Set allowNumberingOverride value
     * @param bool $allowNumberingOverride
     * @return \StructType\CustomRecord
     */
    public function setAllowNumberingOverride($allowNumberingOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNumberingOverride) && !is_bool($allowNumberingOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNumberingOverride, true), gettype($allowNumberingOverride)), __LINE__);
        }
        $this->allowNumberingOverride = $allowNumberingOverride;
        return $this;
    }
    /**
     * Get isNumberingUpdateable value
     * @return bool|null
     */
    public function getIsNumberingUpdateable()
    {
        return $this->isNumberingUpdateable;
    }
    /**
     * Set isNumberingUpdateable value
     * @param bool $isNumberingUpdateable
     * @return \StructType\CustomRecord
     */
    public function setIsNumberingUpdateable($isNumberingUpdateable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNumberingUpdateable) && !is_bool($isNumberingUpdateable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNumberingUpdateable, true), gettype($isNumberingUpdateable)), __LINE__);
        }
        $this->isNumberingUpdateable = $isNumberingUpdateable;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\CustomRecordTranslationsList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\CustomRecordTranslationsList $translationsList
     * @return \StructType\CustomRecord
     */
    public function setTranslationsList(\StructType\CustomRecordTranslationsList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get includeName value
     * @return bool|null
     */
    public function getIncludeName()
    {
        return $this->includeName;
    }
    /**
     * Set includeName value
     * @param bool $includeName
     * @return \StructType\CustomRecord
     */
    public function setIncludeName($includeName = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeName) && !is_bool($includeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeName, true), gettype($includeName)), __LINE__);
        }
        $this->includeName = $includeName;
        return $this;
    }
    /**
     * Get showId value
     * @return bool|null
     */
    public function getShowId()
    {
        return $this->showId;
    }
    /**
     * Set showId value
     * @param bool $showId
     * @return \StructType\CustomRecord
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: boolean
        if (!is_null($showId) && !is_bool($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        $this->showId = $showId;
        return $this;
    }
    /**
     * Get showCreationDate value
     * @return bool|null
     */
    public function getShowCreationDate()
    {
        return $this->showCreationDate;
    }
    /**
     * Set showCreationDate value
     * @param bool $showCreationDate
     * @return \StructType\CustomRecord
     */
    public function setShowCreationDate($showCreationDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCreationDate) && !is_bool($showCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCreationDate, true), gettype($showCreationDate)), __LINE__);
        }
        $this->showCreationDate = $showCreationDate;
        return $this;
    }
    /**
     * Get showCreationDateOnList value
     * @return bool|null
     */
    public function getShowCreationDateOnList()
    {
        return $this->showCreationDateOnList;
    }
    /**
     * Set showCreationDateOnList value
     * @param bool $showCreationDateOnList
     * @return \StructType\CustomRecord
     */
    public function setShowCreationDateOnList($showCreationDateOnList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCreationDateOnList) && !is_bool($showCreationDateOnList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCreationDateOnList, true), gettype($showCreationDateOnList)), __LINE__);
        }
        $this->showCreationDateOnList = $showCreationDateOnList;
        return $this;
    }
    /**
     * Get showLastModified value
     * @return bool|null
     */
    public function getShowLastModified()
    {
        return $this->showLastModified;
    }
    /**
     * Set showLastModified value
     * @param bool $showLastModified
     * @return \StructType\CustomRecord
     */
    public function setShowLastModified($showLastModified = null)
    {
        // validation for constraint: boolean
        if (!is_null($showLastModified) && !is_bool($showLastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showLastModified, true), gettype($showLastModified)), __LINE__);
        }
        $this->showLastModified = $showLastModified;
        return $this;
    }
    /**
     * Get showLastModifiedOnList value
     * @return bool|null
     */
    public function getShowLastModifiedOnList()
    {
        return $this->showLastModifiedOnList;
    }
    /**
     * Set showLastModifiedOnList value
     * @param bool $showLastModifiedOnList
     * @return \StructType\CustomRecord
     */
    public function setShowLastModifiedOnList($showLastModifiedOnList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showLastModifiedOnList) && !is_bool($showLastModifiedOnList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showLastModifiedOnList, true), gettype($showLastModifiedOnList)), __LINE__);
        }
        $this->showLastModifiedOnList = $showLastModifiedOnList;
        return $this;
    }
    /**
     * Get showOwner value
     * @return bool|null
     */
    public function getShowOwner()
    {
        return $this->showOwner;
    }
    /**
     * Set showOwner value
     * @param bool $showOwner
     * @return \StructType\CustomRecord
     */
    public function setShowOwner($showOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOwner) && !is_bool($showOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOwner, true), gettype($showOwner)), __LINE__);
        }
        $this->showOwner = $showOwner;
        return $this;
    }
    /**
     * Get showOwnerOnList value
     * @return bool|null
     */
    public function getShowOwnerOnList()
    {
        return $this->showOwnerOnList;
    }
    /**
     * Set showOwnerOnList value
     * @param bool $showOwnerOnList
     * @return \StructType\CustomRecord
     */
    public function setShowOwnerOnList($showOwnerOnList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOwnerOnList) && !is_bool($showOwnerOnList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOwnerOnList, true), gettype($showOwnerOnList)), __LINE__);
        }
        $this->showOwnerOnList = $showOwnerOnList;
        return $this;
    }
    /**
     * Get showOwnerAllowChange value
     * @return bool|null
     */
    public function getShowOwnerAllowChange()
    {
        return $this->showOwnerAllowChange;
    }
    /**
     * Set showOwnerAllowChange value
     * @param bool $showOwnerAllowChange
     * @return \StructType\CustomRecord
     */
    public function setShowOwnerAllowChange($showOwnerAllowChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOwnerAllowChange) && !is_bool($showOwnerAllowChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOwnerAllowChange, true), gettype($showOwnerAllowChange)), __LINE__);
        }
        $this->showOwnerAllowChange = $showOwnerAllowChange;
        return $this;
    }
    /**
     * Get usePermissions value
     * @return bool|null
     */
    public function getUsePermissions()
    {
        return $this->usePermissions;
    }
    /**
     * Set usePermissions value
     * @param bool $usePermissions
     * @return \StructType\CustomRecord
     */
    public function setUsePermissions($usePermissions = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePermissions) && !is_bool($usePermissions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePermissions, true), gettype($usePermissions)), __LINE__);
        }
        $this->usePermissions = $usePermissions;
        return $this;
    }
    /**
     * Get allowAttachments value
     * @return bool|null
     */
    public function getAllowAttachments()
    {
        return $this->allowAttachments;
    }
    /**
     * Set allowAttachments value
     * @param bool $allowAttachments
     * @return \StructType\CustomRecord
     */
    public function setAllowAttachments($allowAttachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAttachments) && !is_bool($allowAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowAttachments, true), gettype($allowAttachments)), __LINE__);
        }
        $this->allowAttachments = $allowAttachments;
        return $this;
    }
    /**
     * Get showNotes value
     * @return bool|null
     */
    public function getShowNotes()
    {
        return $this->showNotes;
    }
    /**
     * Set showNotes value
     * @param bool $showNotes
     * @return \StructType\CustomRecord
     */
    public function setShowNotes($showNotes = null)
    {
        // validation for constraint: boolean
        if (!is_null($showNotes) && !is_bool($showNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showNotes, true), gettype($showNotes)), __LINE__);
        }
        $this->showNotes = $showNotes;
        return $this;
    }
    /**
     * Get enablEmailMerge value
     * @return bool|null
     */
    public function getEnablEmailMerge()
    {
        return $this->enablEmailMerge;
    }
    /**
     * Set enablEmailMerge value
     * @param bool $enablEmailMerge
     * @return \StructType\CustomRecord
     */
    public function setEnablEmailMerge($enablEmailMerge = null)
    {
        // validation for constraint: boolean
        if (!is_null($enablEmailMerge) && !is_bool($enablEmailMerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enablEmailMerge, true), gettype($enablEmailMerge)), __LINE__);
        }
        $this->enablEmailMerge = $enablEmailMerge;
        return $this;
    }
    /**
     * Get isOrdered value
     * @return bool|null
     */
    public function getIsOrdered()
    {
        return $this->isOrdered;
    }
    /**
     * Set isOrdered value
     * @param bool $isOrdered
     * @return \StructType\CustomRecord
     */
    public function setIsOrdered($isOrdered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOrdered) && !is_bool($isOrdered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOrdered, true), gettype($isOrdered)), __LINE__);
        }
        $this->isOrdered = $isOrdered;
        return $this;
    }
    /**
     * Get allowInlineEditing value
     * @return bool|null
     */
    public function getAllowInlineEditing()
    {
        return $this->allowInlineEditing;
    }
    /**
     * Set allowInlineEditing value
     * @param bool $allowInlineEditing
     * @return \StructType\CustomRecord
     */
    public function setAllowInlineEditing($allowInlineEditing = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowInlineEditing) && !is_bool($allowInlineEditing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowInlineEditing, true), gettype($allowInlineEditing)), __LINE__);
        }
        $this->allowInlineEditing = $allowInlineEditing;
        return $this;
    }
    /**
     * Get isAvailableOffline value
     * @return bool|null
     */
    public function getIsAvailableOffline()
    {
        return $this->isAvailableOffline;
    }
    /**
     * Set isAvailableOffline value
     * @param bool $isAvailableOffline
     * @return \StructType\CustomRecord
     */
    public function setIsAvailableOffline($isAvailableOffline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableOffline) && !is_bool($isAvailableOffline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableOffline, true), gettype($isAvailableOffline)), __LINE__);
        }
        $this->isAvailableOffline = $isAvailableOffline;
        return $this;
    }
    /**
     * Get allowQuickSearch value
     * @return bool|null
     */
    public function getAllowQuickSearch()
    {
        return $this->allowQuickSearch;
    }
    /**
     * Set allowQuickSearch value
     * @param bool $allowQuickSearch
     * @return \StructType\CustomRecord
     */
    public function setAllowQuickSearch($allowQuickSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowQuickSearch) && !is_bool($allowQuickSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowQuickSearch, true), gettype($allowQuickSearch)), __LINE__);
        }
        $this->allowQuickSearch = $allowQuickSearch;
        return $this;
    }
    /**
     * Get recordName value
     * @return string|null
     */
    public function getRecordName()
    {
        return $this->recordName;
    }
    /**
     * Set recordName value
     * @param string $recordName
     * @return \StructType\CustomRecord
     */
    public function setRecordName($recordName = null)
    {
        // validation for constraint: string
        if (!is_null($recordName) && !is_string($recordName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordName, true), gettype($recordName)), __LINE__);
        }
        $this->recordName = $recordName;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\CustomRecord
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomRecord
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomRecord
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CustomRecord
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
