<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomPurchaseExpense StructType
 * @subpackage Structs
 */
class CustomPurchaseExpense extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The projectTask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $projectTask;
    /**
     * The amortizationSched
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationSched;
    /**
     * The amortizStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizStartDate;
    /**
     * The amortizationEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationEndDate;
    /**
     * The amortizationResidual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationResidual;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for CustomPurchaseExpense
     * @uses CustomPurchaseExpense::setLine()
     * @uses CustomPurchaseExpense::setCategory()
     * @uses CustomPurchaseExpense::setAccount()
     * @uses CustomPurchaseExpense::setAmount()
     * @uses CustomPurchaseExpense::setTaxAmount()
     * @uses CustomPurchaseExpense::setMemo()
     * @uses CustomPurchaseExpense::setGrossAmt()
     * @uses CustomPurchaseExpense::setTaxDetailsReference()
     * @uses CustomPurchaseExpense::setDepartment()
     * @uses CustomPurchaseExpense::setClass()
     * @uses CustomPurchaseExpense::setLocation()
     * @uses CustomPurchaseExpense::setCustomer()
     * @uses CustomPurchaseExpense::setIsBillable()
     * @uses CustomPurchaseExpense::setProjectTask()
     * @uses CustomPurchaseExpense::setAmortizationSched()
     * @uses CustomPurchaseExpense::setAmortizStartDate()
     * @uses CustomPurchaseExpense::setAmortizationEndDate()
     * @uses CustomPurchaseExpense::setAmortizationResidual()
     * @uses CustomPurchaseExpense::setCustomFieldList()
     * @param int $line
     * @param \StructType\RecordRef $category
     * @param \StructType\RecordRef $account
     * @param float $amount
     * @param float $taxAmount
     * @param string $memo
     * @param float $grossAmt
     * @param string $taxDetailsReference
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param \StructType\RecordRef $projectTask
     * @param \StructType\RecordRef $amortizationSched
     * @param string $amortizStartDate
     * @param string $amortizationEndDate
     * @param string $amortizationResidual
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($line = null, \StructType\RecordRef $category = null, \StructType\RecordRef $account = null, $amount = null, $taxAmount = null, $memo = null, $grossAmt = null, $taxDetailsReference = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $customer = null, $isBillable = null, \StructType\RecordRef $projectTask = null, \StructType\RecordRef $amortizationSched = null, $amortizStartDate = null, $amortizationEndDate = null, $amortizationResidual = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setLine($line)
            ->setCategory($category)
            ->setAccount($account)
            ->setAmount($amount)
            ->setTaxAmount($taxAmount)
            ->setMemo($memo)
            ->setGrossAmt($grossAmt)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setProjectTask($projectTask)
            ->setAmortizationSched($amortizationSched)
            ->setAmortizStartDate($amortizStartDate)
            ->setAmortizationEndDate($amortizationEndDate)
            ->setAmortizationResidual($amortizationResidual)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\CustomPurchaseExpense
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\CustomPurchaseExpense
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\CustomPurchaseExpense
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CustomPurchaseExpense
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\CustomPurchaseExpense
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\CustomPurchaseExpense
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\CustomPurchaseExpense
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\CustomPurchaseExpense
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CustomPurchaseExpense
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CustomPurchaseExpense
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CustomPurchaseExpense
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\CustomPurchaseExpense
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\CustomPurchaseExpense
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get projectTask value
     * @return \StructType\RecordRef|null
     */
    public function getProjectTask()
    {
        return $this->projectTask;
    }
    /**
     * Set projectTask value
     * @param \StructType\RecordRef $projectTask
     * @return \StructType\CustomPurchaseExpense
     */
    public function setProjectTask(\StructType\RecordRef $projectTask = null)
    {
        $this->projectTask = $projectTask;
        return $this;
    }
    /**
     * Get amortizationSched value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationSched()
    {
        return $this->amortizationSched;
    }
    /**
     * Set amortizationSched value
     * @param \StructType\RecordRef $amortizationSched
     * @return \StructType\CustomPurchaseExpense
     */
    public function setAmortizationSched(\StructType\RecordRef $amortizationSched = null)
    {
        $this->amortizationSched = $amortizationSched;
        return $this;
    }
    /**
     * Get amortizStartDate value
     * @return string|null
     */
    public function getAmortizStartDate()
    {
        return $this->amortizStartDate;
    }
    /**
     * Set amortizStartDate value
     * @param string $amortizStartDate
     * @return \StructType\CustomPurchaseExpense
     */
    public function setAmortizStartDate($amortizStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizStartDate) && !is_string($amortizStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizStartDate, true), gettype($amortizStartDate)), __LINE__);
        }
        $this->amortizStartDate = $amortizStartDate;
        return $this;
    }
    /**
     * Get amortizationEndDate value
     * @return string|null
     */
    public function getAmortizationEndDate()
    {
        return $this->amortizationEndDate;
    }
    /**
     * Set amortizationEndDate value
     * @param string $amortizationEndDate
     * @return \StructType\CustomPurchaseExpense
     */
    public function setAmortizationEndDate($amortizationEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationEndDate) && !is_string($amortizationEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationEndDate, true), gettype($amortizationEndDate)), __LINE__);
        }
        $this->amortizationEndDate = $amortizationEndDate;
        return $this;
    }
    /**
     * Get amortizationResidual value
     * @return string|null
     */
    public function getAmortizationResidual()
    {
        return $this->amortizationResidual;
    }
    /**
     * Set amortizationResidual value
     * @param string $amortizationResidual
     * @return \StructType\CustomPurchaseExpense
     */
    public function setAmortizationResidual($amortizationResidual = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationResidual) && !is_string($amortizationResidual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationResidual, true), gettype($amortizationResidual)), __LINE__);
        }
        $this->amortizationResidual = $amortizationResidual;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomPurchaseExpense
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
