<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomListCustomValueList StructType
 * @subpackage Structs
 */
class CustomListCustomValueList extends AbstractStructBase
{
    /**
     * The customValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomListCustomValue[]
     */
    public $customValue;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomListCustomValueList
     * @uses CustomListCustomValueList::setCustomValue()
     * @uses CustomListCustomValueList::setReplaceAll()
     * @param \StructType\CustomListCustomValue[] $customValue
     * @param bool $replaceAll
     */
    public function __construct(array $customValue = array(), $replaceAll = true)
    {
        $this
            ->setCustomValue($customValue)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get customValue value
     * @return \StructType\CustomListCustomValue[]|null
     */
    public function getCustomValue()
    {
        return $this->customValue;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomValueForArrayConstraintsFromSetCustomValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customListCustomValueListCustomValueItem) {
            // validation for constraint: itemType
            if (!$customListCustomValueListCustomValueItem instanceof \StructType\CustomListCustomValue) {
                $invalidValues[] = is_object($customListCustomValueListCustomValueItem) ? get_class($customListCustomValueListCustomValueItem) : sprintf('%s(%s)', gettype($customListCustomValueListCustomValueItem), var_export($customListCustomValueListCustomValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customValue property can only contain items of type \StructType\CustomListCustomValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customValue value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomListCustomValue[] $customValue
     * @return \StructType\CustomListCustomValueList
     */
    public function setCustomValue(array $customValue = array())
    {
        // validation for constraint: array
        if ('' !== ($customValueArrayErrorMessage = self::validateCustomValueForArrayConstraintsFromSetCustomValue($customValue))) {
            throw new \InvalidArgumentException($customValueArrayErrorMessage, __LINE__);
        }
        $this->customValue = $customValue;
        return $this;
    }
    /**
     * Add item to customValue value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomListCustomValue $item
     * @return \StructType\CustomListCustomValueList
     */
    public function addToCustomValue(\StructType\CustomListCustomValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomListCustomValue) {
            throw new \InvalidArgumentException(sprintf('The customValue property can only contain items of type \StructType\CustomListCustomValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customValue[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomListCustomValueList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
