<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomListCustomValue StructType
 * @subpackage Structs
 */
class CustomListCustomValue extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The abbreviation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $abbreviation;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The valueId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $valueId;
    /**
     * The valueLanguageValueList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LanguageValueList
     */
    public $valueLanguageValueList;
    /**
     * Constructor method for CustomListCustomValue
     * @uses CustomListCustomValue::setValue()
     * @uses CustomListCustomValue::setAbbreviation()
     * @uses CustomListCustomValue::setIsInactive()
     * @uses CustomListCustomValue::setValueId()
     * @uses CustomListCustomValue::setValueLanguageValueList()
     * @param string $value
     * @param string $abbreviation
     * @param bool $isInactive
     * @param int $valueId
     * @param \StructType\LanguageValueList $valueLanguageValueList
     */
    public function __construct($value = null, $abbreviation = null, $isInactive = null, $valueId = null, \StructType\LanguageValueList $valueLanguageValueList = null)
    {
        $this
            ->setValue($value)
            ->setAbbreviation($abbreviation)
            ->setIsInactive($isInactive)
            ->setValueId($valueId)
            ->setValueLanguageValueList($valueLanguageValueList);
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\CustomListCustomValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get abbreviation value
     * @return string|null
     */
    public function getAbbreviation()
    {
        return $this->abbreviation;
    }
    /**
     * Set abbreviation value
     * @param string $abbreviation
     * @return \StructType\CustomListCustomValue
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abbreviation, true), gettype($abbreviation)), __LINE__);
        }
        $this->abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\CustomListCustomValue
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get valueId value
     * @return int|null
     */
    public function getValueId()
    {
        return $this->valueId;
    }
    /**
     * Set valueId value
     * @param int $valueId
     * @return \StructType\CustomListCustomValue
     */
    public function setValueId($valueId = null)
    {
        // validation for constraint: int
        if (!is_null($valueId) && !(is_int($valueId) || ctype_digit($valueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valueId, true), gettype($valueId)), __LINE__);
        }
        $this->valueId = $valueId;
        return $this;
    }
    /**
     * Get valueLanguageValueList value
     * @return \StructType\LanguageValueList|null
     */
    public function getValueLanguageValueList()
    {
        return $this->valueLanguageValueList;
    }
    /**
     * Set valueLanguageValueList value
     * @param \StructType\LanguageValueList $valueLanguageValueList
     * @return \StructType\CustomListCustomValue
     */
    public function setValueLanguageValueList(\StructType\LanguageValueList $valueLanguageValueList = null)
    {
        $this->valueLanguageValueList = $valueLanguageValueList;
        return $this;
    }
}
