<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomList StructType
 * Meta information extracted from the WSDL
 * - type: setupCustom:CustomList
 * @subpackage Structs
 */
class CustomList extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The isOrdered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOrdered;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isMatrixOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isMatrixOption;
    /**
     * The scriptId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scriptId;
    /**
     * The convertToCustomRecord
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $convertToCustomRecord;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The customValueList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomListCustomValueList
     */
    public $customValueList;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomListTranslationsList
     */
    public $translationsList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for CustomList
     * @uses CustomList::setName()
     * @uses CustomList::setOwner()
     * @uses CustomList::setIsOrdered()
     * @uses CustomList::setDescription()
     * @uses CustomList::setIsMatrixOption()
     * @uses CustomList::setScriptId()
     * @uses CustomList::setConvertToCustomRecord()
     * @uses CustomList::setIsInactive()
     * @uses CustomList::setCustomValueList()
     * @uses CustomList::setTranslationsList()
     * @uses CustomList::setInternalId()
     * @param string $name
     * @param \StructType\RecordRef $owner
     * @param bool $isOrdered
     * @param string $description
     * @param bool $isMatrixOption
     * @param string $scriptId
     * @param bool $convertToCustomRecord
     * @param bool $isInactive
     * @param \StructType\CustomListCustomValueList $customValueList
     * @param \StructType\CustomListTranslationsList $translationsList
     * @param string $internalId
     */
    public function __construct($name = null, \StructType\RecordRef $owner = null, $isOrdered = null, $description = null, $isMatrixOption = null, $scriptId = null, $convertToCustomRecord = null, $isInactive = null, \StructType\CustomListCustomValueList $customValueList = null, \StructType\CustomListTranslationsList $translationsList = null, $internalId = null)
    {
        $this
            ->setName($name)
            ->setOwner($owner)
            ->setIsOrdered($isOrdered)
            ->setDescription($description)
            ->setIsMatrixOption($isMatrixOption)
            ->setScriptId($scriptId)
            ->setConvertToCustomRecord($convertToCustomRecord)
            ->setIsInactive($isInactive)
            ->setCustomValueList($customValueList)
            ->setTranslationsList($translationsList)
            ->setInternalId($internalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\CustomList
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get isOrdered value
     * @return bool|null
     */
    public function getIsOrdered()
    {
        return $this->isOrdered;
    }
    /**
     * Set isOrdered value
     * @param bool $isOrdered
     * @return \StructType\CustomList
     */
    public function setIsOrdered($isOrdered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOrdered) && !is_bool($isOrdered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOrdered, true), gettype($isOrdered)), __LINE__);
        }
        $this->isOrdered = $isOrdered;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CustomList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isMatrixOption value
     * @return bool|null
     */
    public function getIsMatrixOption()
    {
        return $this->isMatrixOption;
    }
    /**
     * Set isMatrixOption value
     * @param bool $isMatrixOption
     * @return \StructType\CustomList
     */
    public function setIsMatrixOption($isMatrixOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMatrixOption) && !is_bool($isMatrixOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMatrixOption, true), gettype($isMatrixOption)), __LINE__);
        }
        $this->isMatrixOption = $isMatrixOption;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\CustomList
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
    /**
     * Get convertToCustomRecord value
     * @return bool|null
     */
    public function getConvertToCustomRecord()
    {
        return $this->convertToCustomRecord;
    }
    /**
     * Set convertToCustomRecord value
     * @param bool $convertToCustomRecord
     * @return \StructType\CustomList
     */
    public function setConvertToCustomRecord($convertToCustomRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($convertToCustomRecord) && !is_bool($convertToCustomRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($convertToCustomRecord, true), gettype($convertToCustomRecord)), __LINE__);
        }
        $this->convertToCustomRecord = $convertToCustomRecord;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\CustomList
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get customValueList value
     * @return \StructType\CustomListCustomValueList|null
     */
    public function getCustomValueList()
    {
        return $this->customValueList;
    }
    /**
     * Set customValueList value
     * @param \StructType\CustomListCustomValueList $customValueList
     * @return \StructType\CustomList
     */
    public function setCustomValueList(\StructType\CustomListCustomValueList $customValueList = null)
    {
        $this->customValueList = $customValueList;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\CustomListTranslationsList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\CustomListTranslationsList $translationsList
     * @return \StructType\CustomList
     */
    public function setTranslationsList(\StructType\CustomListTranslationsList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomList
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
