<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldType StructType
 * @subpackage Structs
 */
abstract class CustomFieldType extends Record
{
    /**
     * The fieldType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fieldType;
    /**
     * The scriptId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scriptId;
    /**
     * Constructor method for CustomFieldType
     * @uses CustomFieldType::setFieldType()
     * @uses CustomFieldType::setScriptId()
     * @param string $fieldType
     * @param string $scriptId
     */
    public function __construct($fieldType = null, $scriptId = null)
    {
        $this
            ->setFieldType($fieldType)
            ->setScriptId($scriptId);
    }
    /**
     * Get fieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->fieldType;
    }
    /**
     * Set fieldType value
     * @uses \EnumType\CustomizationFieldType::valueIsValid()
     * @uses \EnumType\CustomizationFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fieldType
     * @return \StructType\CustomFieldType
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationFieldType::valueIsValid($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationFieldType', is_array($fieldType) ? implode(', ', $fieldType) : var_export($fieldType, true), implode(', ', \EnumType\CustomizationFieldType::getValidValues())), __LINE__);
        }
        $this->fieldType = $fieldType;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\CustomFieldType
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
}
