<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldTranslations StructType
 * @subpackage Structs
 */
class CustomFieldTranslations extends AbstractStructBase
{
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locale;
    /**
     * The localeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localeDescription;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The help
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $help;
    /**
     * Constructor method for CustomFieldTranslations
     * @uses CustomFieldTranslations::setLocale()
     * @uses CustomFieldTranslations::setLocaleDescription()
     * @uses CustomFieldTranslations::setLabel()
     * @uses CustomFieldTranslations::setHelp()
     * @param string $locale
     * @param string $localeDescription
     * @param string $label
     * @param string $help
     */
    public function __construct($locale = null, $localeDescription = null, $label = null, $help = null)
    {
        $this
            ->setLocale($locale)
            ->setLocaleDescription($localeDescription)
            ->setLabel($label)
            ->setHelp($help);
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\CustomFieldTranslations
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($locale) ? implode(', ', $locale) : var_export($locale, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get localeDescription value
     * @return string|null
     */
    public function getLocaleDescription()
    {
        return $this->localeDescription;
    }
    /**
     * Set localeDescription value
     * @param string $localeDescription
     * @return \StructType\CustomFieldTranslations
     */
    public function setLocaleDescription($localeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($localeDescription) && !is_string($localeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localeDescription, true), gettype($localeDescription)), __LINE__);
        }
        $this->localeDescription = $localeDescription;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\CustomFieldTranslations
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get help value
     * @return string|null
     */
    public function getHelp()
    {
        return $this->help;
    }
    /**
     * Set help value
     * @param string $help
     * @return \StructType\CustomFieldTranslations
     */
    public function setHelp($help = null)
    {
        // validation for constraint: string
        if (!is_null($help) && !is_string($help)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($help, true), gettype($help)), __LINE__);
        }
        $this->help = $help;
        return $this;
    }
}
