<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldSubAccessList StructType
 * @subpackage Structs
 */
class CustomFieldSubAccessList extends AbstractStructBase
{
    /**
     * The subAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldSubAccess[]
     */
    public $subAccess;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomFieldSubAccessList
     * @uses CustomFieldSubAccessList::setSubAccess()
     * @uses CustomFieldSubAccessList::setReplaceAll()
     * @param \StructType\CustomFieldSubAccess[] $subAccess
     * @param bool $replaceAll
     */
    public function __construct(array $subAccess = array(), $replaceAll = true)
    {
        $this
            ->setSubAccess($subAccess)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get subAccess value
     * @return \StructType\CustomFieldSubAccess[]|null
     */
    public function getSubAccess()
    {
        return $this->subAccess;
    }
    /**
     * This method is responsible for validating the values passed to the setSubAccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubAccess method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubAccessForArrayConstraintsFromSetSubAccess(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customFieldSubAccessListSubAccessItem) {
            // validation for constraint: itemType
            if (!$customFieldSubAccessListSubAccessItem instanceof \StructType\CustomFieldSubAccess) {
                $invalidValues[] = is_object($customFieldSubAccessListSubAccessItem) ? get_class($customFieldSubAccessListSubAccessItem) : sprintf('%s(%s)', gettype($customFieldSubAccessListSubAccessItem), var_export($customFieldSubAccessListSubAccessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subAccess property can only contain items of type \StructType\CustomFieldSubAccess, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subAccess value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldSubAccess[] $subAccess
     * @return \StructType\CustomFieldSubAccessList
     */
    public function setSubAccess(array $subAccess = array())
    {
        // validation for constraint: array
        if ('' !== ($subAccessArrayErrorMessage = self::validateSubAccessForArrayConstraintsFromSetSubAccess($subAccess))) {
            throw new \InvalidArgumentException($subAccessArrayErrorMessage, __LINE__);
        }
        $this->subAccess = $subAccess;
        return $this;
    }
    /**
     * Add item to subAccess value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldSubAccess $item
     * @return \StructType\CustomFieldSubAccessList
     */
    public function addToSubAccess(\StructType\CustomFieldSubAccess $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldSubAccess) {
            throw new \InvalidArgumentException(sprintf('The subAccess property can only contain items of type \StructType\CustomFieldSubAccess, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subAccess[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomFieldSubAccessList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
