<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldSubAccess StructType
 * @subpackage Structs
 */
class CustomFieldSubAccess extends AbstractStructBase
{
    /**
     * The sub
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sub;
    /**
     * The accessLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessLevel;
    /**
     * The searchLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchLevel;
    /**
     * Constructor method for CustomFieldSubAccess
     * @uses CustomFieldSubAccess::setSub()
     * @uses CustomFieldSubAccess::setAccessLevel()
     * @uses CustomFieldSubAccess::setSearchLevel()
     * @param \StructType\RecordRef $sub
     * @param string $accessLevel
     * @param string $searchLevel
     */
    public function __construct(\StructType\RecordRef $sub = null, $accessLevel = null, $searchLevel = null)
    {
        $this
            ->setSub($sub)
            ->setAccessLevel($accessLevel)
            ->setSearchLevel($searchLevel);
    }
    /**
     * Get sub value
     * @return \StructType\RecordRef|null
     */
    public function getSub()
    {
        return $this->sub;
    }
    /**
     * Set sub value
     * @param \StructType\RecordRef $sub
     * @return \StructType\CustomFieldSubAccess
     */
    public function setSub(\StructType\RecordRef $sub = null)
    {
        $this->sub = $sub;
        return $this;
    }
    /**
     * Get accessLevel value
     * @return string|null
     */
    public function getAccessLevel()
    {
        return $this->accessLevel;
    }
    /**
     * Set accessLevel value
     * @uses \EnumType\CustomizationAccessLevel::valueIsValid()
     * @uses \EnumType\CustomizationAccessLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessLevel
     * @return \StructType\CustomFieldSubAccess
     */
    public function setAccessLevel($accessLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationAccessLevel::valueIsValid($accessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationAccessLevel', is_array($accessLevel) ? implode(', ', $accessLevel) : var_export($accessLevel, true), implode(', ', \EnumType\CustomizationAccessLevel::getValidValues())), __LINE__);
        }
        $this->accessLevel = $accessLevel;
        return $this;
    }
    /**
     * Get searchLevel value
     * @return string|null
     */
    public function getSearchLevel()
    {
        return $this->searchLevel;
    }
    /**
     * Set searchLevel value
     * @uses \EnumType\CustomizationSearchLevel::valueIsValid()
     * @uses \EnumType\CustomizationSearchLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchLevel
     * @return \StructType\CustomFieldSubAccess
     */
    public function setSearchLevel($searchLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationSearchLevel::valueIsValid($searchLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationSearchLevel', is_array($searchLevel) ? implode(', ', $searchLevel) : var_export($searchLevel, true), implode(', ', \EnumType\CustomizationSearchLevel::getValidValues())), __LINE__);
        }
        $this->searchLevel = $searchLevel;
        return $this;
    }
}
