<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldRoleAccessList StructType
 * @subpackage Structs
 */
class CustomFieldRoleAccessList extends AbstractStructBase
{
    /**
     * The roleAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldRoleAccess[]
     */
    public $roleAccess;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomFieldRoleAccessList
     * @uses CustomFieldRoleAccessList::setRoleAccess()
     * @uses CustomFieldRoleAccessList::setReplaceAll()
     * @param \StructType\CustomFieldRoleAccess[] $roleAccess
     * @param bool $replaceAll
     */
    public function __construct(array $roleAccess = array(), $replaceAll = true)
    {
        $this
            ->setRoleAccess($roleAccess)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get roleAccess value
     * @return \StructType\CustomFieldRoleAccess[]|null
     */
    public function getRoleAccess()
    {
        return $this->roleAccess;
    }
    /**
     * This method is responsible for validating the values passed to the setRoleAccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoleAccess method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoleAccessForArrayConstraintsFromSetRoleAccess(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customFieldRoleAccessListRoleAccessItem) {
            // validation for constraint: itemType
            if (!$customFieldRoleAccessListRoleAccessItem instanceof \StructType\CustomFieldRoleAccess) {
                $invalidValues[] = is_object($customFieldRoleAccessListRoleAccessItem) ? get_class($customFieldRoleAccessListRoleAccessItem) : sprintf('%s(%s)', gettype($customFieldRoleAccessListRoleAccessItem), var_export($customFieldRoleAccessListRoleAccessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The roleAccess property can only contain items of type \StructType\CustomFieldRoleAccess, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set roleAccess value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldRoleAccess[] $roleAccess
     * @return \StructType\CustomFieldRoleAccessList
     */
    public function setRoleAccess(array $roleAccess = array())
    {
        // validation for constraint: array
        if ('' !== ($roleAccessArrayErrorMessage = self::validateRoleAccessForArrayConstraintsFromSetRoleAccess($roleAccess))) {
            throw new \InvalidArgumentException($roleAccessArrayErrorMessage, __LINE__);
        }
        $this->roleAccess = $roleAccess;
        return $this;
    }
    /**
     * Add item to roleAccess value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldRoleAccess $item
     * @return \StructType\CustomFieldRoleAccessList
     */
    public function addToRoleAccess(\StructType\CustomFieldRoleAccess $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldRoleAccess) {
            throw new \InvalidArgumentException(sprintf('The roleAccess property can only contain items of type \StructType\CustomFieldRoleAccess, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->roleAccess[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomFieldRoleAccessList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
