<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldRef StructType
 * @subpackage Structs
 */
abstract class CustomFieldRef extends AbstractStructBase
{
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The scriptId
     * @var string
     */
    public $scriptId;
    /**
     * Constructor method for CustomFieldRef
     * @uses CustomFieldRef::setInternalId()
     * @uses CustomFieldRef::setScriptId()
     * @param string $internalId
     * @param string $scriptId
     */
    public function __construct($internalId = null, $scriptId = null)
    {
        $this
            ->setInternalId($internalId)
            ->setScriptId($scriptId);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomFieldRef
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get scriptId value
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->scriptId;
    }
    /**
     * Set scriptId value
     * @param string $scriptId
     * @return \StructType\CustomFieldRef
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        $this->scriptId = $scriptId;
        return $this;
    }
}
