<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldDepartmentAccess StructType
 * @subpackage Structs
 */
class CustomFieldDepartmentAccess extends AbstractStructBase
{
    /**
     * The dept
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $dept;
    /**
     * The accessLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessLevel;
    /**
     * The searchLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchLevel;
    /**
     * Constructor method for CustomFieldDepartmentAccess
     * @uses CustomFieldDepartmentAccess::setDept()
     * @uses CustomFieldDepartmentAccess::setAccessLevel()
     * @uses CustomFieldDepartmentAccess::setSearchLevel()
     * @param \StructType\RecordRef $dept
     * @param string $accessLevel
     * @param string $searchLevel
     */
    public function __construct(\StructType\RecordRef $dept = null, $accessLevel = null, $searchLevel = null)
    {
        $this
            ->setDept($dept)
            ->setAccessLevel($accessLevel)
            ->setSearchLevel($searchLevel);
    }
    /**
     * Get dept value
     * @return \StructType\RecordRef|null
     */
    public function getDept()
    {
        return $this->dept;
    }
    /**
     * Set dept value
     * @param \StructType\RecordRef $dept
     * @return \StructType\CustomFieldDepartmentAccess
     */
    public function setDept(\StructType\RecordRef $dept = null)
    {
        $this->dept = $dept;
        return $this;
    }
    /**
     * Get accessLevel value
     * @return string|null
     */
    public function getAccessLevel()
    {
        return $this->accessLevel;
    }
    /**
     * Set accessLevel value
     * @uses \EnumType\CustomizationAccessLevel::valueIsValid()
     * @uses \EnumType\CustomizationAccessLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessLevel
     * @return \StructType\CustomFieldDepartmentAccess
     */
    public function setAccessLevel($accessLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationAccessLevel::valueIsValid($accessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationAccessLevel', is_array($accessLevel) ? implode(', ', $accessLevel) : var_export($accessLevel, true), implode(', ', \EnumType\CustomizationAccessLevel::getValidValues())), __LINE__);
        }
        $this->accessLevel = $accessLevel;
        return $this;
    }
    /**
     * Get searchLevel value
     * @return string|null
     */
    public function getSearchLevel()
    {
        return $this->searchLevel;
    }
    /**
     * Set searchLevel value
     * @uses \EnumType\CustomizationSearchLevel::valueIsValid()
     * @uses \EnumType\CustomizationSearchLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchLevel
     * @return \StructType\CustomFieldDepartmentAccess
     */
    public function setSearchLevel($searchLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomizationSearchLevel::valueIsValid($searchLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomizationSearchLevel', is_array($searchLevel) ? implode(', ', $searchLevel) : var_export($searchLevel, true), implode(', ', \EnumType\CustomizationSearchLevel::getValidValues())), __LINE__);
        }
        $this->searchLevel = $searchLevel;
        return $this;
    }
}
