<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyRateList StructType
 * @subpackage Structs
 */
class CurrencyRateList extends AbstractStructBase
{
    /**
     * The currencyRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyRate[]
     */
    public $currencyRate;
    /**
     * Constructor method for CurrencyRateList
     * @uses CurrencyRateList::setCurrencyRate()
     * @param \StructType\CurrencyRate[] $currencyRate
     */
    public function __construct(array $currencyRate = array())
    {
        $this
            ->setCurrencyRate($currencyRate);
    }
    /**
     * Get currencyRate value
     * @return \StructType\CurrencyRate[]|null
     */
    public function getCurrencyRate()
    {
        return $this->currencyRate;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrencyRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrencyRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyRateForArrayConstraintsFromSetCurrencyRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyRateListCurrencyRateItem) {
            // validation for constraint: itemType
            if (!$currencyRateListCurrencyRateItem instanceof \StructType\CurrencyRate) {
                $invalidValues[] = is_object($currencyRateListCurrencyRateItem) ? get_class($currencyRateListCurrencyRateItem) : sprintf('%s(%s)', gettype($currencyRateListCurrencyRateItem), var_export($currencyRateListCurrencyRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currencyRate property can only contain items of type \StructType\CurrencyRate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currencyRate value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyRate[] $currencyRate
     * @return \StructType\CurrencyRateList
     */
    public function setCurrencyRate(array $currencyRate = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyRateArrayErrorMessage = self::validateCurrencyRateForArrayConstraintsFromSetCurrencyRate($currencyRate))) {
            throw new \InvalidArgumentException($currencyRateArrayErrorMessage, __LINE__);
        }
        $this->currencyRate = $currencyRate;
        return $this;
    }
    /**
     * Add item to currencyRate value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyRate $item
     * @return \StructType\CurrencyRateList
     */
    public function addToCurrencyRate(\StructType\CurrencyRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyRate) {
            throw new \InvalidArgumentException(sprintf('The currencyRate property can only contain items of type \StructType\CurrencyRate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currencyRate[] = $item;
        return $this;
    }
}
