<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyRate StructType
 * @subpackage Structs
 */
class CurrencyRate extends Record
{
    /**
     * The fromCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RecordRef
     */
    public $fromCurrency;
    /**
     * The baseCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $baseCurrency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * The transactionCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transactionCurrency;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for CurrencyRate
     * @uses CurrencyRate::setFromCurrency()
     * @uses CurrencyRate::setBaseCurrency()
     * @uses CurrencyRate::setExchangeRate()
     * @uses CurrencyRate::setEffectiveDate()
     * @uses CurrencyRate::setTransactionCurrency()
     * @uses CurrencyRate::setInternalId()
     * @param \StructType\RecordRef $fromCurrency
     * @param \StructType\RecordRef $baseCurrency
     * @param float $exchangeRate
     * @param string $effectiveDate
     * @param \StructType\RecordRef $transactionCurrency
     * @param string $internalId
     */
    public function __construct(\StructType\RecordRef $fromCurrency = null, \StructType\RecordRef $baseCurrency = null, $exchangeRate = null, $effectiveDate = null, \StructType\RecordRef $transactionCurrency = null, $internalId = null)
    {
        $this
            ->setFromCurrency($fromCurrency)
            ->setBaseCurrency($baseCurrency)
            ->setExchangeRate($exchangeRate)
            ->setEffectiveDate($effectiveDate)
            ->setTransactionCurrency($transactionCurrency)
            ->setInternalId($internalId);
    }
    /**
     * Get fromCurrency value
     * @return \StructType\RecordRef
     */
    public function getFromCurrency()
    {
        return $this->fromCurrency;
    }
    /**
     * Set fromCurrency value
     * @param \StructType\RecordRef $fromCurrency
     * @return \StructType\CurrencyRate
     */
    public function setFromCurrency(\StructType\RecordRef $fromCurrency = null)
    {
        $this->fromCurrency = $fromCurrency;
        return $this;
    }
    /**
     * Get baseCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getBaseCurrency()
    {
        return $this->baseCurrency;
    }
    /**
     * Set baseCurrency value
     * @param \StructType\RecordRef $baseCurrency
     * @return \StructType\CurrencyRate
     */
    public function setBaseCurrency(\StructType\RecordRef $baseCurrency = null)
    {
        $this->baseCurrency = $baseCurrency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CurrencyRate
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\CurrencyRate
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get transactionCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getTransactionCurrency()
    {
        return $this->transactionCurrency;
    }
    /**
     * Set transactionCurrency value
     * @param \StructType\RecordRef $transactionCurrency
     * @return \StructType\CurrencyRate
     */
    public function setTransactionCurrency(\StructType\RecordRef $transactionCurrency = null)
    {
        $this->transactionCurrency = $transactionCurrency;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CurrencyRate
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
