<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditMemo StructType
 * Meta information extracted from the WSDL
 * - type: tranCust:CreditMemo
 * @subpackage Structs
 */
class CreditMemo extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The salesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRep;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $partner;
    /**
     * The contribPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contribPct;
    /**
     * The otherRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $otherRefNum;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The excludeCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $excludeCommission;
    /**
     * The leadSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $leadSource;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The onCreditHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $onCreditHold;
    /**
     * The amountPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountPaid;
    /**
     * The salesEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesEffectiveDate;
    /**
     * The totalCostEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalCostEstimate;
    /**
     * The estGrossProfit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfit;
    /**
     * The estGrossProfitPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estGrossProfitPercent;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $promoCode;
    /**
     * The amountRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountRemaining;
    /**
     * The discountItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $discountItem;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The discountRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountRate;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The taxItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxItem;
    /**
     * The taxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate;
    /**
     * The unapplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unapplied;
    /**
     * The autoApply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoApply;
    /**
     * The applied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $applied;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The toBeEmailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeEmailed;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The toBeFaxed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeFaxed;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The messageSel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $messageSel;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The shippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The shippingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTax1Rate;
    /**
     * The shippingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shippingTaxCode;
    /**
     * The handlingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $handlingTaxCode;
    /**
     * The shippingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingTax2Rate;
    /**
     * The handlingTax1Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTax1Rate;
    /**
     * The handlingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingTax2Rate;
    /**
     * The handlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingCost;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The discountTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountTotal;
    /**
     * The revenueStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revenueStatus;
    /**
     * The recognizedRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $recognizedRevenue;
    /**
     * The deferredRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $deferredRevenue;
    /**
     * The revRecOnRevCommitment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $revRecOnRevCommitment;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The altShippingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altShippingCost;
    /**
     * The altHandlingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $altHandlingCost;
    /**
     * The isMultiShipTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isMultiShipTo;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The salesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesGroup;
    /**
     * The syncSalesTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncSalesTeams;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The giftCert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $giftCert;
    /**
     * The giftCertTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertTotal;
    /**
     * The giftCertApplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertApplied;
    /**
     * The giftCertAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $giftCertAvailable;
    /**
     * The tranIsVsoeBundle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $tranIsVsoeBundle;
    /**
     * The vsoeAutoCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeAutoCalc;
    /**
     * The syncPartnerTeams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $syncPartnerTeams;
    /**
     * The salesTeamList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CreditMemoSalesTeamList
     */
    public $salesTeamList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CreditMemoItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CreditMemoPartnersList
     */
    public $partnersList;
    /**
     * The applyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CreditMemoApplyList
     */
    public $applyList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CreditMemo
     * @uses CreditMemo::setCreatedDate()
     * @uses CreditMemo::setLastModifiedDate()
     * @uses CreditMemo::setNexus()
     * @uses CreditMemo::setSubsidiaryTaxRegNum()
     * @uses CreditMemo::setTaxRegOverride()
     * @uses CreditMemo::setTaxDetailsOverride()
     * @uses CreditMemo::setCustomForm()
     * @uses CreditMemo::setCurrency()
     * @uses CreditMemo::setEntity()
     * @uses CreditMemo::setVatRegNum()
     * @uses CreditMemo::setTranDate()
     * @uses CreditMemo::setTranId()
     * @uses CreditMemo::setEntityTaxRegNum()
     * @uses CreditMemo::setTaxPointDate()
     * @uses CreditMemo::setCreatedFrom()
     * @uses CreditMemo::setPostingPeriod()
     * @uses CreditMemo::setDepartment()
     * @uses CreditMemo::setClass()
     * @uses CreditMemo::setLocation()
     * @uses CreditMemo::setSubsidiary()
     * @uses CreditMemo::setJob()
     * @uses CreditMemo::setSalesRep()
     * @uses CreditMemo::setPartner()
     * @uses CreditMemo::setContribPct()
     * @uses CreditMemo::setOtherRefNum()
     * @uses CreditMemo::setMemo()
     * @uses CreditMemo::setExcludeCommission()
     * @uses CreditMemo::setLeadSource()
     * @uses CreditMemo::setBalance()
     * @uses CreditMemo::setAccount()
     * @uses CreditMemo::setExchangeRate()
     * @uses CreditMemo::setOnCreditHold()
     * @uses CreditMemo::setAmountPaid()
     * @uses CreditMemo::setSalesEffectiveDate()
     * @uses CreditMemo::setTotalCostEstimate()
     * @uses CreditMemo::setEstGrossProfit()
     * @uses CreditMemo::setEstGrossProfitPercent()
     * @uses CreditMemo::setCurrencyName()
     * @uses CreditMemo::setPromoCode()
     * @uses CreditMemo::setAmountRemaining()
     * @uses CreditMemo::setDiscountItem()
     * @uses CreditMemo::setSource()
     * @uses CreditMemo::setDiscountRate()
     * @uses CreditMemo::setIsTaxable()
     * @uses CreditMemo::setTaxItem()
     * @uses CreditMemo::setTaxRate()
     * @uses CreditMemo::setUnapplied()
     * @uses CreditMemo::setAutoApply()
     * @uses CreditMemo::setApplied()
     * @uses CreditMemo::setToBePrinted()
     * @uses CreditMemo::setToBeEmailed()
     * @uses CreditMemo::setEmail()
     * @uses CreditMemo::setToBeFaxed()
     * @uses CreditMemo::setFax()
     * @uses CreditMemo::setMessageSel()
     * @uses CreditMemo::setMessage()
     * @uses CreditMemo::setBillingAddress()
     * @uses CreditMemo::setBillAddressList()
     * @uses CreditMemo::setShipMethod()
     * @uses CreditMemo::setShippingCost()
     * @uses CreditMemo::setShippingTax1Rate()
     * @uses CreditMemo::setShippingTaxCode()
     * @uses CreditMemo::setHandlingTaxCode()
     * @uses CreditMemo::setShippingTax2Rate()
     * @uses CreditMemo::setHandlingTax1Rate()
     * @uses CreditMemo::setHandlingTax2Rate()
     * @uses CreditMemo::setHandlingCost()
     * @uses CreditMemo::setSubTotal()
     * @uses CreditMemo::setDiscountTotal()
     * @uses CreditMemo::setRevenueStatus()
     * @uses CreditMemo::setRecognizedRevenue()
     * @uses CreditMemo::setDeferredRevenue()
     * @uses CreditMemo::setRevRecOnRevCommitment()
     * @uses CreditMemo::setTaxTotal()
     * @uses CreditMemo::setTax2Total()
     * @uses CreditMemo::setAltShippingCost()
     * @uses CreditMemo::setAltHandlingCost()
     * @uses CreditMemo::setIsMultiShipTo()
     * @uses CreditMemo::setTotal()
     * @uses CreditMemo::setSalesGroup()
     * @uses CreditMemo::setSyncSalesTeams()
     * @uses CreditMemo::setStatus()
     * @uses CreditMemo::setGiftCert()
     * @uses CreditMemo::setGiftCertTotal()
     * @uses CreditMemo::setGiftCertApplied()
     * @uses CreditMemo::setGiftCertAvailable()
     * @uses CreditMemo::setTranIsVsoeBundle()
     * @uses CreditMemo::setVsoeAutoCalc()
     * @uses CreditMemo::setSyncPartnerTeams()
     * @uses CreditMemo::setSalesTeamList()
     * @uses CreditMemo::setItemList()
     * @uses CreditMemo::setAccountingBookDetailList()
     * @uses CreditMemo::setPartnersList()
     * @uses CreditMemo::setApplyList()
     * @uses CreditMemo::setTaxDetailsList()
     * @uses CreditMemo::setCustomFieldList()
     * @uses CreditMemo::setInternalId()
     * @uses CreditMemo::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $entity
     * @param string $vatRegNum
     * @param string $tranDate
     * @param string $tranId
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRef $postingPeriod
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $salesRep
     * @param \StructType\RecordRef $partner
     * @param string $contribPct
     * @param string $otherRefNum
     * @param string $memo
     * @param bool $excludeCommission
     * @param \StructType\RecordRef $leadSource
     * @param float $balance
     * @param \StructType\RecordRef $account
     * @param float $exchangeRate
     * @param string $onCreditHold
     * @param float $amountPaid
     * @param string $salesEffectiveDate
     * @param float $totalCostEstimate
     * @param float $estGrossProfit
     * @param float $estGrossProfitPercent
     * @param string $currencyName
     * @param \StructType\RecordRef $promoCode
     * @param float $amountRemaining
     * @param \StructType\RecordRef $discountItem
     * @param string $source
     * @param string $discountRate
     * @param bool $isTaxable
     * @param \StructType\RecordRef $taxItem
     * @param float $taxRate
     * @param float $unapplied
     * @param bool $autoApply
     * @param float $applied
     * @param bool $toBePrinted
     * @param bool $toBeEmailed
     * @param string $email
     * @param bool $toBeFaxed
     * @param string $fax
     * @param \StructType\RecordRef $messageSel
     * @param string $message
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\RecordRef $shipMethod
     * @param float $shippingCost
     * @param float $shippingTax1Rate
     * @param \StructType\RecordRef $shippingTaxCode
     * @param \StructType\RecordRef $handlingTaxCode
     * @param string $shippingTax2Rate
     * @param float $handlingTax1Rate
     * @param string $handlingTax2Rate
     * @param float $handlingCost
     * @param float $subTotal
     * @param float $discountTotal
     * @param string $revenueStatus
     * @param float $recognizedRevenue
     * @param float $deferredRevenue
     * @param bool $revRecOnRevCommitment
     * @param float $taxTotal
     * @param float $tax2Total
     * @param float $altShippingCost
     * @param float $altHandlingCost
     * @param bool $isMultiShipTo
     * @param float $total
     * @param \StructType\RecordRef $salesGroup
     * @param bool $syncSalesTeams
     * @param string $status
     * @param \StructType\RecordRef $giftCert
     * @param float $giftCertTotal
     * @param float $giftCertApplied
     * @param float $giftCertAvailable
     * @param bool $tranIsVsoeBundle
     * @param bool $vsoeAutoCalc
     * @param bool $syncPartnerTeams
     * @param \StructType\CreditMemoSalesTeamList $salesTeamList
     * @param \StructType\CreditMemoItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CreditMemoPartnersList $partnersList
     * @param \StructType\CreditMemoApplyList $applyList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $entity = null, $vatRegNum = null, $tranDate = null, $tranId = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRef $postingPeriod = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $job = null, \StructType\RecordRef $salesRep = null, \StructType\RecordRef $partner = null, $contribPct = null, $otherRefNum = null, $memo = null, $excludeCommission = null, \StructType\RecordRef $leadSource = null, $balance = null, \StructType\RecordRef $account = null, $exchangeRate = null, $onCreditHold = null, $amountPaid = null, $salesEffectiveDate = null, $totalCostEstimate = null, $estGrossProfit = null, $estGrossProfitPercent = null, $currencyName = null, \StructType\RecordRef $promoCode = null, $amountRemaining = null, \StructType\RecordRef $discountItem = null, $source = null, $discountRate = null, $isTaxable = null, \StructType\RecordRef $taxItem = null, $taxRate = null, $unapplied = null, $autoApply = null, $applied = null, $toBePrinted = null, $toBeEmailed = null, $email = null, $toBeFaxed = null, $fax = null, \StructType\RecordRef $messageSel = null, $message = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, \StructType\RecordRef $shipMethod = null, $shippingCost = null, $shippingTax1Rate = null, \StructType\RecordRef $shippingTaxCode = null, \StructType\RecordRef $handlingTaxCode = null, $shippingTax2Rate = null, $handlingTax1Rate = null, $handlingTax2Rate = null, $handlingCost = null, $subTotal = null, $discountTotal = null, $revenueStatus = null, $recognizedRevenue = null, $deferredRevenue = null, $revRecOnRevCommitment = null, $taxTotal = null, $tax2Total = null, $altShippingCost = null, $altHandlingCost = null, $isMultiShipTo = null, $total = null, \StructType\RecordRef $salesGroup = null, $syncSalesTeams = null, $status = null, \StructType\RecordRef $giftCert = null, $giftCertTotal = null, $giftCertApplied = null, $giftCertAvailable = null, $tranIsVsoeBundle = null, $vsoeAutoCalc = null, $syncPartnerTeams = null, \StructType\CreditMemoSalesTeamList $salesTeamList = null, \StructType\CreditMemoItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CreditMemoPartnersList $partnersList = null, \StructType\CreditMemoApplyList $applyList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setCurrency($currency)
            ->setEntity($entity)
            ->setVatRegNum($vatRegNum)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setCreatedFrom($createdFrom)
            ->setPostingPeriod($postingPeriod)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setJob($job)
            ->setSalesRep($salesRep)
            ->setPartner($partner)
            ->setContribPct($contribPct)
            ->setOtherRefNum($otherRefNum)
            ->setMemo($memo)
            ->setExcludeCommission($excludeCommission)
            ->setLeadSource($leadSource)
            ->setBalance($balance)
            ->setAccount($account)
            ->setExchangeRate($exchangeRate)
            ->setOnCreditHold($onCreditHold)
            ->setAmountPaid($amountPaid)
            ->setSalesEffectiveDate($salesEffectiveDate)
            ->setTotalCostEstimate($totalCostEstimate)
            ->setEstGrossProfit($estGrossProfit)
            ->setEstGrossProfitPercent($estGrossProfitPercent)
            ->setCurrencyName($currencyName)
            ->setPromoCode($promoCode)
            ->setAmountRemaining($amountRemaining)
            ->setDiscountItem($discountItem)
            ->setSource($source)
            ->setDiscountRate($discountRate)
            ->setIsTaxable($isTaxable)
            ->setTaxItem($taxItem)
            ->setTaxRate($taxRate)
            ->setUnapplied($unapplied)
            ->setAutoApply($autoApply)
            ->setApplied($applied)
            ->setToBePrinted($toBePrinted)
            ->setToBeEmailed($toBeEmailed)
            ->setEmail($email)
            ->setToBeFaxed($toBeFaxed)
            ->setFax($fax)
            ->setMessageSel($messageSel)
            ->setMessage($message)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setShipMethod($shipMethod)
            ->setShippingCost($shippingCost)
            ->setShippingTax1Rate($shippingTax1Rate)
            ->setShippingTaxCode($shippingTaxCode)
            ->setHandlingTaxCode($handlingTaxCode)
            ->setShippingTax2Rate($shippingTax2Rate)
            ->setHandlingTax1Rate($handlingTax1Rate)
            ->setHandlingTax2Rate($handlingTax2Rate)
            ->setHandlingCost($handlingCost)
            ->setSubTotal($subTotal)
            ->setDiscountTotal($discountTotal)
            ->setRevenueStatus($revenueStatus)
            ->setRecognizedRevenue($recognizedRevenue)
            ->setDeferredRevenue($deferredRevenue)
            ->setRevRecOnRevCommitment($revRecOnRevCommitment)
            ->setTaxTotal($taxTotal)
            ->setTax2Total($tax2Total)
            ->setAltShippingCost($altShippingCost)
            ->setAltHandlingCost($altHandlingCost)
            ->setIsMultiShipTo($isMultiShipTo)
            ->setTotal($total)
            ->setSalesGroup($salesGroup)
            ->setSyncSalesTeams($syncSalesTeams)
            ->setStatus($status)
            ->setGiftCert($giftCert)
            ->setGiftCertTotal($giftCertTotal)
            ->setGiftCertApplied($giftCertApplied)
            ->setGiftCertAvailable($giftCertAvailable)
            ->setTranIsVsoeBundle($tranIsVsoeBundle)
            ->setVsoeAutoCalc($vsoeAutoCalc)
            ->setSyncPartnerTeams($syncPartnerTeams)
            ->setSalesTeamList($salesTeamList)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setPartnersList($partnersList)
            ->setApplyList($applyList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\CreditMemo
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\CreditMemo
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\CreditMemo
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\CreditMemo
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\CreditMemo
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\CreditMemo
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\CreditMemo
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CreditMemo
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\CreditMemo
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\CreditMemo
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\CreditMemo
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\CreditMemo
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\CreditMemo
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\CreditMemo
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\CreditMemo
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\CreditMemo
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CreditMemo
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CreditMemo
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CreditMemo
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\CreditMemo
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\CreditMemo
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get salesRep value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRep()
    {
        return $this->salesRep;
    }
    /**
     * Set salesRep value
     * @param \StructType\RecordRef $salesRep
     * @return \StructType\CreditMemo
     */
    public function setSalesRep(\StructType\RecordRef $salesRep = null)
    {
        $this->salesRep = $salesRep;
        return $this;
    }
    /**
     * Get partner value
     * @return \StructType\RecordRef|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param \StructType\RecordRef $partner
     * @return \StructType\CreditMemo
     */
    public function setPartner(\StructType\RecordRef $partner = null)
    {
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get contribPct value
     * @return string|null
     */
    public function getContribPct()
    {
        return $this->contribPct;
    }
    /**
     * Set contribPct value
     * @param string $contribPct
     * @return \StructType\CreditMemo
     */
    public function setContribPct($contribPct = null)
    {
        // validation for constraint: string
        if (!is_null($contribPct) && !is_string($contribPct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contribPct, true), gettype($contribPct)), __LINE__);
        }
        $this->contribPct = $contribPct;
        return $this;
    }
    /**
     * Get otherRefNum value
     * @return string|null
     */
    public function getOtherRefNum()
    {
        return $this->otherRefNum;
    }
    /**
     * Set otherRefNum value
     * @param string $otherRefNum
     * @return \StructType\CreditMemo
     */
    public function setOtherRefNum($otherRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($otherRefNum) && !is_string($otherRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRefNum, true), gettype($otherRefNum)), __LINE__);
        }
        $this->otherRefNum = $otherRefNum;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\CreditMemo
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get excludeCommission value
     * @return bool|null
     */
    public function getExcludeCommission()
    {
        return $this->excludeCommission;
    }
    /**
     * Set excludeCommission value
     * @param bool $excludeCommission
     * @return \StructType\CreditMemo
     */
    public function setExcludeCommission($excludeCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeCommission) && !is_bool($excludeCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeCommission, true), gettype($excludeCommission)), __LINE__);
        }
        $this->excludeCommission = $excludeCommission;
        return $this;
    }
    /**
     * Get leadSource value
     * @return \StructType\RecordRef|null
     */
    public function getLeadSource()
    {
        return $this->leadSource;
    }
    /**
     * Set leadSource value
     * @param \StructType\RecordRef $leadSource
     * @return \StructType\CreditMemo
     */
    public function setLeadSource(\StructType\RecordRef $leadSource = null)
    {
        $this->leadSource = $leadSource;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\CreditMemo
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\CreditMemo
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CreditMemo
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get onCreditHold value
     * @return string|null
     */
    public function getOnCreditHold()
    {
        return $this->onCreditHold;
    }
    /**
     * Set onCreditHold value
     * @param string $onCreditHold
     * @return \StructType\CreditMemo
     */
    public function setOnCreditHold($onCreditHold = null)
    {
        // validation for constraint: string
        if (!is_null($onCreditHold) && !is_string($onCreditHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onCreditHold, true), gettype($onCreditHold)), __LINE__);
        }
        $this->onCreditHold = $onCreditHold;
        return $this;
    }
    /**
     * Get amountPaid value
     * @return float|null
     */
    public function getAmountPaid()
    {
        return $this->amountPaid;
    }
    /**
     * Set amountPaid value
     * @param float $amountPaid
     * @return \StructType\CreditMemo
     */
    public function setAmountPaid($amountPaid = null)
    {
        // validation for constraint: float
        if (!is_null($amountPaid) && !(is_float($amountPaid) || is_numeric($amountPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountPaid, true), gettype($amountPaid)), __LINE__);
        }
        $this->amountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get salesEffectiveDate value
     * @return string|null
     */
    public function getSalesEffectiveDate()
    {
        return $this->salesEffectiveDate;
    }
    /**
     * Set salesEffectiveDate value
     * @param string $salesEffectiveDate
     * @return \StructType\CreditMemo
     */
    public function setSalesEffectiveDate($salesEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($salesEffectiveDate) && !is_string($salesEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesEffectiveDate, true), gettype($salesEffectiveDate)), __LINE__);
        }
        $this->salesEffectiveDate = $salesEffectiveDate;
        return $this;
    }
    /**
     * Get totalCostEstimate value
     * @return float|null
     */
    public function getTotalCostEstimate()
    {
        return $this->totalCostEstimate;
    }
    /**
     * Set totalCostEstimate value
     * @param float $totalCostEstimate
     * @return \StructType\CreditMemo
     */
    public function setTotalCostEstimate($totalCostEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($totalCostEstimate) && !(is_float($totalCostEstimate) || is_numeric($totalCostEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCostEstimate, true), gettype($totalCostEstimate)), __LINE__);
        }
        $this->totalCostEstimate = $totalCostEstimate;
        return $this;
    }
    /**
     * Get estGrossProfit value
     * @return float|null
     */
    public function getEstGrossProfit()
    {
        return $this->estGrossProfit;
    }
    /**
     * Set estGrossProfit value
     * @param float $estGrossProfit
     * @return \StructType\CreditMemo
     */
    public function setEstGrossProfit($estGrossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfit) && !(is_float($estGrossProfit) || is_numeric($estGrossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfit, true), gettype($estGrossProfit)), __LINE__);
        }
        $this->estGrossProfit = $estGrossProfit;
        return $this;
    }
    /**
     * Get estGrossProfitPercent value
     * @return float|null
     */
    public function getEstGrossProfitPercent()
    {
        return $this->estGrossProfitPercent;
    }
    /**
     * Set estGrossProfitPercent value
     * @param float $estGrossProfitPercent
     * @return \StructType\CreditMemo
     */
    public function setEstGrossProfitPercent($estGrossProfitPercent = null)
    {
        // validation for constraint: float
        if (!is_null($estGrossProfitPercent) && !(is_float($estGrossProfitPercent) || is_numeric($estGrossProfitPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estGrossProfitPercent, true), gettype($estGrossProfitPercent)), __LINE__);
        }
        $this->estGrossProfitPercent = $estGrossProfitPercent;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\CreditMemo
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get promoCode value
     * @return \StructType\RecordRef|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param \StructType\RecordRef $promoCode
     * @return \StructType\CreditMemo
     */
    public function setPromoCode(\StructType\RecordRef $promoCode = null)
    {
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get amountRemaining value
     * @return float|null
     */
    public function getAmountRemaining()
    {
        return $this->amountRemaining;
    }
    /**
     * Set amountRemaining value
     * @param float $amountRemaining
     * @return \StructType\CreditMemo
     */
    public function setAmountRemaining($amountRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($amountRemaining) && !(is_float($amountRemaining) || is_numeric($amountRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountRemaining, true), gettype($amountRemaining)), __LINE__);
        }
        $this->amountRemaining = $amountRemaining;
        return $this;
    }
    /**
     * Get discountItem value
     * @return \StructType\RecordRef|null
     */
    public function getDiscountItem()
    {
        return $this->discountItem;
    }
    /**
     * Set discountItem value
     * @param \StructType\RecordRef $discountItem
     * @return \StructType\CreditMemo
     */
    public function setDiscountItem(\StructType\RecordRef $discountItem = null)
    {
        $this->discountItem = $discountItem;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\CreditMemo
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get discountRate value
     * @return string|null
     */
    public function getDiscountRate()
    {
        return $this->discountRate;
    }
    /**
     * Set discountRate value
     * @param string $discountRate
     * @return \StructType\CreditMemo
     */
    public function setDiscountRate($discountRate = null)
    {
        // validation for constraint: string
        if (!is_null($discountRate) && !is_string($discountRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountRate, true), gettype($discountRate)), __LINE__);
        }
        $this->discountRate = $discountRate;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\CreditMemo
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get taxItem value
     * @return \StructType\RecordRef|null
     */
    public function getTaxItem()
    {
        return $this->taxItem;
    }
    /**
     * Set taxItem value
     * @param \StructType\RecordRef $taxItem
     * @return \StructType\CreditMemo
     */
    public function setTaxItem(\StructType\RecordRef $taxItem = null)
    {
        $this->taxItem = $taxItem;
        return $this;
    }
    /**
     * Get taxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }
    /**
     * Set taxRate value
     * @param float $taxRate
     * @return \StructType\CreditMemo
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->taxRate = $taxRate;
        return $this;
    }
    /**
     * Get unapplied value
     * @return float|null
     */
    public function getUnapplied()
    {
        return $this->unapplied;
    }
    /**
     * Set unapplied value
     * @param float $unapplied
     * @return \StructType\CreditMemo
     */
    public function setUnapplied($unapplied = null)
    {
        // validation for constraint: float
        if (!is_null($unapplied) && !(is_float($unapplied) || is_numeric($unapplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unapplied, true), gettype($unapplied)), __LINE__);
        }
        $this->unapplied = $unapplied;
        return $this;
    }
    /**
     * Get autoApply value
     * @return bool|null
     */
    public function getAutoApply()
    {
        return $this->autoApply;
    }
    /**
     * Set autoApply value
     * @param bool $autoApply
     * @return \StructType\CreditMemo
     */
    public function setAutoApply($autoApply = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoApply) && !is_bool($autoApply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoApply, true), gettype($autoApply)), __LINE__);
        }
        $this->autoApply = $autoApply;
        return $this;
    }
    /**
     * Get applied value
     * @return float|null
     */
    public function getApplied()
    {
        return $this->applied;
    }
    /**
     * Set applied value
     * @param float $applied
     * @return \StructType\CreditMemo
     */
    public function setApplied($applied = null)
    {
        // validation for constraint: float
        if (!is_null($applied) && !(is_float($applied) || is_numeric($applied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($applied, true), gettype($applied)), __LINE__);
        }
        $this->applied = $applied;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\CreditMemo
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get toBeEmailed value
     * @return bool|null
     */
    public function getToBeEmailed()
    {
        return $this->toBeEmailed;
    }
    /**
     * Set toBeEmailed value
     * @param bool $toBeEmailed
     * @return \StructType\CreditMemo
     */
    public function setToBeEmailed($toBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeEmailed) && !is_bool($toBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeEmailed, true), gettype($toBeEmailed)), __LINE__);
        }
        $this->toBeEmailed = $toBeEmailed;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CreditMemo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get toBeFaxed value
     * @return bool|null
     */
    public function getToBeFaxed()
    {
        return $this->toBeFaxed;
    }
    /**
     * Set toBeFaxed value
     * @param bool $toBeFaxed
     * @return \StructType\CreditMemo
     */
    public function setToBeFaxed($toBeFaxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeFaxed) && !is_bool($toBeFaxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeFaxed, true), gettype($toBeFaxed)), __LINE__);
        }
        $this->toBeFaxed = $toBeFaxed;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\CreditMemo
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get messageSel value
     * @return \StructType\RecordRef|null
     */
    public function getMessageSel()
    {
        return $this->messageSel;
    }
    /**
     * Set messageSel value
     * @param \StructType\RecordRef $messageSel
     * @return \StructType\CreditMemo
     */
    public function setMessageSel(\StructType\RecordRef $messageSel = null)
    {
        $this->messageSel = $messageSel;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\CreditMemo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\CreditMemo
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\CreditMemo
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\CreditMemo
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\CreditMemo
     */
    public function setShippingCost($shippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCost) && !(is_float($shippingCost) || is_numeric($shippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCost, true), gettype($shippingCost)), __LINE__);
        }
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get shippingTax1Rate value
     * @return float|null
     */
    public function getShippingTax1Rate()
    {
        return $this->shippingTax1Rate;
    }
    /**
     * Set shippingTax1Rate value
     * @param float $shippingTax1Rate
     * @return \StructType\CreditMemo
     */
    public function setShippingTax1Rate($shippingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTax1Rate) && !(is_float($shippingTax1Rate) || is_numeric($shippingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTax1Rate, true), gettype($shippingTax1Rate)), __LINE__);
        }
        $this->shippingTax1Rate = $shippingTax1Rate;
        return $this;
    }
    /**
     * Get shippingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getShippingTaxCode()
    {
        return $this->shippingTaxCode;
    }
    /**
     * Set shippingTaxCode value
     * @param \StructType\RecordRef $shippingTaxCode
     * @return \StructType\CreditMemo
     */
    public function setShippingTaxCode(\StructType\RecordRef $shippingTaxCode = null)
    {
        $this->shippingTaxCode = $shippingTaxCode;
        return $this;
    }
    /**
     * Get handlingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getHandlingTaxCode()
    {
        return $this->handlingTaxCode;
    }
    /**
     * Set handlingTaxCode value
     * @param \StructType\RecordRef $handlingTaxCode
     * @return \StructType\CreditMemo
     */
    public function setHandlingTaxCode(\StructType\RecordRef $handlingTaxCode = null)
    {
        $this->handlingTaxCode = $handlingTaxCode;
        return $this;
    }
    /**
     * Get shippingTax2Rate value
     * @return string|null
     */
    public function getShippingTax2Rate()
    {
        return $this->shippingTax2Rate;
    }
    /**
     * Set shippingTax2Rate value
     * @param string $shippingTax2Rate
     * @return \StructType\CreditMemo
     */
    public function setShippingTax2Rate($shippingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingTax2Rate) && !is_string($shippingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingTax2Rate, true), gettype($shippingTax2Rate)), __LINE__);
        }
        $this->shippingTax2Rate = $shippingTax2Rate;
        return $this;
    }
    /**
     * Get handlingTax1Rate value
     * @return float|null
     */
    public function getHandlingTax1Rate()
    {
        return $this->handlingTax1Rate;
    }
    /**
     * Set handlingTax1Rate value
     * @param float $handlingTax1Rate
     * @return \StructType\CreditMemo
     */
    public function setHandlingTax1Rate($handlingTax1Rate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTax1Rate) && !(is_float($handlingTax1Rate) || is_numeric($handlingTax1Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTax1Rate, true), gettype($handlingTax1Rate)), __LINE__);
        }
        $this->handlingTax1Rate = $handlingTax1Rate;
        return $this;
    }
    /**
     * Get handlingTax2Rate value
     * @return string|null
     */
    public function getHandlingTax2Rate()
    {
        return $this->handlingTax2Rate;
    }
    /**
     * Set handlingTax2Rate value
     * @param string $handlingTax2Rate
     * @return \StructType\CreditMemo
     */
    public function setHandlingTax2Rate($handlingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($handlingTax2Rate) && !is_string($handlingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingTax2Rate, true), gettype($handlingTax2Rate)), __LINE__);
        }
        $this->handlingTax2Rate = $handlingTax2Rate;
        return $this;
    }
    /**
     * Get handlingCost value
     * @return float|null
     */
    public function getHandlingCost()
    {
        return $this->handlingCost;
    }
    /**
     * Set handlingCost value
     * @param float $handlingCost
     * @return \StructType\CreditMemo
     */
    public function setHandlingCost($handlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($handlingCost) && !(is_float($handlingCost) || is_numeric($handlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingCost, true), gettype($handlingCost)), __LINE__);
        }
        $this->handlingCost = $handlingCost;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\CreditMemo
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get discountTotal value
     * @return float|null
     */
    public function getDiscountTotal()
    {
        return $this->discountTotal;
    }
    /**
     * Set discountTotal value
     * @param float $discountTotal
     * @return \StructType\CreditMemo
     */
    public function setDiscountTotal($discountTotal = null)
    {
        // validation for constraint: float
        if (!is_null($discountTotal) && !(is_float($discountTotal) || is_numeric($discountTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountTotal, true), gettype($discountTotal)), __LINE__);
        }
        $this->discountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get revenueStatus value
     * @return string|null
     */
    public function getRevenueStatus()
    {
        return $this->revenueStatus;
    }
    /**
     * Set revenueStatus value
     * @uses \EnumType\RevenueStatus::valueIsValid()
     * @uses \EnumType\RevenueStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $revenueStatus
     * @return \StructType\CreditMemo
     */
    public function setRevenueStatus($revenueStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RevenueStatus::valueIsValid($revenueStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RevenueStatus', is_array($revenueStatus) ? implode(', ', $revenueStatus) : var_export($revenueStatus, true), implode(', ', \EnumType\RevenueStatus::getValidValues())), __LINE__);
        }
        $this->revenueStatus = $revenueStatus;
        return $this;
    }
    /**
     * Get recognizedRevenue value
     * @return float|null
     */
    public function getRecognizedRevenue()
    {
        return $this->recognizedRevenue;
    }
    /**
     * Set recognizedRevenue value
     * @param float $recognizedRevenue
     * @return \StructType\CreditMemo
     */
    public function setRecognizedRevenue($recognizedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($recognizedRevenue) && !(is_float($recognizedRevenue) || is_numeric($recognizedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recognizedRevenue, true), gettype($recognizedRevenue)), __LINE__);
        }
        $this->recognizedRevenue = $recognizedRevenue;
        return $this;
    }
    /**
     * Get deferredRevenue value
     * @return float|null
     */
    public function getDeferredRevenue()
    {
        return $this->deferredRevenue;
    }
    /**
     * Set deferredRevenue value
     * @param float $deferredRevenue
     * @return \StructType\CreditMemo
     */
    public function setDeferredRevenue($deferredRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($deferredRevenue) && !(is_float($deferredRevenue) || is_numeric($deferredRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deferredRevenue, true), gettype($deferredRevenue)), __LINE__);
        }
        $this->deferredRevenue = $deferredRevenue;
        return $this;
    }
    /**
     * Get revRecOnRevCommitment value
     * @return bool|null
     */
    public function getRevRecOnRevCommitment()
    {
        return $this->revRecOnRevCommitment;
    }
    /**
     * Set revRecOnRevCommitment value
     * @param bool $revRecOnRevCommitment
     * @return \StructType\CreditMemo
     */
    public function setRevRecOnRevCommitment($revRecOnRevCommitment = null)
    {
        // validation for constraint: boolean
        if (!is_null($revRecOnRevCommitment) && !is_bool($revRecOnRevCommitment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($revRecOnRevCommitment, true), gettype($revRecOnRevCommitment)), __LINE__);
        }
        $this->revRecOnRevCommitment = $revRecOnRevCommitment;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\CreditMemo
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\CreditMemo
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get altShippingCost value
     * @return float|null
     */
    public function getAltShippingCost()
    {
        return $this->altShippingCost;
    }
    /**
     * Set altShippingCost value
     * @param float $altShippingCost
     * @return \StructType\CreditMemo
     */
    public function setAltShippingCost($altShippingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altShippingCost) && !(is_float($altShippingCost) || is_numeric($altShippingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altShippingCost, true), gettype($altShippingCost)), __LINE__);
        }
        $this->altShippingCost = $altShippingCost;
        return $this;
    }
    /**
     * Get altHandlingCost value
     * @return float|null
     */
    public function getAltHandlingCost()
    {
        return $this->altHandlingCost;
    }
    /**
     * Set altHandlingCost value
     * @param float $altHandlingCost
     * @return \StructType\CreditMemo
     */
    public function setAltHandlingCost($altHandlingCost = null)
    {
        // validation for constraint: float
        if (!is_null($altHandlingCost) && !(is_float($altHandlingCost) || is_numeric($altHandlingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($altHandlingCost, true), gettype($altHandlingCost)), __LINE__);
        }
        $this->altHandlingCost = $altHandlingCost;
        return $this;
    }
    /**
     * Get isMultiShipTo value
     * @return bool|null
     */
    public function getIsMultiShipTo()
    {
        return $this->isMultiShipTo;
    }
    /**
     * Set isMultiShipTo value
     * @param bool $isMultiShipTo
     * @return \StructType\CreditMemo
     */
    public function setIsMultiShipTo($isMultiShipTo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultiShipTo) && !is_bool($isMultiShipTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMultiShipTo, true), gettype($isMultiShipTo)), __LINE__);
        }
        $this->isMultiShipTo = $isMultiShipTo;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\CreditMemo
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get salesGroup value
     * @return \StructType\RecordRef|null
     */
    public function getSalesGroup()
    {
        return $this->salesGroup;
    }
    /**
     * Set salesGroup value
     * @param \StructType\RecordRef $salesGroup
     * @return \StructType\CreditMemo
     */
    public function setSalesGroup(\StructType\RecordRef $salesGroup = null)
    {
        $this->salesGroup = $salesGroup;
        return $this;
    }
    /**
     * Get syncSalesTeams value
     * @return bool|null
     */
    public function getSyncSalesTeams()
    {
        return $this->syncSalesTeams;
    }
    /**
     * Set syncSalesTeams value
     * @param bool $syncSalesTeams
     * @return \StructType\CreditMemo
     */
    public function setSyncSalesTeams($syncSalesTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncSalesTeams) && !is_bool($syncSalesTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncSalesTeams, true), gettype($syncSalesTeams)), __LINE__);
        }
        $this->syncSalesTeams = $syncSalesTeams;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CreditMemo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get giftCert value
     * @return \StructType\RecordRef|null
     */
    public function getGiftCert()
    {
        return $this->giftCert;
    }
    /**
     * Set giftCert value
     * @param \StructType\RecordRef $giftCert
     * @return \StructType\CreditMemo
     */
    public function setGiftCert(\StructType\RecordRef $giftCert = null)
    {
        $this->giftCert = $giftCert;
        return $this;
    }
    /**
     * Get giftCertTotal value
     * @return float|null
     */
    public function getGiftCertTotal()
    {
        return $this->giftCertTotal;
    }
    /**
     * Set giftCertTotal value
     * @param float $giftCertTotal
     * @return \StructType\CreditMemo
     */
    public function setGiftCertTotal($giftCertTotal = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertTotal) && !(is_float($giftCertTotal) || is_numeric($giftCertTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertTotal, true), gettype($giftCertTotal)), __LINE__);
        }
        $this->giftCertTotal = $giftCertTotal;
        return $this;
    }
    /**
     * Get giftCertApplied value
     * @return float|null
     */
    public function getGiftCertApplied()
    {
        return $this->giftCertApplied;
    }
    /**
     * Set giftCertApplied value
     * @param float $giftCertApplied
     * @return \StructType\CreditMemo
     */
    public function setGiftCertApplied($giftCertApplied = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertApplied) && !(is_float($giftCertApplied) || is_numeric($giftCertApplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertApplied, true), gettype($giftCertApplied)), __LINE__);
        }
        $this->giftCertApplied = $giftCertApplied;
        return $this;
    }
    /**
     * Get giftCertAvailable value
     * @return float|null
     */
    public function getGiftCertAvailable()
    {
        return $this->giftCertAvailable;
    }
    /**
     * Set giftCertAvailable value
     * @param float $giftCertAvailable
     * @return \StructType\CreditMemo
     */
    public function setGiftCertAvailable($giftCertAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($giftCertAvailable) && !(is_float($giftCertAvailable) || is_numeric($giftCertAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftCertAvailable, true), gettype($giftCertAvailable)), __LINE__);
        }
        $this->giftCertAvailable = $giftCertAvailable;
        return $this;
    }
    /**
     * Get tranIsVsoeBundle value
     * @return bool|null
     */
    public function getTranIsVsoeBundle()
    {
        return $this->tranIsVsoeBundle;
    }
    /**
     * Set tranIsVsoeBundle value
     * @param bool $tranIsVsoeBundle
     * @return \StructType\CreditMemo
     */
    public function setTranIsVsoeBundle($tranIsVsoeBundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($tranIsVsoeBundle) && !is_bool($tranIsVsoeBundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tranIsVsoeBundle, true), gettype($tranIsVsoeBundle)), __LINE__);
        }
        $this->tranIsVsoeBundle = $tranIsVsoeBundle;
        return $this;
    }
    /**
     * Get vsoeAutoCalc value
     * @return bool|null
     */
    public function getVsoeAutoCalc()
    {
        return $this->vsoeAutoCalc;
    }
    /**
     * Set vsoeAutoCalc value
     * @param bool $vsoeAutoCalc
     * @return \StructType\CreditMemo
     */
    public function setVsoeAutoCalc($vsoeAutoCalc = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeAutoCalc) && !is_bool($vsoeAutoCalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeAutoCalc, true), gettype($vsoeAutoCalc)), __LINE__);
        }
        $this->vsoeAutoCalc = $vsoeAutoCalc;
        return $this;
    }
    /**
     * Get syncPartnerTeams value
     * @return bool|null
     */
    public function getSyncPartnerTeams()
    {
        return $this->syncPartnerTeams;
    }
    /**
     * Set syncPartnerTeams value
     * @param bool $syncPartnerTeams
     * @return \StructType\CreditMemo
     */
    public function setSyncPartnerTeams($syncPartnerTeams = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncPartnerTeams) && !is_bool($syncPartnerTeams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncPartnerTeams, true), gettype($syncPartnerTeams)), __LINE__);
        }
        $this->syncPartnerTeams = $syncPartnerTeams;
        return $this;
    }
    /**
     * Get salesTeamList value
     * @return \StructType\CreditMemoSalesTeamList|null
     */
    public function getSalesTeamList()
    {
        return $this->salesTeamList;
    }
    /**
     * Set salesTeamList value
     * @param \StructType\CreditMemoSalesTeamList $salesTeamList
     * @return \StructType\CreditMemo
     */
    public function setSalesTeamList(\StructType\CreditMemoSalesTeamList $salesTeamList = null)
    {
        $this->salesTeamList = $salesTeamList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\CreditMemoItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\CreditMemoItemList $itemList
     * @return \StructType\CreditMemo
     */
    public function setItemList(\StructType\CreditMemoItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\CreditMemo
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\CreditMemoPartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\CreditMemoPartnersList $partnersList
     * @return \StructType\CreditMemo
     */
    public function setPartnersList(\StructType\CreditMemoPartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get applyList value
     * @return \StructType\CreditMemoApplyList|null
     */
    public function getApplyList()
    {
        return $this->applyList;
    }
    /**
     * Set applyList value
     * @param \StructType\CreditMemoApplyList $applyList
     * @return \StructType\CreditMemo
     */
    public function setApplyList(\StructType\CreditMemoApplyList $applyList = null)
    {
        $this->applyList = $applyList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\CreditMemo
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CreditMemo
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CreditMemo
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CreditMemo
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
