<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponCode StructType
 * @subpackage Structs
 */
class CouponCode extends Record
{
    /**
     * The promotion
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\RecordRef
     */
    public $promotion;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $code;
    /**
     * The recipient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $recipient;
    /**
     * The dateSent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateSent;
    /**
     * The used
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $used;
    /**
     * The useCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $useCount;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CouponCode
     * @uses CouponCode::setPromotion()
     * @uses CouponCode::setCode()
     * @uses CouponCode::setRecipient()
     * @uses CouponCode::setDateSent()
     * @uses CouponCode::setUsed()
     * @uses CouponCode::setUseCount()
     * @uses CouponCode::setInternalId()
     * @uses CouponCode::setExternalId()
     * @param \StructType\RecordRef $promotion
     * @param string $code
     * @param \StructType\RecordRef $recipient
     * @param string $dateSent
     * @param bool $used
     * @param int $useCount
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $promotion = null, $code = null, \StructType\RecordRef $recipient = null, $dateSent = null, $used = null, $useCount = null, $internalId = null, $externalId = null)
    {
        $this
            ->setPromotion($promotion)
            ->setCode($code)
            ->setRecipient($recipient)
            ->setDateSent($dateSent)
            ->setUsed($used)
            ->setUseCount($useCount)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get promotion value
     * @return \StructType\RecordRef
     */
    public function getPromotion()
    {
        return $this->promotion;
    }
    /**
     * Set promotion value
     * @param \StructType\RecordRef $promotion
     * @return \StructType\CouponCode
     */
    public function setPromotion(\StructType\RecordRef $promotion = null)
    {
        $this->promotion = $promotion;
        return $this;
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\CouponCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get recipient value
     * @return \StructType\RecordRef|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @param \StructType\RecordRef $recipient
     * @return \StructType\CouponCode
     */
    public function setRecipient(\StructType\RecordRef $recipient = null)
    {
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Get dateSent value
     * @return string|null
     */
    public function getDateSent()
    {
        return $this->dateSent;
    }
    /**
     * Set dateSent value
     * @param string $dateSent
     * @return \StructType\CouponCode
     */
    public function setDateSent($dateSent = null)
    {
        // validation for constraint: string
        if (!is_null($dateSent) && !is_string($dateSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateSent, true), gettype($dateSent)), __LINE__);
        }
        $this->dateSent = $dateSent;
        return $this;
    }
    /**
     * Get used value
     * @return bool|null
     */
    public function getUsed()
    {
        return $this->used;
    }
    /**
     * Set used value
     * @param bool $used
     * @return \StructType\CouponCode
     */
    public function setUsed($used = null)
    {
        // validation for constraint: boolean
        if (!is_null($used) && !is_bool($used)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($used, true), gettype($used)), __LINE__);
        }
        $this->used = $used;
        return $this;
    }
    /**
     * Get useCount value
     * @return int|null
     */
    public function getUseCount()
    {
        return $this->useCount;
    }
    /**
     * Set useCount value
     * @param int $useCount
     * @return \StructType\CouponCode
     */
    public function setUseCount($useCount = null)
    {
        // validation for constraint: int
        if (!is_null($useCount) && !(is_int($useCount) || ctype_digit($useCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($useCount, true), gettype($useCount)), __LINE__);
        }
        $this->useCount = $useCount;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CouponCode
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CouponCode
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
