<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCategorySearchRowBasic StructType
 * @subpackage Structs
 */
class CostCategorySearchRowBasic extends SearchRowBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $account;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The itemCostType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $itemCostType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * Constructor method for CostCategorySearchRowBasic
     * @uses CostCategorySearchRowBasic::setAccount()
     * @uses CostCategorySearchRowBasic::setExternalId()
     * @uses CostCategorySearchRowBasic::setInternalId()
     * @uses CostCategorySearchRowBasic::setIsInactive()
     * @uses CostCategorySearchRowBasic::setItemCostType()
     * @uses CostCategorySearchRowBasic::setName()
     * @param \StructType\SearchColumnSelectField[] $account
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnEnumSelectField[] $itemCostType
     * @param \StructType\SearchColumnStringField[] $name
     */
    public function __construct(array $account = array(), array $externalId = array(), array $internalId = array(), array $isInactive = array(), array $itemCostType = array(), array $name = array())
    {
        $this
            ->setAccount($account)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setIsInactive($isInactive)
            ->setItemCostType($itemCostType)
            ->setName($name);
    }
    /**
     * Get account value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costCategorySearchRowBasicAccountItem) {
            // validation for constraint: itemType
            if (!$costCategorySearchRowBasicAccountItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($costCategorySearchRowBasicAccountItem) ? get_class($costCategorySearchRowBasicAccountItem) : sprintf('%s(%s)', gettype($costCategorySearchRowBasicAccountItem), var_export($costCategorySearchRowBasicAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $account
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Add item to account value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function addToAccount(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The account property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->account[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costCategorySearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$costCategorySearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($costCategorySearchRowBasicExternalIdItem) ? get_class($costCategorySearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($costCategorySearchRowBasicExternalIdItem), var_export($costCategorySearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costCategorySearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$costCategorySearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($costCategorySearchRowBasicInternalIdItem) ? get_class($costCategorySearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($costCategorySearchRowBasicInternalIdItem), var_export($costCategorySearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costCategorySearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$costCategorySearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($costCategorySearchRowBasicIsInactiveItem) ? get_class($costCategorySearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($costCategorySearchRowBasicIsInactiveItem), var_export($costCategorySearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get itemCostType value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getItemCostType()
    {
        return $this->itemCostType;
    }
    /**
     * This method is responsible for validating the values passed to the setItemCostType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemCostType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemCostTypeForArrayConstraintsFromSetItemCostType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costCategorySearchRowBasicItemCostTypeItem) {
            // validation for constraint: itemType
            if (!$costCategorySearchRowBasicItemCostTypeItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($costCategorySearchRowBasicItemCostTypeItem) ? get_class($costCategorySearchRowBasicItemCostTypeItem) : sprintf('%s(%s)', gettype($costCategorySearchRowBasicItemCostTypeItem), var_export($costCategorySearchRowBasicItemCostTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemCostType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemCostType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $itemCostType
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function setItemCostType(array $itemCostType = array())
    {
        // validation for constraint: array
        if ('' !== ($itemCostTypeArrayErrorMessage = self::validateItemCostTypeForArrayConstraintsFromSetItemCostType($itemCostType))) {
            throw new \InvalidArgumentException($itemCostTypeArrayErrorMessage, __LINE__);
        }
        $this->itemCostType = $itemCostType;
        return $this;
    }
    /**
     * Add item to itemCostType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function addToItemCostType(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The itemCostType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemCostType[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costCategorySearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$costCategorySearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($costCategorySearchRowBasicNameItem) ? get_class($costCategorySearchRowBasicNameItem) : sprintf('%s(%s)', gettype($costCategorySearchRowBasicNameItem), var_export($costCategorySearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\CostCategorySearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
}
