<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactAddressbookList StructType
 * @subpackage Structs
 */
class ContactAddressbookList extends AbstractStructBase
{
    /**
     * The addressbook
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactAddressbook[]
     */
    public $addressbook;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ContactAddressbookList
     * @uses ContactAddressbookList::setAddressbook()
     * @uses ContactAddressbookList::setReplaceAll()
     * @param \StructType\ContactAddressbook[] $addressbook
     * @param bool $replaceAll
     */
    public function __construct(array $addressbook = array(), $replaceAll = true)
    {
        $this
            ->setAddressbook($addressbook)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get addressbook value
     * @return \StructType\ContactAddressbook[]|null
     */
    public function getAddressbook()
    {
        return $this->addressbook;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressbook method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressbook method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressbookForArrayConstraintsFromSetAddressbook(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactAddressbookListAddressbookItem) {
            // validation for constraint: itemType
            if (!$contactAddressbookListAddressbookItem instanceof \StructType\ContactAddressbook) {
                $invalidValues[] = is_object($contactAddressbookListAddressbookItem) ? get_class($contactAddressbookListAddressbookItem) : sprintf('%s(%s)', gettype($contactAddressbookListAddressbookItem), var_export($contactAddressbookListAddressbookItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The addressbook property can only contain items of type \StructType\ContactAddressbook, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set addressbook value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactAddressbook[] $addressbook
     * @return \StructType\ContactAddressbookList
     */
    public function setAddressbook(array $addressbook = array())
    {
        // validation for constraint: array
        if ('' !== ($addressbookArrayErrorMessage = self::validateAddressbookForArrayConstraintsFromSetAddressbook($addressbook))) {
            throw new \InvalidArgumentException($addressbookArrayErrorMessage, __LINE__);
        }
        $this->addressbook = $addressbook;
        return $this;
    }
    /**
     * Add item to addressbook value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactAddressbook $item
     * @return \StructType\ContactAddressbookList
     */
    public function addToAddressbook(\StructType\ContactAddressbook $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactAddressbook) {
            throw new \InvalidArgumentException(sprintf('The addressbook property can only contain items of type \StructType\ContactAddressbook, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->addressbook[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ContactAddressbookList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
