<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactAccessRolesList StructType
 * @subpackage Structs
 */
class ContactAccessRolesList extends AbstractStructBase
{
    /**
     * The contactRoles
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactAccessRoles[]
     */
    public $contactRoles;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ContactAccessRolesList
     * @uses ContactAccessRolesList::setContactRoles()
     * @uses ContactAccessRolesList::setReplaceAll()
     * @param \StructType\ContactAccessRoles[] $contactRoles
     * @param bool $replaceAll
     */
    public function __construct(array $contactRoles = array(), $replaceAll = true)
    {
        $this
            ->setContactRoles($contactRoles)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get contactRoles value
     * @return \StructType\ContactAccessRoles[]|null
     */
    public function getContactRoles()
    {
        return $this->contactRoles;
    }
    /**
     * This method is responsible for validating the values passed to the setContactRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactRoles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactRolesForArrayConstraintsFromSetContactRoles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactAccessRolesListContactRolesItem) {
            // validation for constraint: itemType
            if (!$contactAccessRolesListContactRolesItem instanceof \StructType\ContactAccessRoles) {
                $invalidValues[] = is_object($contactAccessRolesListContactRolesItem) ? get_class($contactAccessRolesListContactRolesItem) : sprintf('%s(%s)', gettype($contactAccessRolesListContactRolesItem), var_export($contactAccessRolesListContactRolesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contactRoles property can only contain items of type \StructType\ContactAccessRoles, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contactRoles value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactAccessRoles[] $contactRoles
     * @return \StructType\ContactAccessRolesList
     */
    public function setContactRoles(array $contactRoles = array())
    {
        // validation for constraint: array
        if ('' !== ($contactRolesArrayErrorMessage = self::validateContactRolesForArrayConstraintsFromSetContactRoles($contactRoles))) {
            throw new \InvalidArgumentException($contactRolesArrayErrorMessage, __LINE__);
        }
        $this->contactRoles = $contactRoles;
        return $this;
    }
    /**
     * Add item to contactRoles value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactAccessRoles $item
     * @return \StructType\ContactAccessRolesList
     */
    public function addToContactRoles(\StructType\ContactAccessRoles $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactAccessRoles) {
            throw new \InvalidArgumentException(sprintf('The contactRoles property can only contain items of type \StructType\ContactAccessRoles, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contactRoles[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ContactAccessRolesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
