<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsolidatedExchangeRateSearchRowBasic StructType
 * @subpackage Structs
 */
class ConsolidatedExchangeRateSearchRowBasic extends SearchRowBasic
{
    /**
     * The accountingBook
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $accountingBook;
    /**
     * The averageRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $averageRate;
    /**
     * The closed
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $closed;
    /**
     * The currentRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $currentRate;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The fromCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $fromCurrency;
    /**
     * The fromSubsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $fromSubsidiary;
    /**
     * The historicalRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $historicalRate;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The periodEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $periodEndDate;
    /**
     * The periodName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $periodName;
    /**
     * The periodStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDateField[]
     */
    public $periodStartDate;
    /**
     * The toCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $toCurrency;
    /**
     * The toSubsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $toSubsidiary;
    /**
     * Constructor method for ConsolidatedExchangeRateSearchRowBasic
     * @uses ConsolidatedExchangeRateSearchRowBasic::setAccountingBook()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setAverageRate()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setClosed()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setCurrentRate()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setExternalId()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setFromCurrency()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setFromSubsidiary()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setHistoricalRate()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setInternalId()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setPeriodEndDate()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setPeriodName()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setPeriodStartDate()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setToCurrency()
     * @uses ConsolidatedExchangeRateSearchRowBasic::setToSubsidiary()
     * @param \StructType\SearchColumnStringField[] $accountingBook
     * @param \StructType\SearchColumnStringField[] $averageRate
     * @param \StructType\SearchColumnBooleanField[] $closed
     * @param \StructType\SearchColumnStringField[] $currentRate
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnStringField[] $fromCurrency
     * @param \StructType\SearchColumnStringField[] $fromSubsidiary
     * @param \StructType\SearchColumnStringField[] $historicalRate
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnDateField[] $periodEndDate
     * @param \StructType\SearchColumnStringField[] $periodName
     * @param \StructType\SearchColumnDateField[] $periodStartDate
     * @param \StructType\SearchColumnStringField[] $toCurrency
     * @param \StructType\SearchColumnStringField[] $toSubsidiary
     */
    public function __construct(array $accountingBook = array(), array $averageRate = array(), array $closed = array(), array $currentRate = array(), array $externalId = array(), array $fromCurrency = array(), array $fromSubsidiary = array(), array $historicalRate = array(), array $internalId = array(), array $periodEndDate = array(), array $periodName = array(), array $periodStartDate = array(), array $toCurrency = array(), array $toSubsidiary = array())
    {
        $this
            ->setAccountingBook($accountingBook)
            ->setAverageRate($averageRate)
            ->setClosed($closed)
            ->setCurrentRate($currentRate)
            ->setExternalId($externalId)
            ->setFromCurrency($fromCurrency)
            ->setFromSubsidiary($fromSubsidiary)
            ->setHistoricalRate($historicalRate)
            ->setInternalId($internalId)
            ->setPeriodEndDate($periodEndDate)
            ->setPeriodName($periodName)
            ->setPeriodStartDate($periodStartDate)
            ->setToCurrency($toCurrency)
            ->setToSubsidiary($toSubsidiary);
    }
    /**
     * Get accountingBook value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAccountingBook()
    {
        return $this->accountingBook;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountingBook method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountingBook method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountingBookForArrayConstraintsFromSetAccountingBook(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicAccountingBookItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicAccountingBookItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicAccountingBookItem) ? get_class($consolidatedExchangeRateSearchRowBasicAccountingBookItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicAccountingBookItem), var_export($consolidatedExchangeRateSearchRowBasicAccountingBookItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accountingBook property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accountingBook value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $accountingBook
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setAccountingBook(array $accountingBook = array())
    {
        // validation for constraint: array
        if ('' !== ($accountingBookArrayErrorMessage = self::validateAccountingBookForArrayConstraintsFromSetAccountingBook($accountingBook))) {
            throw new \InvalidArgumentException($accountingBookArrayErrorMessage, __LINE__);
        }
        $this->accountingBook = $accountingBook;
        return $this;
    }
    /**
     * Add item to accountingBook value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToAccountingBook(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The accountingBook property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accountingBook[] = $item;
        return $this;
    }
    /**
     * Get averageRate value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAverageRate()
    {
        return $this->averageRate;
    }
    /**
     * This method is responsible for validating the values passed to the setAverageRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAverageRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAverageRateForArrayConstraintsFromSetAverageRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicAverageRateItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicAverageRateItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicAverageRateItem) ? get_class($consolidatedExchangeRateSearchRowBasicAverageRateItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicAverageRateItem), var_export($consolidatedExchangeRateSearchRowBasicAverageRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The averageRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set averageRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $averageRate
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setAverageRate(array $averageRate = array())
    {
        // validation for constraint: array
        if ('' !== ($averageRateArrayErrorMessage = self::validateAverageRateForArrayConstraintsFromSetAverageRate($averageRate))) {
            throw new \InvalidArgumentException($averageRateArrayErrorMessage, __LINE__);
        }
        $this->averageRate = $averageRate;
        return $this;
    }
    /**
     * Add item to averageRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToAverageRate(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The averageRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->averageRate[] = $item;
        return $this;
    }
    /**
     * Get closed value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getClosed()
    {
        return $this->closed;
    }
    /**
     * This method is responsible for validating the values passed to the setClosed method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClosed method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClosedForArrayConstraintsFromSetClosed(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicClosedItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicClosedItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicClosedItem) ? get_class($consolidatedExchangeRateSearchRowBasicClosedItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicClosedItem), var_export($consolidatedExchangeRateSearchRowBasicClosedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The closed property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set closed value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $closed
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setClosed(array $closed = array())
    {
        // validation for constraint: array
        if ('' !== ($closedArrayErrorMessage = self::validateClosedForArrayConstraintsFromSetClosed($closed))) {
            throw new \InvalidArgumentException($closedArrayErrorMessage, __LINE__);
        }
        $this->closed = $closed;
        return $this;
    }
    /**
     * Add item to closed value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToClosed(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The closed property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->closed[] = $item;
        return $this;
    }
    /**
     * Get currentRate value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCurrentRate()
    {
        return $this->currentRate;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrentRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrentRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrentRateForArrayConstraintsFromSetCurrentRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicCurrentRateItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicCurrentRateItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicCurrentRateItem) ? get_class($consolidatedExchangeRateSearchRowBasicCurrentRateItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicCurrentRateItem), var_export($consolidatedExchangeRateSearchRowBasicCurrentRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currentRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currentRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $currentRate
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setCurrentRate(array $currentRate = array())
    {
        // validation for constraint: array
        if ('' !== ($currentRateArrayErrorMessage = self::validateCurrentRateForArrayConstraintsFromSetCurrentRate($currentRate))) {
            throw new \InvalidArgumentException($currentRateArrayErrorMessage, __LINE__);
        }
        $this->currentRate = $currentRate;
        return $this;
    }
    /**
     * Add item to currentRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToCurrentRate(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The currentRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->currentRate[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicExternalIdItem) ? get_class($consolidatedExchangeRateSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicExternalIdItem), var_export($consolidatedExchangeRateSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get fromCurrency value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getFromCurrency()
    {
        return $this->fromCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setFromCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFromCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFromCurrencyForArrayConstraintsFromSetFromCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicFromCurrencyItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicFromCurrencyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicFromCurrencyItem) ? get_class($consolidatedExchangeRateSearchRowBasicFromCurrencyItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicFromCurrencyItem), var_export($consolidatedExchangeRateSearchRowBasicFromCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fromCurrency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fromCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $fromCurrency
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setFromCurrency(array $fromCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($fromCurrencyArrayErrorMessage = self::validateFromCurrencyForArrayConstraintsFromSetFromCurrency($fromCurrency))) {
            throw new \InvalidArgumentException($fromCurrencyArrayErrorMessage, __LINE__);
        }
        $this->fromCurrency = $fromCurrency;
        return $this;
    }
    /**
     * Add item to fromCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToFromCurrency(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The fromCurrency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fromCurrency[] = $item;
        return $this;
    }
    /**
     * Get fromSubsidiary value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getFromSubsidiary()
    {
        return $this->fromSubsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setFromSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFromSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFromSubsidiaryForArrayConstraintsFromSetFromSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicFromSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicFromSubsidiaryItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicFromSubsidiaryItem) ? get_class($consolidatedExchangeRateSearchRowBasicFromSubsidiaryItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicFromSubsidiaryItem), var_export($consolidatedExchangeRateSearchRowBasicFromSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fromSubsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fromSubsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $fromSubsidiary
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setFromSubsidiary(array $fromSubsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($fromSubsidiaryArrayErrorMessage = self::validateFromSubsidiaryForArrayConstraintsFromSetFromSubsidiary($fromSubsidiary))) {
            throw new \InvalidArgumentException($fromSubsidiaryArrayErrorMessage, __LINE__);
        }
        $this->fromSubsidiary = $fromSubsidiary;
        return $this;
    }
    /**
     * Add item to fromSubsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToFromSubsidiary(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The fromSubsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fromSubsidiary[] = $item;
        return $this;
    }
    /**
     * Get historicalRate value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getHistoricalRate()
    {
        return $this->historicalRate;
    }
    /**
     * This method is responsible for validating the values passed to the setHistoricalRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHistoricalRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHistoricalRateForArrayConstraintsFromSetHistoricalRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicHistoricalRateItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicHistoricalRateItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicHistoricalRateItem) ? get_class($consolidatedExchangeRateSearchRowBasicHistoricalRateItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicHistoricalRateItem), var_export($consolidatedExchangeRateSearchRowBasicHistoricalRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The historicalRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set historicalRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $historicalRate
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setHistoricalRate(array $historicalRate = array())
    {
        // validation for constraint: array
        if ('' !== ($historicalRateArrayErrorMessage = self::validateHistoricalRateForArrayConstraintsFromSetHistoricalRate($historicalRate))) {
            throw new \InvalidArgumentException($historicalRateArrayErrorMessage, __LINE__);
        }
        $this->historicalRate = $historicalRate;
        return $this;
    }
    /**
     * Add item to historicalRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToHistoricalRate(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The historicalRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->historicalRate[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicInternalIdItem) ? get_class($consolidatedExchangeRateSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicInternalIdItem), var_export($consolidatedExchangeRateSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get periodEndDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getPeriodEndDate()
    {
        return $this->periodEndDate;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodEndDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodEndDateForArrayConstraintsFromSetPeriodEndDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicPeriodEndDateItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicPeriodEndDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicPeriodEndDateItem) ? get_class($consolidatedExchangeRateSearchRowBasicPeriodEndDateItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicPeriodEndDateItem), var_export($consolidatedExchangeRateSearchRowBasicPeriodEndDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The periodEndDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set periodEndDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $periodEndDate
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setPeriodEndDate(array $periodEndDate = array())
    {
        // validation for constraint: array
        if ('' !== ($periodEndDateArrayErrorMessage = self::validatePeriodEndDateForArrayConstraintsFromSetPeriodEndDate($periodEndDate))) {
            throw new \InvalidArgumentException($periodEndDateArrayErrorMessage, __LINE__);
        }
        $this->periodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Add item to periodEndDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToPeriodEndDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The periodEndDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->periodEndDate[] = $item;
        return $this;
    }
    /**
     * Get periodName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPeriodName()
    {
        return $this->periodName;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodNameForArrayConstraintsFromSetPeriodName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicPeriodNameItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicPeriodNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicPeriodNameItem) ? get_class($consolidatedExchangeRateSearchRowBasicPeriodNameItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicPeriodNameItem), var_export($consolidatedExchangeRateSearchRowBasicPeriodNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The periodName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set periodName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $periodName
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setPeriodName(array $periodName = array())
    {
        // validation for constraint: array
        if ('' !== ($periodNameArrayErrorMessage = self::validatePeriodNameForArrayConstraintsFromSetPeriodName($periodName))) {
            throw new \InvalidArgumentException($periodNameArrayErrorMessage, __LINE__);
        }
        $this->periodName = $periodName;
        return $this;
    }
    /**
     * Add item to periodName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToPeriodName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The periodName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->periodName[] = $item;
        return $this;
    }
    /**
     * Get periodStartDate value
     * @return \StructType\SearchColumnDateField[]|null
     */
    public function getPeriodStartDate()
    {
        return $this->periodStartDate;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodStartDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodStartDateForArrayConstraintsFromSetPeriodStartDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicPeriodStartDateItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicPeriodStartDateItem instanceof \StructType\SearchColumnDateField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicPeriodStartDateItem) ? get_class($consolidatedExchangeRateSearchRowBasicPeriodStartDateItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicPeriodStartDateItem), var_export($consolidatedExchangeRateSearchRowBasicPeriodStartDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The periodStartDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set periodStartDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField[] $periodStartDate
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setPeriodStartDate(array $periodStartDate = array())
    {
        // validation for constraint: array
        if ('' !== ($periodStartDateArrayErrorMessage = self::validatePeriodStartDateForArrayConstraintsFromSetPeriodStartDate($periodStartDate))) {
            throw new \InvalidArgumentException($periodStartDateArrayErrorMessage, __LINE__);
        }
        $this->periodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Add item to periodStartDate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDateField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToPeriodStartDate(\StructType\SearchColumnDateField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDateField) {
            throw new \InvalidArgumentException(sprintf('The periodStartDate property can only contain items of type \StructType\SearchColumnDateField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->periodStartDate[] = $item;
        return $this;
    }
    /**
     * Get toCurrency value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getToCurrency()
    {
        return $this->toCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setToCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToCurrencyForArrayConstraintsFromSetToCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicToCurrencyItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicToCurrencyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicToCurrencyItem) ? get_class($consolidatedExchangeRateSearchRowBasicToCurrencyItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicToCurrencyItem), var_export($consolidatedExchangeRateSearchRowBasicToCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The toCurrency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set toCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $toCurrency
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setToCurrency(array $toCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($toCurrencyArrayErrorMessage = self::validateToCurrencyForArrayConstraintsFromSetToCurrency($toCurrency))) {
            throw new \InvalidArgumentException($toCurrencyArrayErrorMessage, __LINE__);
        }
        $this->toCurrency = $toCurrency;
        return $this;
    }
    /**
     * Add item to toCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToToCurrency(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The toCurrency property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->toCurrency[] = $item;
        return $this;
    }
    /**
     * Get toSubsidiary value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getToSubsidiary()
    {
        return $this->toSubsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setToSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToSubsidiaryForArrayConstraintsFromSetToSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consolidatedExchangeRateSearchRowBasicToSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$consolidatedExchangeRateSearchRowBasicToSubsidiaryItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($consolidatedExchangeRateSearchRowBasicToSubsidiaryItem) ? get_class($consolidatedExchangeRateSearchRowBasicToSubsidiaryItem) : sprintf('%s(%s)', gettype($consolidatedExchangeRateSearchRowBasicToSubsidiaryItem), var_export($consolidatedExchangeRateSearchRowBasicToSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The toSubsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set toSubsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $toSubsidiary
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function setToSubsidiary(array $toSubsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($toSubsidiaryArrayErrorMessage = self::validateToSubsidiaryForArrayConstraintsFromSetToSubsidiary($toSubsidiary))) {
            throw new \InvalidArgumentException($toSubsidiaryArrayErrorMessage, __LINE__);
        }
        $this->toSubsidiary = $toSubsidiary;
        return $this;
    }
    /**
     * Add item to toSubsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\ConsolidatedExchangeRateSearchRowBasic
     */
    public function addToToSubsidiary(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The toSubsidiary property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->toSubsidiary[] = $item;
        return $this;
    }
}
